<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
require_once("bspPaymentGateway.php");
require_once("./config/QueryBuilder.php");


class PaymentRequest{
    private $conn;
    private $queryBuilder;
    private $bspObj;
    private $translationMsg;

    public function __construct($conn)
    {
        $this->conn = $conn;
        $this->queryBuilder = new QueryBuilder($conn);
        $this->bspObj = new BspPaymentGateway();
        $this->translationMsg = json_decode(TRANSLATION_MSG, true);

    }

    private function fetchAndProcessOrder($paymentInfo)
    {
        $orderInfo = $this->bspObj->fetchOrder($paymentInfo);
        $status = 'UNKNOWN';
        if (isset($orderInfo['status'])) {
            switch (strtolower($orderInfo['status'])) {
                case 'success':
                    $status = 'SUCCESS';
                    break;
                case 'cancel':
                    $status = 'CANCELLED';
                    break;
                case 'fail':
                    $status = 'FAILED';
                    break;
                case 'refused':
                    $status = 'REFUSED';
                    break;
                default:
                    $status = 'UNKNOWN';
                    break;
            }
        }
        return ['orderInfo' => $orderInfo, 'status' => $status];
    }   
    public function paymentRequest($data, $screenName, $tableName, $merchantDetails)
    {
        if ($data['gatewayConfig']) {
            echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>' . $this->translationMsg['TXN_ID_ALREADY_GENERATED'] . '</h4>
                    </div>';
            } else {
            $currencyCode = $merchantDetails['currencyCode'];
            $activeGateway = $data['paymentOption'];
            $txnId = time();        
            $gatewayJSON = <<<GATEWAYJSON
            {
                "merchant_key": "{$merchantDetails['merchantKey']}",
                "checkoutURL": "{$merchantDetails['checkoutUrl']}",
                "currencyCode": "{$merchantDetails['currencyCode']}",
                "accessToken": "{$merchantDetails['accessToken']}"               
            }
            GATEWAYJSON;
            
            $updateData = [
                'txnId' => $txnId,
                'gatewayConfig' => $gatewayJSON,
                'currency' => $currencyCode,
                'academyLocationId' => $data['academyLocationId'],
                'paymentOption' => $activeGateway
            ];
            $where = ['id' => $data['id']];
            $result = $this->queryBuilder->update($tableName, $updateData, $where);

            if ($result == 1) {
                $paymentRequestColumnData = [
                    'txnId' => $txnId,
                    'screen' => $screenName,
                    'paymentDate' => date('Y-m-d H:i:s'),
                    'onlinePaymentId' => !empty($data['onlinePaymentId']) ? $data['onlinePaymentId'] : (isset($data['onlinePaymentId']) ? 0 : NULL),
                    'paymentId' => $data['id'],
                    'payment_gateway' => $activeGateway
                ];
                $this->queryBuilder->insert('payment_request', $paymentRequestColumnData);

                $where = ['id' => $data['id']];
                $paymentDetails = $this->queryBuilder->selectById($tableName, '*', $where);
                $gatewayInfo = '';
                if ($paymentDetails && $paymentDetails['gatewayConfig']) {
                    $gatewayInfoArr = json_decode($paymentDetails['gatewayConfig'], true);
                    $requiredKeys = ['merchant_key', 'checkoutURL', 'currencyCode', 'accessToken'];
                    if (count(array_filter($gatewayInfoArr, fn($value) => !empty($value) && isset($value))) === count($requiredKeys)) {
                        $gatewayInfo = 'EXIST';
                    }
                }

                if (!$paymentDetails || $paymentDetails == 0 || $gatewayInfo == '') {
                    echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
                            </div>';
                } else {               
                    $paymentRequest = $this->bspObj->createOrder($paymentDetails);
                    if (isset($paymentRequest['checkoutURL']) && isset($paymentRequest['merchantKey']) && isset($paymentRequest['encryptedPayload'])) {
                        $updateData = ['paymentRequest' => json_encode($paymentRequest)];
                        $where = ['id' => $data['id'],'txnId'=> $txnId];
                        $result = $this->queryBuilder->update($tableName, $updateData, $where);
                        echo '
                        <html>
                            <head>
                                <title>Make Payment</title>
                            </head>
                            <body>
                                <center>
                                    <h1>Please do not refresh this page...</h1>
                                </center>
                                <form style="display: none" id="bsp-form" method="post" action="' . $paymentRequest['checkoutURL'] . '" name="bsp">
                                    <input type="hidden" name="order_id" value="' . $txnId . '">
                                    <input type="hidden" name="merchant_key" value="' . $paymentRequest['merchantKey'] . '">
                                    <input type="hidden" name="URL" value="' . $paymentRequest['callbackUrl'] . '">
                                    <input type="hidden" name="URLC" value="en">
                                    <input type="hidden" name="order_details" value="' . $paymentRequest['encryptedPayload'] . '">
                                    <script type="text/javascript"> document.bsp.submit(); </script>
                                </form>
                            </body>
                        </html>';
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-warning">
                                <h4>' . $this->translationMsg['PAYMENT_GATEWAY_SERVER_ERROR'] . '</h4>
                                </div>';
                    }
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
                        </div>';
            }
        }
    }

    public function onlinePaymentReceipt($paymentRequest, $connMain)
    {
        $txnId = $paymentRequest['txnId'];
        require_once "academia/onlinePayment.php";
        $tableName = 'online_payment';
        $onlinePaymentObj = new OnlinePayment();
        $onlinePaymentObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];
        $onlinePaymentInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        $onlinePaymentInfo['encryptedData'] = $paymentRequest['responseData']['trx'];
        if ($onlinePaymentInfo) {
            if ($onlinePaymentInfo['formSubmissionStatus'] != 1) {
                $orderData = $this->fetchAndProcessOrder($onlinePaymentInfo);
                $orderInfo = $orderData['orderInfo'];
                $status = $orderData['status'];
                $updateData = [
                    'notificationResponse' => json_encode($orderInfo),
                    'formSubmissionStatus' => 1,
                    'paymentStatus' => $status
                ];
                $where = ['id' => $paymentRequest['paymentId']];
                $this->queryBuilder->update($tableName, $updateData, $where);             
                if ($status == 'SUCCESS'  && $orderInfo['order_id'] == $txnId) {                 
                    $response = $onlinePaymentObj->createReceipt($onlinePaymentInfo['onlinePaymentId'], $txnId, $status);
                        if ($response == 'SUCCESS') {
                            $updateData = ['receiptStatus' => $response];                            
                            $where = ['id' => $paymentRequest['paymentId']];
                            $result = $this->queryBuilder->update($tableName, $updateData, $where);
                            echo '<div class="col-md-12 text-center alert alert-success">
                                        <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']) . '</h4>
                                </div>';
                        } else {
                            echo '<div class="col-md-12 text-center alert alert-success">
                            <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']) . '</h4>
                         </div>';
                        }
                } else {
                    
                    echo '<div class="col-md-12 text-center alert alert-warning">
                     <h4>' . str_replace("[ORDER_STATUS]", $status, $this->translationMsg['TRANSACTION_NOT_SUCCESS']) . '</h4>
                </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
            </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
              <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
          </div>';
        }
    }
    public function declarationPaymentReceipt($paymentRequest, $connMain)
    {
        $txnId = $paymentRequest['txnId'];
        require_once("academia/declarationPayment.php");
        $tableName = 'declaration_payment';
        $declarationPaymentObj = new DeclarationPayment();
        $declarationPaymentObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];
        $declarationPaymentInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        $declarationPaymentInfo['encryptedData'] = $paymentRequest['responseData']['trx'];
        if ($declarationPaymentInfo) {
            if ($declarationPaymentInfo['formSubmissionStatus'] != 1) {
                $orderData = $this->fetchAndProcessOrder($declarationPaymentInfo);
                $orderInfo = $orderData['orderInfo'];
                $status = $orderData['status'];
                $updateData = [
                    'notificationResponse' => json_encode($orderInfo),
                    'formSubmissionStatus' => 1,
                    'paymentStatus' => $status
                ];
                $where = ['id' => $paymentRequest['paymentId']];
                $this->queryBuilder->update($tableName, $updateData, $where);
                if ($status == 'SUCCESS' && $orderInfo['order_id'] == $txnId) {                    
                    $declarationPaymentInfo['paymentStatus'] = $status;
                    $response = $declarationPaymentObj->createReceipt($declarationPaymentInfo);
                    if (isset($response['status']) && $response['status'] == 'SUCCESS') {
                        $updateData = ['receiptStatus' => $response['status'], 'receiptId' => $response['receiptId']];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $result = $this->queryBuilder->update($tableName, $updateData, $where);
                        echo '<div class="col-md-12 text-center alert alert-success">
                                    <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']) . '</h4>
                            </div>';
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-success">
                         <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']) . '</h4>
                     </div>';
                    }
                } else {                    
                    echo '<div class="col-md-12 text-center alert alert-warning">
                     <h4>' . str_replace("[ORDER_STATUS]", $status, $this->translationMsg['TRANSACTION_NOT_SUCCESS']) . '</h4>
                </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
            </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
              <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
          </div>';
        }
    }
    

    public function courseEnrollementPaymentReceipt($paymentRequest, $connMain)
    {
        $txnId = $paymentRequest['txnId'];      
        require_once "academia/courseEnrollement.php";
        $tableName = 'enrollment_payment';
        $courseEnrollementPaymentObj = new CourseEnrollement();
        $courseEnrollementPaymentObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];
        $courseEnrollementInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        $courseEnrollementInfo['encryptedData'] = $paymentRequest['responseData']['trx'];
        if ($courseEnrollementInfo) {
            if ($courseEnrollementInfo['formSubmissionStatus'] != 1) {
                $orderData = $this->fetchAndProcessOrder($courseEnrollementInfo);
                $orderInfo = $orderData['orderInfo'];
                $status = $orderData['status'];
                $updateData = [
                    'notificationResponse' => json_encode($orderInfo),
                    'formSubmissionStatus' => 1,
                    'paymentStatus' => $status
                ];
                $where = ['id' => $paymentRequest['paymentId']];
                $this->queryBuilder->update($tableName, $updateData, $where);                
                if ($status == 'SUCCESS' && $orderInfo['order_id'] == $txnId) {                  
                    $response = $courseEnrollementPaymentObj->createReceipt($courseEnrollementInfo['onlinePaymentId'], $txnId, $status);
                    if ($response == 'SUCCESS') {
                        $updateData = ['receiptStatus' => $response];                            
                        $where = ['id' => $paymentRequest['paymentId']];
                        $result = $this->queryBuilder->update($tableName, $updateData, $where);
                        echo '<div class="col-md-12 text-center alert alert-success">
                                 <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']) . '</h4>
                         </div>';
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-success">
                               <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']) . '</h4>
                            </div>';
                    }
                } else {                    
                    echo '<div class="col-md-12 text-center alert alert-warning">
                    <h4>' . str_replace("[ORDER_STATUS]", $status, $this->translationMsg['TRANSACTION_NOT_SUCCESS']) . '</h4>
                </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
            </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
              <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
          </div>';
        }
    }

    public function RevaluationReceipt($paymentRequest, $connMain)
    {
        $txnId = $paymentRequest['txnId'];
        require_once("academia/revaluationPayment.php");
        $tableName = 'reval_payment';
        $revalObj = new RevaluationPayment();
        $revalObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];
        $revalInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        $revalInfo['encryptedData'] = $paymentRequest['responseData']['trx'];
        if($revalInfo){
            if ($revalInfo['formSubmissionStatus'] != 1) {
                $orderData = $this->fetchAndProcessOrder($revalInfo);
                $orderInfo = $orderData['orderInfo'];
                $status = $orderData['status'];
                $updateData = [
                    'notificationResponse' => json_encode($orderInfo),
                    'formSubmissionStatus' => 1,
                    'paymentStatus' => $status
                ];
                $where = ['id' => $paymentRequest['paymentId']];
                $this->queryBuilder->update($tableName, $updateData, $where);                
                if ($status == 'SUCCESS' && $orderInfo['order_id'] == $txnId) {                  
                   $response = $revalObj->createReceipt($revalInfo['id'],$revalInfo['amount'], $txnId, $status);
                        if(isset($response) && isset($response['status']) == 'SUCCESS'){
                        $updateData = ['receiptStatus' => $response];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $result = $this->queryBuilder->update($tableName, $updateData, $where);
                      echo '<div class="col-md-12 text-center alert alert-success">
                                <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']) . '</h4>
                             </div>';
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-success">
                                <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']) . '</h4>
                        </div>';
                    }
                }else {                    
                    echo '<div class="col-md-12 text-center alert alert-warning">
                   <h4>' . str_replace("[ORDER_STATUS]", $status, $this->translationMsg['TRANSACTION_NOT_SUCCESS']) . '</h4>
                </div>';
                }
            }else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                 <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
            </div>';
       }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
              <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
          </div>';
        }
    }

    public function examAssessmentReceipt($paymentRequest, $connMain)
    {
        $txnId = $paymentRequest['txnId'];
        require_once "academia/examinationPayment.php";
        $tableName = 'assessment_payment';
        $examObj = new ExaminationPayment();
        $examObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];
        $examInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        $examInfo['encryptedData'] = $paymentRequest['responseData']['trx'];
        if ($examInfo) {
            if ($examInfo['formSubmissionStatus'] != 1) {
                $orderData = $this->fetchAndProcessOrder($examInfo);
                $orderInfo = $orderData['orderInfo'];
                $status = $orderData['status'];
                $updateData = [
                    'notificationResponse' => json_encode($orderInfo),
                    'formSubmissionStatus' => 1,
                    'paymentStatus' => $status
                ];
                $where = ['id' => $paymentRequest['paymentId']];
                $this->queryBuilder->update($tableName, $updateData, $where);
                if ($status == 'SUCCESS' && $orderInfo['order_id'] == $txnId) {                   
                    $examInfo['paymentStatus'] = $status;
                    $response = $examObj->createReceipt($examInfo['id'], $examInfo['academyLocationId'], $txnId, $examInfo['amount'],$examInfo['currency']);
                    
                    if (isset($response['status']) && $response['status'] == 'SUCCESS') {
                        $updateData = ['receiptStatus' => $response['status']];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $result = $this->queryBuilder->update($tableName, $updateData, $where);
                        $tableName2 = 'assessment_payment_detail';
                        $updateDataDetail = ['receiptId' => $response['receiptId']];
                        $updateWhere = ['examAssessmentPaymentId' => $paymentRequest['paymentId']];
                        $result2 = $this->queryBuilder->update($tableName2, $updateDataDetail, $updateWhere);
                        echo '<div class="col-md-12 text-center alert alert-success">
                                       <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']) . '</h4>
                                </div>';
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-success">
                            <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']) . '</h4>
                         </div>';
                    }
                } else {                    
                    echo '<div class="col-md-12 text-center alert alert-warning">
                    <h4>' . str_replace("[ORDER_STATUS]", $status, $this->translationMsg['TRANSACTION_NOT_SUCCESS']) . '</h4>
                </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
            </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
              <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
          </div>';
        }
    }

    public function sendPaymentLinkReceipt($paymentRequest, $connMain)
    {
        $txnId = $paymentRequest['txnId'];
        require_once("academia/sendPaymentLinkPayment.php");
        $tableName = 'online_payment';
        $sendPaymentLinkObj = new SendPaymentLinkPayment();
        $sendPaymentLinkObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];
        $sendPaymentLinkInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        $sendPaymentLinkInfo['encryptedData'] = $paymentRequest['responseData']['trx'];
        if($sendPaymentLinkInfo){
            if ($sendPaymentLinkInfo['formSubmissionStatus'] != 1) {   
                $orderData = $this->fetchAndProcessOrder($sendPaymentLinkInfo);
                $orderInfo = $orderData['orderInfo'];
                $status = $orderData['status'];
                $updateData = [
                    'notificationResponse' => json_encode($orderInfo),
                    'formSubmissionStatus' => 1,
                    'paymentStatus' => $status
                ];
                $where = ['id' => $paymentRequest['paymentId']];
                $this->queryBuilder->update($tableName, $updateData, $where);
                
                if ($status == 'SUCCESS' && $orderInfo['order_id'] == $txnId) {                    
                    $response = $sendPaymentLinkObj->createReceipt($sendPaymentLinkInfo['sendPaymentLinkId'],$sendPaymentLinkInfo['onlinePaymentId'], $txnId, $status);
                    
                    if ($response == 'SUCCESS') {
                        $updateData = ['receiptStatus' => $response];                            
                        $where = ['id' => $paymentRequest['paymentId']];
                        $result = $this->queryBuilder->update($tableName, $updateData, $where);
                        echo '<div class="col-md-12 text-center alert alert-success">
                                    <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']) . '</h4>
                            </div>';
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-success">
                        <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']) . '</h4>
                     </div>';
                    }
                } else {                   
                    echo '<div class="col-md-12 text-center alert alert-warning">
                           <h4>' . str_replace("[ORDER_STATUS]", $status, $this->translationMsg['TRANSACTION_NOT_SUCCESS']) . '</h4>
                        </div>';
                }
            }else {
                echo '<div class="col-md-12 text-center alert alert-warning">
               <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
            </div>';
            }

        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
              <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
          </div>';
        }
    }

    public function advancePaymentReceipt($paymentRequest, $connMain)
    {
        $txnId = $paymentRequest['txnId'];
        require_once "academia/advancePayment.php";
        $tableName = 'advance_payment';
        $advancePaymentObj = new AdvancePayment();
        $advancePaymentObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];
        $advancePaymentInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        $advancePaymentInfo['encryptedData'] = $paymentRequest['responseData']['trx'];
        if ($advancePaymentInfo) {
            if ($advancePaymentInfo['formSubmissionStatus'] != 1) {
                $orderData = $this->fetchAndProcessOrder($advancePaymentInfo);
                $orderInfo = $orderData['orderInfo'];
                $status = $orderData['status'];
                $updateData = [
                    'notificationResponse' => json_encode($orderInfo),
                    'formSubmissionStatus' => 1,
                    'paymentStatus' => $status
                ];
                $where = ['id' => $paymentRequest['paymentId']];
                $this->queryBuilder->update($tableName, $updateData, $where);
                if ($status == 'SUCCESS' && $orderInfo['order_id'] == $txnId) {                    
                    $advancePaymentInfo['paymentStatus'] = $status;
                    $response = $advancePaymentObj->createReceipt($advancePaymentInfo);
                    if (isset($response['status']) && $response['status'] == 'SUCCESS') {
                        $updateData = ['receiptStatus' => $response['status'], 'receiptId' => $response['receiptId']];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $result = $this->queryBuilder->update($tableName, $updateData, $where);
                        echo '<div class="col-md-12 text-center alert alert-success">
                                    <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']) . '</h4>
                            </div>';
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-success">
                         <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']) . '</h4>
                     </div>';
                    }
                } else {
                    $updateData = ['notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    echo '<div class="col-md-12 text-center alert alert-warning">
                     <h4>' . str_replace("[ORDER_STATUS]", $status, $this->translationMsg['TRANSACTION_NOT_SUCCESS']) . '</h4>
                </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
            </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
              <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
          </div>';
        }
    }

    public function donationPaymentReceipt($paymentRequest, $connMain)
    {
        require_once("academia/donationPayment.php");
        $tableName = 'donation_payment';
        $txnId = $paymentRequest['txnId'];
        $donationObj = new DonationPayment();
        $donationObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];
        $donationInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        $donationInfo['encryptedData'] = $paymentRequest['responseData']['trx'];
        if ($donationInfo) {
            if ($donationInfo['formSubmissionStatus'] != 1 && isset($paymentRequest['txnId'])) {
                $orderData = $this->fetchAndProcessOrder($donationInfo);
                $orderInfo = $orderData['orderInfo'];
                $status = $orderData['status'];
                $updateData = [
                    'notificationResponse' => json_encode($orderInfo),
                    'formSubmissionStatus' => 1,
                    'paymentStatus' => $status
                ];
                $where = ['id' => $paymentRequest['paymentId']];
                $this->queryBuilder->update($tableName, $updateData, $where);
                if ($status == 'SUCCESS' && $orderInfo['order_id'] == $txnId) {                  
                    $response = $donationObj->createReceipt($donationInfo, 'TXN_SUCCESS');
                    if ($response == 'SUCCESS') {
                        $updateData = ['receiptStatus' => $response];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $result = $this->queryBuilder->update($tableName, $updateData, $where);
                        echo '<div class="col-md-12 text-center alert alert-success">
                                   <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']) . '</h4>
                            </div>';
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-success">
                                    <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']) . '</h4>
                                </div>';
                    }
                } else {
                    
                    echo '<div class="col-md-12 text-center alert alert-warning">
                           <h4>' . str_replace("[ORDER_STATUS]", $status, $this->translationMsg['TRANSACTION_NOT_SUCCESS']) . '</h4>
                        </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '.</h4>
                    </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
              <h4>' . $this->translationMsg['TRANSACTION_DATA_NOT_FOUND'] . '</h4>
          </div>';
        }
    }
}