## DPO Payment Gateway Integration

# Overview:
This module handles payment processing through DPO's API. It allows creating payment orders, verifying payment status, and generating receipts.

# Prerequisites:
- companyToken: Your unique API access token
- ServiceType: Type of service being processed
- environment: API environment (production/sandbox)

# Key Features:
- Processes payments through DPO's API
- Handles payment order creation and verification
- Updates database with payment details
- Generates payment receipts
- Handles success and failure scenarios

# Payment Request File:
This file implements methods for processing payments and generating receipts.

# Key Methods:
1) paymentRequest($data, $screenName, $tableName, $merchantDetails)
- Description: Handles payment requests by validating input, configuring the gateway, and updating payment details
- Flow: 
  - Validate transaction ID
  - Configure payment gateway
  - Create payment order
  - Update database with payment details
  - Redirect to payment page

2) onlinePaymentReceipt($paymentRequest, $connMain)
- Description: Processes online payment receipts by verifying payment details
- Flow:
  - Fetch payment details
  - Verify payment status with gateway
  - Update database with transaction details
  - Generate receipt
  - Display success/failure message

# DPO Payment Gateway File:
The DPOPaymentGateway class handles communication with DPO's API.

# Key Methods:
1) createOrder($data)
- Description: Creates a new payment order
- Flow:
  - Parse gateway configuration
  - Prepare XML request
  - Send API request
  - Handle response
  - Return payment URL

2) fetchOrder($data)
- Description: Verifies payment status
- Flow:
  - Parse gateway configuration
  - Prepare verification request
  - Send API request
  - Handle response
  - Return payment status

# Database Interactions
Tables Used:
- payment_request
- online_payment

QueryBuilder Methods:
- selectById: Fetches specific records
- update: Updates records with provided data
- insert: Creates new records

# Dependencies
Files:
- config/db_config.php
- config/QueryBuilder.php
- Logger.php

# Error Handling
Scenarios:
- Transaction ID already exists
- Payment could not be processed
- Missing gateway configuration
- API communication failures

User Feedback:
- Displays clear error messages using Bootstrap alerts

# Usage Instructions
1) Setup Database:
   - Ensure payment_request and online_payment tables exist
   - Configure database connection in db_config.php

2) Payment Gateway Integration:
   - Configure companyToken, ServiceType and environment
   - Test API communication

3) Server Configuration:
   - Ensure PHP and cURL are enabled
   - Configure proper SSL settings for production

4) Testing:
   - Test payment flow with dummy data
   - Verify receipt generation
   - Check database updates

# Notes
- Ensure proper SSL configuration for production
- Validate all inputs to prevent errors
- Log API requests and responses for debugging
- Handle API timeouts gracefully

# Conclusion:
This module provides a robust integration with DPO's payment gateway, handling all aspects of payment processing from order creation to receipt generation. With proper configuration and testing, it can be seamlessly integrated into applications requiring DPO payment processing.
