<?php
require_once "./config/db_config.php";
class DPOPaymentGateway
{
    public $domainURL;
    public function __construct()
    {
        $this->domainURL = domainURL;
    }

    public function createOrder($data)
    {       
            
        if($data['currency'] == 'R' || strtolower($data['currency']) == 'rand'){
            $data['currency'] = 'ZAR';
        }
        $gatewayJson  = json_decode($data['gatewayConfig'], true);        
        $companyToken = $gatewayJson['companyToken'];
        $serviceType  = $gatewayJson['serviceType'];
        $environment  = $gatewayJson['environment'];
        $date         = date("Y/m/d H:i");
        $curl         = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL            => $environment . '/API/v6/',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING       => '',
            CURLOPT_MAXREDIRS      => 10,
            CURLOPT_TIMEOUT        => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST  => 'POST',
            CURLOPT_POSTFIELDS     => '<?xml version="1.0" encoding="utf-8"?>
          <API3G>
              <CompanyToken>' . $companyToken . '</CompanyToken>
              <Request>createToken</Request>
              <Transaction>
                  <PaymentAmount>' . $data['amount'] . '</PaymentAmount>
                  <PaymentCurrency>' . $data['currency'] . '</PaymentCurrency>
                  <CompanyRef>' . $data['txnId'] . '</CompanyRef>
                  <RedirectURL>' . $this->domainURL . '/paymentResponse.php</RedirectURL>
                  <BackURL>' . $this->domainURL . '/paymentResponse.php</BackURL>
                  <CompanyAccRef>' . $data['txnId'] . '</CompanyAccRef>
                  <CompanyRefUnique>1</CompanyRefUnique>                  
                  <PTL>15</PTL>
              </Transaction>
              <Services>
                  <Service>
                      <ServiceType>' . $serviceType . '</ServiceType>
                      <ServiceDescription>Fee Payment</ServiceDescription>
                      <ServiceDate>' . $date . '</ServiceDate>
                  </Service>
              </Services>
          </API3G>
          ',
            CURLOPT_HTTPHEADER     => [
                'Content-Type: application/xml',
                'Accept: application/json',
            ],
        ]);

        $response = curl_exec($curl);

        curl_close($curl);
        $jsonResponse = json_encode(simplexml_load_string($response));
        $decoded      = json_decode($jsonResponse, true);
        return [
            'status'       => isset($decoded['TransToken']) ? 'SUCCESS' : 'FAILED',
            'jsonResponse' => $jsonResponse,
            'url'          => isset($decoded['TransToken']) ? $environment . "/payv3.php?ID=" . $decoded['TransToken'] : ''
        ];
    
    }

    public function fetchOrder($data)
    {
        $gatewayJson  = json_decode($data['gatewayConfig'], true);
        $companyToken = $gatewayJson['companyToken'];        
        $environment  = $gatewayJson['environment'];
        $txnToken = $data['txnId'];

        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL            => $environment.'/API/v6/',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING       => '',
            CURLOPT_MAXREDIRS      => 10,
            CURLOPT_TIMEOUT        => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST  => 'POST',
            CURLOPT_POSTFIELDS     => '<?xml version="1.0" encoding="utf-8"?>
        <API3G>
        <CompanyToken>'.$companyToken.'</CompanyToken>
        <Request>verifyToken</Request>
        <CompanyRef>' . $txnToken . '</CompanyRef>
        </API3G>',
            CURLOPT_HTTPHEADER     => [
                'Content-Type: application/xml',
                'Accept: application/json',
            ],
        ]);

        $response = curl_exec($curl);

        curl_close($curl);
        $jsonResponse = json_encode(simplexml_load_string($response));
        $decoded  = json_decode($jsonResponse, true);
            return[
                'status' => ($decoded['Result']=='000' && $decoded['ResultExplanation'] == 'Transaction Paid') ?'SUCCESS':$decoded['ResultExplanation'],
                'AccRef' => isset($decoded['AccRef'])? $decoded['AccRef']:'',
                'response' => $jsonResponse
        ];   
    }

}
