<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
require_once 'jncbPaymentGateway.php';
require_once './config/QueryBuilder.php';

class PaymentRequest
{
    private $conn;
    private $queryBuilder;

    private $jncbObj;

    public function __construct($conn)
    {
        $this->conn = $conn;
        $this->queryBuilder = new QueryBuilder($conn);
        $this->jncbObj = new JncbPaymentGateway();
    }

    public function paymentRequest($data, $screenName, $tableName, $merchantDetails)
    {
        if ($data['txnId']) {
            echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>Please try again later because Transaction ID already generated for this order.</h4>
                    </div>';
        } else {
            if(empty($data['currency']))
            {
                echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>Payment Cannot be processed , because Currency is not set. Please Contact Admin.</h4>
                    </div>';
            }
            else
            {
                $currencyCode = $data['currency'];
                $activeGateway = $data['paymentOption'];
                $gatewayJSON = <<<GATEWAYJSON
                {
                    "powerTranz_id": "{$merchantDetails['username']}",
                    "powerTranz_password": "{$merchantDetails['password']}",
                    "pageSet": "{$merchantDetails['safekey']}",
                    "env": "{$merchantDetails['environment']}",
                    "pageName": "{$merchantDetails['currencyCode']}"
                }
                GATEWAYJSON;
                $OrderIdentifier = "INT-" . time() . "-Orc";
                $where = ['id' => $data['id']];
                $updateData = ['gatewayConfig' => $gatewayJSON, 'academyLocationId' => $data['academyLocationId'], 'paymentOption' => $activeGateway, 'txnId' => $OrderIdentifier];

                // $currencyCheck = $this->queryBuilder->selectById($tableName, '*', $where);
                // if (isset($currencyCheck['currency']) && $currencyCheck['currency'] == '' ||$currencyCheck['currency'] == NULL)
                //  {

                //     $updateData = ['gatewayConfig' => $gatewayJSON, 'currency' => $currencyCode ,'academyLocationId' => $data['academyLocationId'], 'paymentOption' => $activeGateway, 'txnId' => $OrderIdentifier];

                //  }
                //  else
                //  {

                //  }
                $result = $this->queryBuilder->update($tableName, $updateData, $where);

                if ($result == 1) {
                    $where = ['id' => $data['id']];
                    $updateInfo = $this->queryBuilder->selectById($tableName, '*', $where);
                    $paymentRequest = $this->jncbObj->createOrder($updateInfo);
                    if (isset($paymentRequest['success']) && $paymentRequest['success'] == true && $updateInfo['txnId'] == $paymentRequest['OrderIdentifier']) {
                        $txnId = $updateInfo['txnId'];
                        $updateData = ['paymentRequest' => json_encode($paymentRequest['data'])];
                        $where = ['id' => $data['id']];
                        $result = $this->queryBuilder->update($tableName, $updateData, $where);
                        if ($result == 1) {
                            $paymentRequestColumnData = ['payment_gateway' => $activeGateway, 'screen' => $screenName, 'txnId' => $txnId, 'paymentDate' => date('Y-m-d H:i:s'), 'onlinePaymentId' => !empty($updateInfo['onlinePaymentId']) ? $updateInfo['onlinePaymentId'] : (isset($updateInfo['onlinePaymentId']) ? 0 : null), 'paymentId' => $updateInfo['id']];
                            $requestScreen = $this->queryBuilder->insert('payment_request', $paymentRequestColumnData);
                            if($requestScreen)
                            {
                            $columns = ['academyLocationId', 'txnId', 'gatewayConfig'];
                            $additionalConditions = "COALESCE(academyLocationId, '') <> '' AND COALESCE(txnId, '') <> ''";
                            $where = ['id' => $data['id']];
                            $result = $this->queryBuilder->selectById($tableName, $columns, $where, $additionalConditions);
                            $gatewayInfo = '';
                            if ($result && $result['gatewayConfig']) {
                                $gatewayInfoArr = json_decode($result['gatewayConfig'], true);
                                if (isset($gatewayInfoArr['powerTranz_id']) && $gatewayInfoArr['powerTranz_id'] && isset($gatewayInfoArr['powerTranz_password']) && $gatewayInfoArr['powerTranz_password'] && isset($gatewayInfoArr['pageSet']) && $gatewayInfoArr['pageSet'] && isset($gatewayInfoArr['env']) && $gatewayInfoArr['env'] && isset($gatewayInfoArr['pageName']) && $gatewayInfoArr['pageName']) {
                                    $gatewayInfo = 'EXIT';
                                }
                            }
                            if (!$result || $result == 0 || $gatewayInfo == '') {
                                echo '<div class="col-md-12 text-center alert alert-warning">
                                    <h4>Unfortunately, Your transaction could not be processed. Please try again.</h4>
                                </div>';
                            } else {
                                echo $paymentRequest['redirectHTML'];
                            }
                            }else
                            {
                                echo '<div class="col-md-12 text-center alert alert-warning">
                                    <h4>Unfortunately, Your transaction could not be processed. Server Error.</h4>
                                </div>';
                            }

                        } else {
                            echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>Unfortunately, Your transaction could not be processed. Please try again.</h4>
                             </div>';
                        }
                    } else {
                        $errorReson = isset($paymentRequest['Errors']) ? $paymentRequest['ResponseMessage'] : '';
                        if ($errorReson) {
                            $updateData = ['paymentStatus'=> isset($paymentRequest['ResponseMessage'])?$paymentRequest['ResponseMessage']:'','notificationResponse' => json_encode($paymentRequest), 'formSubmissionStatus' => 1];
                            $where = ['id' => $data['id']];
                            $this->queryBuilder->update($tableName, $updateData, $where);
                            $error = 'Unfortunately, Your transaction could not be processed. because ' . $errorReson . ' Please try again';
                        } else {
                            $error = 'Unfortunately, Your transaction could not be processed. Please try again.';
                        }
                        echo '<div class="col-md-12 text-center alert alert-warning">
                                <h4>' . $error . '</h4>
                                 </div>';
                    }
                } else {
                    echo '<div class="col-md-12 text-center alert alert-warning">
                          <h4>Unfortunately, Your transaction could not be processed. Please try again.</h4>
                          </div>';
                }
            }
        }
    }

    public function onlinePaymentReceipt($paymentRequest, $connMain)
    {
        $txnId = $paymentRequest['txnId'];
        require_once "academia/onlinePayment.php";
        $tableName = 'online_payment';
        $onlinePaymentObj = new OnlinePayment();
        $onlinePaymentObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];
        $onlinePaymentInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        if ($onlinePaymentInfo) {
            if ($onlinePaymentInfo['formSubmissionStatus'] != 1) {
                $onlinePaymentInfo['tableName'] = $tableName;
                $onlinePaymentInfo['conn'] = $this->conn;
                $orderInfo = $this->jncbObj->fetchOrder($onlinePaymentInfo);
                if ($orderInfo['IsoResponseCode'] == '00' && $orderInfo['OrderSummary']['OrderIdentifier'] == $txnId) {
                    $updateData = ['notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1, 'paymentStatus' => 'SUCCESS'];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    $response = $onlinePaymentObj->createReceipt($onlinePaymentInfo['onlinePaymentId'], $txnId, $orderInfo['IsoResponseCode']);
                    if ($response == 'SUCCESS') {

                        $updateData = ['receiptStatus' => $response];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $result = $this->queryBuilder->update($tableName, $updateData, $where);
                        echo '<div class="col-md-12 text-center alert alert-success">
                                            <h4>Fee Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is ' . $txnId . '.<br /> Please close the window.</h4>
                                    </div>';

                    } else {
                        echo '<div class="col-md-12 text-center alert alert-success">
                                           <h4>Fee Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is ' . $txnId . '.<br /> However, the receipt could not be generated. Please contact the administrator for assistance. You may now close this window..</h4>
                                        </div>';
                    }

                } else {
                    $updateData = ['paymentStatus'=> isset($orderInfo['ResponseMessage'])?$orderInfo['ResponseMessage']:'' ,'notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    echo '<div class="col-md-12 text-center alert alert-warning">
                                    <h4>Your transaction status is ' . $orderInfo['ResponseMessage'] . '. Please try again.</h4>
                            </div>';
                }

            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>Unfortunately, Your transaction could not be processed. Please try again.</h4>
                    </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
              <h4>Unfortunately, Your transaction could not be processed becuase your order details not found. Please contact to administrator.</h4>
          </div>';
        }
    }

    public function courseEnrollementPaymentReceipt($paymentRequest, $connMain)
    {$txnId = $paymentRequest['txnId'];
        require_once "academia/courseEnrollement.php";
        $tableName = 'enrollment_payment';
        $courseEnrollementPaymentObj = new CourseEnrollement();
        $courseEnrollementPaymentObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];
        $courseEnrollementInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        if ($courseEnrollementInfo) {
            if ($courseEnrollementInfo['formSubmissionStatus'] != 1) {
                $courseEnrollementInfo['tableName'] = $tableName;
                $courseEnrollementInfo['conn'] = $this->conn;
                $orderInfo = $this->jncbObj->fetchOrder($courseEnrollementInfo);
                if ($orderInfo['IsoResponseCode'] == '00' && $orderInfo['OrderSummary']['OrderIdentifier'] == $txnId) {
                    $updateData = ['notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1,'paymentStatus' => 'SUCCESS'];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    $response = $courseEnrollementPaymentObj->createReceipt($courseEnrollementInfo['onlinePaymentId'], $txnId, $orderInfo['IsoResponseCode']);
                    if ($response == 'SUCCESS') {
                        $updateData = ['receiptStatus' => $response];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $result = $this->queryBuilder->update($tableName, $updateData, $where);
                        echo '<div class="col-md-12 text-center alert alert-success">
                                 <h4>Fee Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is ' . $txnId . '.<br /> Please close the window.</h4>
                         </div>';

                    } else {
                        echo '<div class="col-md-12 text-center alert alert-success">
                               <h4>Fee Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is ' . $txnId . '.<br /> However, the receipt could not be generated. Please contact the administrator for assistance. You may now close this window..</h4>
                            </div>';
                    }
                } else {
                    $updateData = ['paymentStatus'=> isset($orderInfo['ResponseMessage'])?$orderInfo['ResponseMessage']:'','notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>Your transaction status is ' . $orderInfo['ResponseMessage'] . '. Please try again.</h4>
                    </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                <h4>Unfortunately, Your transaction could not be processed. Please try again.</h4>
            </div>';
            }

        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
              <h4>Unfortunately, Your transaction could not be processed becuase your order details not found. Please contact to administrator.</h4>
          </div>';
        }}

    public function examAssessmentReceipt($paymentRequest, $connMain)
    {
        $txnId = $paymentRequest['txnId'];
        require_once "academia/examinationPayment.php";
        $tableName = 'assessment_payment';
        $examObj = new ExaminationPayment();
        $examObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];
        $examInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        if ($examInfo) {
            if ($examInfo['formSubmissionStatus'] != 1) {
                $activeGateway = $examInfo['paymentOption'];
                $examInfo['tableName'] = $tableName;
                $examInfo['conn'] = $this->conn;
                $orderInfo = $this->jncbObj->fetchOrder($examInfo);
                if ($orderInfo['IsoResponseCode'] == '00' && $orderInfo['OrderSummary']['OrderIdentifier'] == $txnId) {
                    $updateData = ['notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1,'paymentStatus' => 'SUCCESS'];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    $response = $examObj->createReceipt($examInfo['id'], $examInfo['academyLocationId'], $txnId, $examInfo['amount'],$examInfo['currency']);
                    if (isset($response['status']) && $response['status'] == 'SUCCESS') {
                        $updateData = ['receiptStatus' => $response['status']];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $result = $this->queryBuilder->update($tableName, $updateData, $where);
                        $tableName2 = 'assessment_payment_detail';
                        $updateDataDetail = ['receiptId' => $response['receiptId']];
                        $updateWhere = ['examAssessmentPaymentId' => $paymentRequest['paymentId']];
                        $result2 = $this->queryBuilder->update($tableName2, $updateDataDetail, $updateWhere);
                        echo '<div class="col-md-12 text-center alert alert-success">
                                        <h4>Exam Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is ' . $txnId . '.<br /> Please close the window.</h4>
                                </div>';
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-success">
                            <h4>Exam Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is ' . $txnId . '.<br /> However, the receipt could not be generated. Please contact the administrator for assistance. You may now close this window..</h4>
                         </div>';
                    }
                } else {
                    $updateData = ['paymentStatus'=> isset($orderInfo['ResponseMessage'])?$orderInfo['ResponseMessage']:'','notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>Your transaction status is ' . $orderInfo['ResponseMessage'] . '. Please try again.</h4>
                         </div>';
                }

            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                <h4>Unfortunately, Your transaction could not be processed. Please try again.</h4>
            </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
            <h4>Unfortunately, Your transaction could not be processed becuase your order details not found. Please contact to administrator.</h4>
        </div>';
        }
    }

    public function declarationPaymentReceipt($paymentRequest, $connMain)
    {
        $txnId = $paymentRequest['txnId'];
        require_once "academia/declarationPayment.php";
        $tableName = 'declaration_payment';
        $declarationPaymentObj = new DeclarationPayment();
        $declarationPaymentObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];
        $declarationPaymentInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        if ($declarationPaymentInfo) {
            if ($declarationPaymentInfo['formSubmissionStatus'] != 1) {
                $activeGateway = $declarationPaymentInfo['paymentOption'];
                $declarationPaymentInfo['tableName'] = $tableName;
                $declarationPaymentInfo['conn'] = $this->conn;
                    $orderInfo = $this->jncbObj->fetchOrder($declarationPaymentInfo);
                    if ($orderInfo['IsoResponseCode'] == '00' && $orderInfo['OrderSummary']['OrderIdentifier'] == $txnId) {
                        $updateData = ['notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1,'paymentStatus' => 'SUCCESS'];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $this->queryBuilder->update($tableName, $updateData, $where);
                            $response = $declarationPaymentObj->createReceipt($declarationPaymentInfo);
                            if (isset($response['status']) && $response['status'] == 'SUCCESS') {
                                $updateData = ['receiptStatus' => $response['status'], 'receiptId' => $response['receiptId']];
                                $where = ['id' => $paymentRequest['paymentId']];
                                $result = $this->queryBuilder->update($tableName, $updateData, $where);
                                echo '<div class="col-md-12 text-center alert alert-success">
                                        <h4>Declaration Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is ' . $txnId . '.<br /> Please close the window.</h4>
                                </div>';
                            } else {
                                echo '<div class="col-md-12 text-center alert alert-success">
                                <h4>Exam Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is ' . $txnId . '.<br /> However, the receipt could not be generated. Please contact the administrator for assistance. You may now close this window..</h4>
                             </div>';
                            }
                    } else {
                        $updateData = ['paymentStatus'=> isset($orderInfo['ResponseMessage'])?$orderInfo['ResponseMessage']:'','notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $this->queryBuilder->update($tableName, $updateData, $where);
                        echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>Your transaction status is ' . $orderInfo['ResponseMessage'] . '. Please try again.</h4>
                        </div>';
                    }


            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
              <h4>Unfortunately, Your transaction could not be processed becuase your order details not found. Please contact to administrator.</h4>
          </div>';
            }
        }else
        {
            echo '<div class="col-md-12 text-center alert alert-warning">
            <h4>Unfortunately, Your transaction could not be processed becuase your order details not found. Please contact to administrator.</h4>
        </div>';
        }
    }

    public function RevaluationReceipt($paymentRequest, $connMain)
    {
        $txnId = $paymentRequest['txnId'];
        require_once("academia/revaluationPayment.php");
        $tableName = 'reval_payment';
        $revalObj = new RevaluationPayment();
        $revalObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];

        $revalInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        if($revalInfo){
            if ($revalInfo['formSubmissionStatus'] != 1) {
                $activeGateway = $revalInfo['paymentOption'];
                $revalInfo['tableName'] = $tableName;
                $revalInfo['conn'] = $this->conn;
                $orderInfo = $this->jncbObj->fetchOrder($revalInfo);
                if ($orderInfo['IsoResponseCode'] == '00' && $orderInfo['OrderSummary']['OrderIdentifier'] == $txnId) {
                    $updateData = ['notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1, 'paymentStatus' => 'SUCCESS'];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    $response = $revalObj->createReceipt($revalInfo['id'],$revalInfo['amount'], $txnId, $orderInfo['IsoResponseCode']);

                    if (isset($response) && isset($response['status'])) {
                        $updateData = ['receiptStatus' => $response['status']];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $result = $this->queryBuilder->update($tableName, $updateData, $where);
                        echo '<div class="col-md-12 text-center alert alert-success">
                                        <h4>Fee Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is ' . $txnId . '.<br /> Please close the window.</h4>
                             </div>';

                    } else {
                        echo '<div class="col-md-12 text-center alert alert-success">
                                    <h4>Fee Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is ' . $txnId . '.<br /> However, the receipt could not be generated. Please contact the administrator for assistance. You may now close this window..</h4>
                        </div>';
                    }
                    } else {
                        $updateData = ['paymentStatus'=> isset($orderInfo['ResponseMessage'])?$orderInfo['ResponseMessage']:'','notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $this->queryBuilder->update($tableName, $updateData, $where);
                        echo '<div class="col-md-12 text-center alert alert-warning">
                                    <h4>Your transaction status is ' . $orderInfo['ResponseMessage'] . '. Please try again.</h4>
                            </div>';
                    }
                } else {
                    echo '<div class="col-md-12 text-center alert alert-warning">
                    <h4>Unfortunately, Your transaction could not be processed. Please try again.</h4>
                </div>';
           }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
              <h4>Unfortunately, Your transaction could not be processed becuase your order details not found. Please contact to administrator.</h4>
          </div>';
        }
    }

    public function sendPaymentLinkReceipt($paymentRequest, $connMain)
    {
        {
            $txnId = $paymentRequest['txnId'];
            require_once("academia/sendPaymentLinkPayment.php");
            $tableName = 'online_payment';
            $sendPaymentLinkObj = new SendPaymentLinkPayment();
            $sendPaymentLinkObj->setConnection($this->conn, $connMain);
            $where = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];
            $sendPaymentLinkInfo = $this->queryBuilder->selectById($tableName, '*', $where);
            if ($sendPaymentLinkInfo) {
                if ($sendPaymentLinkInfo['formSubmissionStatus'] != 1) {
                    $sendPaymentLinkInfo['tableName'] = $tableName;
                    $sendPaymentLinkInfo['conn'] = $this->conn;
                    $orderInfo = $this->jncbObj->fetchOrder($sendPaymentLinkInfo);
                    if ($orderInfo['IsoResponseCode'] == '00' && $orderInfo['OrderSummary']['OrderIdentifier'] == $txnId) {
                        $updateData = ['notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1, 'paymentStatus' => 'SUCCESS'];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);

                    $response = $sendPaymentLinkObj->createReceipt($sendPaymentLinkInfo['sendPaymentLinkId'],$sendPaymentLinkInfo['onlinePaymentId'], $txnId, $orderInfo['IsoResponseCode']);

                    if ($response == 'SUCCESS') {

                        $updateData = ['receiptStatus' => $response];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $result = $this->queryBuilder->update($tableName, $updateData, $where);
                        echo '<div class="col-md-12 text-center alert alert-success">
                                            <h4>Fee Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is ' . $txnId . '.<br /> Please close the window.</h4>
                                    </div>';
                        } else {
                            echo '<div class="col-md-12 text-center alert alert-warning">
                                    <h4>Your transaction status is '.$orderInfo['order_data']['status'].'. Please try again.</h4>
                                </div>';
                        }
                    } else {
                        $updateData = ['paymentStatus'=> isset($orderInfo['ResponseMessage'])?$orderInfo['ResponseMessage']:'','notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $this->queryBuilder->update($tableName, $updateData, $where);
                        echo '<div class="col-md-12 text-center alert alert-warning">
                                <h4>Unfortunately, Your transaction could not be processed becuase order details not found from payment gateway server.</h4>
                            </div>';
                    }
                } else {
                    echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>Unfortunately, Your transaction could not be processed. Please try again.</h4>
                        </div>';
                }

            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                  <h4>Unfortunately, Your transaction could not be processed becuase your order details not found. Please contact to administrator.</h4>
              </div>';
            }
        }
    }

    public function advancePaymentReceipt($paymentRequest, $connMain)
    {
        $txnId = $paymentRequest['txnId'];
        require_once "academia/advancePayment.php";
        $tableName = 'advance_payment';
        $advancePaymentObj = new AdvancePayment();
        $advancePaymentObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];
        $advancePaymentInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        if ($advancePaymentInfo) {
            if ($advancePaymentInfo['formSubmissionStatus'] != 1) {
                $advancePaymentInfo['tableName'] = $tableName;
                $advancePaymentInfo['conn'] = $this->conn;
                $orderInfo = $this->jncbObj->fetchOrder($advancePaymentInfo);
                if ($orderInfo['IsoResponseCode'] == '00' && $orderInfo['OrderSummary']['OrderIdentifier'] == $txnId) {
                    $updateData = ['notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1, 'paymentStatus' => 'SUCCESS'];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);

                    $response = $advancePaymentObj->createReceipt($advancePaymentInfo);

                    if ($response['status'] == 'SUCCESS') {
                        $updateData = ['receiptStatus' => $response['status'] , 'receiptId'=>$response['receiptId'] ];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $result = $this->queryBuilder->update($tableName, $updateData, $where);
                        echo '<div class="col-md-12 text-center alert alert-success">
                                            <h4>Fee Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is ' . $txnId . '.<br /> Please close the window.</h4>
                                    </div>';

                    } else {
                        echo '<div class="col-md-12 text-center alert alert-success">
                                           <h4>Fee Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is ' . $txnId . '.<br /> However, the receipt could not be generated. Please contact the administrator for assistance. You may now close this window..</h4>
                                        </div>';

                    }

                } else {
                    $updateData = ['paymentStatus'=> isset($orderInfo['ResponseMessage'])?$orderInfo['ResponseMessage']:'','notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    echo '<div class="col-md-12 text-center alert alert-warning">
                                    <h4>Your transaction status is ' . $orderInfo['ResponseMessage'] . '. Please try again.</h4>
                            </div>';
                }

            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>Unfortunately, Your transaction could not be processed. Please try again.</h4>
                    </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
              <h4>Unfortunately, Your transaction could not be processed becuase your order details not found. Please contact to administrator.</h4>
          </div>';
        }
    }
}
