<?php
require_once("payuPaymentGateway.php");

require_once("./config/QueryBuilder.php");
// use PaymentGateways\Network\NetworkGateway;
class PaymentRequest{
    private $conn;
    private $queryBuilder;
    private $payUObj ;
    private $translationMsg;
    public function __construct($conn) {
        $this->conn = $conn;
        $this->queryBuilder = new QueryBuilder($conn);
        $this->payUObj = new PayUPaymentGateway();
        $this->translationMsg =  json_decode(TRANSLATION_MSG, true);
    }

    public function paymentRequest($data, $screenName, $tableName, $merchantDetails)
    {  
         if ($data['gatewayConfig']) {
            echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>'.$this->translationMsg['TXN_ID_ALREADY_GENERATED'].'</h4>
                    </div>';
        } else {
            $currencyCode = $data['currency'];           
            $activeGateway = $data['paymentOption'];
            $merchantUserId = isset($merchantDetails['merchantUserId'])?$merchantDetails['merchantUserId']:'';
            $gatewayJSON = <<<GATEWAYJSON
            {
                "supportedPaymentMethods": "{$merchantDetails['supportedPaymentMethods']}",
                "safekey": "{$merchantDetails['safekey']}",
                "currencyCode":"{$merchantDetails['currencyCode']}",
                "username": "{$merchantDetails['username']}",
                "password": "{$merchantDetails['password']}", 
                "environment": "{$merchantDetails['environment']}"          
                          
            }
            GATEWAYJSON;            
            $updateData = ['gatewayConfig' => $gatewayJSON, 'academyLocationId' => $data['academyLocationId'], 'paymentOption' => $activeGateway];
            $where = ['id' => $data['id']];
            $result = $this->queryBuilder->update($tableName, $updateData, $where);
            if($result == 1)
            {
                $paymentRequestColumnData = ['screen' => $screenName, 'paymentDate' => date('Y-m-d H:i:s'), 'onlinePaymentId' => !empty($data['onlinePaymentId']) ? $data['onlinePaymentId'] : (isset($data['onlinePaymentId']) ? 0 : NULL), 'paymentId' => $data['id'], 'payment_gateway' => $activeGateway];
                $this->queryBuilder->insert('payment_request', $paymentRequestColumnData);
                $where = ['id' => $data['id']];
                $paymentDetails = $this->queryBuilder->selectById($tableName, '*', $where);
                $gatewayInfo = '';
                if ($paymentDetails && $paymentDetails['gatewayConfig']) {
                        $gatewayInfoArr = json_decode($paymentDetails['gatewayConfig'], true);      
                        $requiredKeys = ['supportedPaymentMethods', 'safekey', 'currencyCode', 'username', 'password', 'environment'];
                    
                    if (count(array_filter($gatewayInfoArr, fn($value) => !empty($value) && isset($value))) === count($requiredKeys)) {
                        $gatewayInfo = 'EXIST';
                    }                    
                    
                }
                if (!$paymentDetails || $paymentDetails == 0 || $gatewayInfo = '') {

                    echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>'.$this->translationMsg['TRANSACTION_ERROR'].'</h4>
                            </div>';
                }
                else {
                    
                    $paymentRequest = $this->payUObj->createOrder($paymentDetails);                                          
                    if(isset($paymentRequest['status']) && isset($paymentRequest['url']) && $paymentRequest['status'] == 'SUCCESS')
                    {
                        $updateData = ['paymentRequest' => json_encode($paymentRequest) , 'txnId' => $paymentRequest['txnId']];
                        $where = ['id' => $data['id']];
                        $result = $this->queryBuilder->update($tableName, $updateData, $where); 

                        $paymmentRequestColumnData = ['txnId' => $paymentRequest['txnId'] ]  ;                        
                        $where = ['paymentId' => $data['id'] , 'screen' => $screenName];
                        $result = $this->queryBuilder->update('payment_request', $paymmentRequestColumnData, $where);                  
                        echo header('Location:'.$paymentRequest['url']);
                    }
                    else
                    {
                        echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>'.$this->translationMsg['PAYMENT_GATEWAY_SERVER_ERROR'].'</h4>
                            </div>';
                    }
                }
            }
            else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>'.$this->translationMsg['TRANSACTION_ERROR'].'</h4>
                        </div>';
            }            
        }
    }

    public function onlinePaymentReceipt($paymentRequest , $connMain)
    {
        require_once("academia/onlinePayment.php");
        $tableName = 'online_payment';
        $txnId =  $paymentRequest['txnId'];
        $onlinePaymentObj = new OnlinePayment();
        $onlinePaymentObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];
        $onlinePaymentInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        if ($onlinePaymentInfo) {
            if ($onlinePaymentInfo['formSubmissionStatus'] != 1 && isset($paymentRequest['txnId'])) {
                $orderInfo = $this->payUObj->fetchOrder($onlinePaymentInfo);
                if ($orderInfo['status'] == 'SUCCESS' && $orderInfo['transactionState'] == 'SUCCESSFUL' && $orderInfo['payUReference'] == $txnId) {                    
                    $updateData = ['notificationResponse' => json_encode($orderInfo['jsonResponse']), 'formSubmissionStatus' => 1, 'paymentStatus' => $orderInfo['status']];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);                   
                    $response = $onlinePaymentObj->createReceipt($onlinePaymentInfo['onlinePaymentId'], $txnId, $orderInfo['status']);
                    if ($response == 'SUCCESS') {
                        $updateData = ['receiptStatus' => $response];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $result = $this->queryBuilder->update($tableName, $updateData, $where);
                        echo '<div class="col-md-12 text-center alert alert-success">
                               <h4>'.str_replace("[TRANSACTION_ID]",$txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']).'</h4>
                            </div>';

                    } else {
                        echo '<div class="col-md-12 text-center alert alert-success">
                               <h4>'. str_replace("[TRANSACTION_ID]",$txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']).'</h4>
                                   
                                </div>';
                    }
                    
                } else {
                    if($orderInfo['status'] == 'SUCCESS' && isset($orderInfo['jsonResponse'])){
                        $updateData = ['notificationResponse' =>  json_encode($orderInfo['jsonResponse']), 'formSubmissionStatus' => 1 , 'paymentStatus' => $orderInfo['status']];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $this->queryBuilder->update($tableName, $updateData, $where);
                    }
                    $orderStaus = isset($orderInfo['jsonResponse']['transactionState']) ? $orderInfo['jsonResponse']['transactionState'] : 'NOT-FOUND';
                    echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>'.str_replace("[ORDER_STATUS]",$orderStaus, $this->translationMsg['TRANSACTION_NOT_SUCCESS']).'</h4>
                        </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>'.$this->translationMsg['TRANSACTION_ERROR'].'</h4>
                    </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
                <h4>'.$this->translationMsg['TRANSACTION_DATA_NOT_FOUND'].'</h4>
           </div>';
        }
    }

    public function sendPaymentLinkReceipt($paymentRequest, $connMain)
    {            
        $txnId = $paymentRequest['txnId'];
        require_once("academia/sendPaymentLinkPayment.php");
        $tableName = 'online_payment';
        $sendPaymentLinkObj = new SendPaymentLinkPayment();
        $sendPaymentLinkObj->setConnection($this->conn, $connMain);
        $where = ['id'=>$paymentRequest['paymentId'], 'txnId' => $txnId];
        $sendPaymentLinkInfo = $this->queryBuilder->selectById($tableName,'*',$where);
        if($sendPaymentLinkInfo){
            if ($sendPaymentLinkInfo['formSubmissionStatus'] != 1 && isset($paymentRequest['txnId'])) {              
                $orderInfo = $this->payUObj->fetchOrder($sendPaymentLinkInfo);                
                if ($orderInfo['status'] == 'SUCCESS' && $orderInfo['transactionState'] == 'SUCCESSFUL' && $orderInfo['payUReference'] == $txnId) {
                    $updateData = ['notificationResponse' => json_encode($orderInfo['jsonResponse']), 'formSubmissionStatus' => 1, 'paymentStatus' => $orderInfo['status']];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where); 
                    $response = $sendPaymentLinkObj->createReceipt($sendPaymentLinkInfo['sendPaymentLinkId'],$sendPaymentLinkInfo['onlinePaymentId'], $txnId, $orderInfo['status']);
                    if ($response == 'SUCCESS') {
                        $updateData = ['receiptStatus' => $response];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $result = $this->queryBuilder->update($tableName, $updateData, $where);
                        echo '<div class="col-md-12 text-center alert alert-success">
                                  <h4>'.str_replace("[TRANSACTION_ID]",$txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']).'</h4>
                            </div>';

                    } else {
                        echo '<div class="col-md-12 text-center alert alert-success">
                                   <h4>'. str_replace("[TRANSACTION_ID]",$txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']).'</h4>
                                </div>';
                    }
                } else {
                    if($orderInfo['status'] == 'SUCCESS' && isset($orderInfo['jsonResponse'])){
                        $updateData = ['notificationResponse' =>  json_encode($orderInfo['jsonResponse']), 'formSubmissionStatus' => 1 , 'paymentStatus' => $orderInfo['status']];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $this->queryBuilder->update($tableName, $updateData, $where);
                    }
                    $orderStaus = isset($orderInfo['jsonResponse']['transactionState']) ? $orderInfo['jsonResponse']['transactionState'] : 'NOT-FOUND';
                    echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>'.str_replace("[ORDER_STATUS]",$orderStaus, $this->translationMsg['TRANSACTION_NOT_SUCCESS']).'</h4>
                        </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>'.$this->translationMsg['TRANSACTION_ERROR'].'</h4>
                    </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
            <h4>'.$this->translationMsg['TRANSACTION_DATA_NOT_FOUND'].'</h4>
        </div>';
        }
        
    }

    public function declarationPaymentReceipt($paymentRequest , $connMain)
    {
        require_once("academia/declarationPayment.php");
        $tableName = 'declaration_payment';
        $txnId =  $paymentRequest['txnId'];
        $declarationPaymentObj = new DeclarationPayment();
        $declarationPaymentObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];
        $declarationPaymentInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        if ($declarationPaymentInfo) {
            if ($declarationPaymentInfo['formSubmissionStatus'] != 1 && isset($paymentRequest['txnId'])) {                
                $orderInfo = $this->payUObj->fetchOrder($declarationPaymentInfo);
                if ($orderInfo['status'] == 'SUCCESS' &&  $orderInfo['transactionState'] == 'SUCCESSFUL' && $orderInfo['payUReference'] == $txnId) {                    
                   $updateData = ['notificationResponse' => json_encode($orderInfo['jsonResponse']), 'formSubmissionStatus' => 1, 'paymentStatus' => $orderInfo['status']];
                    $where = ['id' => $paymentRequest['paymentId']]; 
                    $this->queryBuilder->update($tableName, $updateData, $where); 
                      $declarationPaymentInfo['paymentStatus'] = $orderInfo['status'];
                      $response = $declarationPaymentObj->createReceipt($declarationPaymentInfo);                      
                      if (isset($response['status']) && $response['status'] == 'SUCCESS') {
                        $updateData = ['receiptStatus' => $response['status'], 'receiptId' => $response['receiptId']];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $result = $this->queryBuilder->update($tableName, $updateData, $where);      
                        echo '<div class="col-md-12 text-center alert alert-success">
                        <h4>'.str_replace("[TRANSACTION_ID]",$txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']).'</h4>
                            </div>';
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-success">
                                   <h4>'. str_replace("[TRANSACTION_ID]",$txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']).'</h4>
                                </div>';
                    }
                } else {
                    if($orderInfo['status'] == 'SUCCESS' && isset($orderInfo['jsonResponse'])){
                        $updateData = ['notificationResponse' =>  json_encode($orderInfo['jsonResponse']), 'formSubmissionStatus' => 1 , 'paymentStatus' => $orderInfo['status']];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $this->queryBuilder->update($tableName, $updateData, $where);
                    }
                    $orderStaus = isset($orderInfo['jsonResponse']['transactionState']) ? $orderInfo['jsonResponse']['transactionState'] : 'NOT-FOUND';
                    echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>'.str_replace("[ORDER_STATUS]",$orderStaus, $this->translationMsg['TRANSACTION_NOT_SUCCESS']).'</h4>
                        </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>'.$this->translationMsg['TRANSACTION_ERROR'].'</h4>
                    </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
            <h4>'.$this->translationMsg['TRANSACTION_DATA_NOT_FOUND'].'2</h4>
        </div>';
        }
    }

    public function advancePaymentReceipt($paymentRequest, $connMain)
    {    
        require_once("academia/advancePayment.php");
        $tableName = 'advance_payment';
        $txnId = $paymentRequest['txnId'];
        $advancePaymentObj = new AdvancePayment();
        $advancePaymentObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];
        $advancePaymentInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        if ($advancePaymentInfo) {
            if ($advancePaymentInfo['formSubmissionStatus'] != 1 && isset($paymentRequest['txnId'])) {                
                $orderInfo = $this->payUObj->fetchOrder($advancePaymentInfo);               
                if ($orderInfo['status'] == 'SUCCESS' && $orderInfo['transactionState'] == 'SUCCESSFUL' && $orderInfo['payUReference'] == $txnId) {
                    $updateData = ['notificationResponse' => json_encode($orderInfo['jsonResponse']), 'formSubmissionStatus' => 1, 'paymentStatus' => $orderInfo['status']];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    $advancePaymentInfo['paymentStatus'] = $orderInfo['status'];
                    $response = $advancePaymentObj->createReceipt($advancePaymentInfo);
                    if (isset($response['status']) && $response['status'] == 'SUCCESS') {
                        $updateData = ['receiptStatus' => $response['status'], 'receiptId' => $response['receiptId']];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $result = $this->queryBuilder->update($tableName, $updateData, $where);
                        echo '<div class="col-md-12 text-center alert alert-success">
                                    <h4>'.str_replace("[TRANSACTION_ID]",$txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']).'</h4>
                            </div>';
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-success">
                        <h4>'. str_replace("[TRANSACTION_ID]",$txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']).'</h4>
                     </div>';
                    }
                } else {
                    if($orderInfo['status'] == 'SUCCESS' && isset($orderInfo['jsonResponse'])){
                        $updateData = ['notificationResponse' => json_encode($orderInfo['jsonResponse']), 'formSubmissionStatus' => 1 , 'paymentStatus' => $orderInfo['jsonResponse']['status']];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $this->queryBuilder->update($tableName, $updateData, $where);
                    }
                    $orderStaus = isset($orderInfo['jsonResponse']['transactionState']) ? $orderInfo['jsonResponse']['transactionState'] : 'NOT-FOUND';
                    echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>'.str_replace("[ORDER_STATUS]",$orderStaus, $this->translationMsg['TRANSACTION_NOT_SUCCESS']).'</h4>
                        </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                <h4>'.$this->translationMsg['TRANSACTION_ERROR'].'.</h4>
            </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
              <h4>'.$this->translationMsg['TRANSACTION_DATA_NOT_FOUND'].'</h4>
          </div>';
        }
    }

    public function examAssessmentReceipt($paymentRequest, $connMain)
    {
        require_once "academia/examinationPayment.php";
        $tableName = 'assessment_payment';
        $txnId =  $paymentRequest['txnId'];
        $examObj = new ExaminationPayment();
        $examObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];
        $examInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        if($examInfo){
            if ($examInfo['formSubmissionStatus'] != 1  && isset($paymentRequest['txnId'])) {
                $orderInfo = $this->payUObj->fetchOrder($examInfo);
                if ($orderInfo['status'] == 'SUCCESS' && $orderInfo['transactionState'] == 'SUCCESSFUL' && $orderInfo['payUReference'] == $txnId) {
                    $updateData = ['notificationResponse' => json_encode($orderInfo['jsonResponse']), 'formSubmissionStatus' => 1, 'paymentStatus' => $orderInfo['status']];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where); 
                    $response = $examObj->createReceipt($examInfo['id'], $examInfo['academyLocationId'], $txnId, $examInfo['amount'],$examInfo['currency']);
                    if (isset($response['status']) && $response['status'] == 'SUCCESS') {
                        $updateData = ['receiptStatus' => $response['status']];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $result = $this->queryBuilder->update($tableName, $updateData, $where);
                        $tableName2 = 'assessment_payment_detail';
                        $updateDataDetail = ['receiptId' => $response['receiptId']];
                        $updateWhere = ['examAssessmentPaymentId' => $paymentRequest['paymentId']];
                        $result2 = $this->queryBuilder->update($tableName2, $updateDataDetail, $updateWhere);
                        echo '<div class="col-md-12 text-center alert alert-success">
                                    <h4>'.str_replace("[TRANSACTION_ID]",$txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']).'</h4>
                                </div>';
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-success">
                            <h4>'. str_replace("[TRANSACTION_ID]",$txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']).'</h4>
                         </div>';
                    }
                } else {
                    if($orderInfo['status'] == 'SUCCESS' && isset($orderInfo['jsonResponse'])){
                        $updateData = ['notificationResponse' => json_encode($orderInfo['jsonResponse']), 'formSubmissionStatus' => 1 , 'paymentStatus' => $orderInfo['jsonResponse']['status']];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $this->queryBuilder->update($tableName, $updateData, $where);
                    }
                    $orderStaus = isset($orderInfo['jsonResponse']['transactionState']) ? $orderInfo['jsonResponse']['transactionState'] : 'NOT-FOUND';
                    echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>'.str_replace("[ORDER_STATUS]",$orderStaus, $this->translationMsg['TRANSACTION_NOT_SUCCESS']).'</h4>
                        </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>'.$this->translationMsg['TRANSACTION_ERROR'].'.</h4>
                    </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
                 <h4>'.$this->translationMsg['TRANSACTION_DATA_NOT_FOUND'].'</h4>
          </div>';
        }       
    }
    public function courseEnrollementPaymentReceipt($paymentRequest,$connMain)
    {
        require_once("academia/courseEnrollement.php");
        $tableName = 'enrollment_payment';
        $txnId = $paymentRequest['txnId'];
        $courseEnrollementPaymentObj = new CourseEnrollement();
        $courseEnrollementPaymentObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];
        $courseEnrollementInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        if ($courseEnrollementInfo) {
            if ($courseEnrollementInfo['formSubmissionStatus'] != 1 && isset($paymentRequest['txnId'])) {
                $orderInfo = $this->payUObj->fetchOrder($courseEnrollementInfo);
                if ($orderInfo['status'] == 'SUCCESS' && $orderInfo['transactionState'] == 'SUCCESSFUL' && $orderInfo['payUReference'] == $txnId) {
                    $updateData = ['notificationResponse' => json_encode($orderInfo['jsonResponse']), 'formSubmissionStatus' => 1, 'paymentStatus' => $orderInfo['status']];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where); 
                    $response = $courseEnrollementPaymentObj->createReceipt($courseEnrollementInfo['onlinePaymentId'], $txnId, $orderInfo['status']);
                    if ($response == 'SUCCESS') {
                        $updateData = ['receiptStatus' => $response];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $result = $this->queryBuilder->update($tableName, $updateData, $where);
                        echo '<div class="col-md-12 text-center alert alert-success">
                                    <h4>'.str_replace("[TRANSACTION_ID]",$txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']).'</h4>
                            </div>';

                    } else {
                        echo '<div class="col-md-12 text-center alert alert-success">
                                    <h4>'. str_replace("[TRANSACTION_ID]",$txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']).'</h4>
                                </div>';
                    } 
                } else {
                    if($orderInfo['status'] == 'SUCCESS' && isset($orderInfo['jsonResponse'])){
                        $updateData = ['notificationResponse' => json_encode($orderInfo['jsonResponse']), 'formSubmissionStatus' => 1 , 'paymentStatus' => $orderInfo['jsonResponse']['status']];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $this->queryBuilder->update($tableName, $updateData, $where);
                    }
                    $orderStaus = isset($orderInfo['jsonResponse']['transactionState']) ? $orderInfo['jsonResponse']['transactionState'] : 'NOT-FOUND';
                    echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>'.str_replace("[ORDER_STATUS]",$orderStaus, $this->translationMsg['TRANSACTION_NOT_SUCCESS']).'</h4>
                        </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>'.$this->translationMsg['TRANSACTION_ERROR'].'.</h4>
                    </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
              <h4>'.$this->translationMsg['TRANSACTION_DATA_NOT_FOUND'].'</h4>
          </div>';
        }
    }

    public function RevaluationReceipt($paymentRequest, $connMain)
    {
        require_once("academia/revaluationPayment.php");
        $tableName = 'reval_payment';
        $txnId = $paymentRequest['txnId'];
        $revalObj = new RevaluationPayment();
        $revalObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];
        $revalInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        if($revalInfo){
            if ($revalInfo['formSubmissionStatus'] != 1 && isset($paymentRequest['txnId'])) {
                $orderInfo = $this->payUObj->fetchOrder($revalInfo);
                if ($orderInfo['status'] == 'SUCCESS' && $orderInfo['transactionState'] == 'SUCCESSFUL' && $orderInfo['payUReference'] == $txnId) {
                    $updateData = ['notificationResponse' => json_encode($orderInfo['jsonResponse']), 'formSubmissionStatus' => 1, 'paymentStatus' => $orderInfo['status']];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where); 
                    $response = $revalObj->createReceipt($revalInfo['id'], $revalInfo['amount'], $txnId, $orderInfo['status']);
                    if (isset($response) && isset($response['status']) == 'SUCCESS') {
                        $updateData = ['receiptStatus' => $response['status']];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $result = $this->queryBuilder->update($tableName, $updateData, $where);
                        echo '<div class="col-md-12 text-center alert alert-success">
                                    <h4>'.str_replace("[TRANSACTION_ID]",$txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']).'</h4>
                         </div>';
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-success">
                                    <h4>'. str_replace("[TRANSACTION_ID]",$txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']).'</h4>
                                </div>';
                    }
                } else {
                    if($orderInfo['status'] == 'SUCCESS' && isset($orderInfo['jsonResponse'])){
                        $updateData = ['notificationResponse' => json_encode($orderInfo['jsonResponse']), 'formSubmissionStatus' => 1 , 'paymentStatus' => $orderInfo['jsonResponse']['status']];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $this->queryBuilder->update($tableName, $updateData, $where);
                    }
                    $orderStaus = isset($orderInfo['jsonResponse']['transactionState']) ? $orderInfo['jsonResponse']['transactionState'] : 'NOT-FOUND';
                    echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>'.str_replace("[ORDER_STATUS]",$orderStaus, $this->translationMsg['TRANSACTION_NOT_SUCCESS']).'</h4>
                        </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>'.$this->translationMsg['TRANSACTION_ERROR'].'.</h4>
                    </div>';
            }

        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
              <h4>'.$this->translationMsg['TRANSACTION_DATA_NOT_FOUND'].'</h4>
          </div>';
        }
    }


    
    public function courseRegistrationPaymentReceipt($paymentRequest, $connMain) {
        require_once("academia/courseRegistrationPayment.php");
        $tableName = 'course_registration_payment';
        $txnId = $paymentRequest['txnId'];
        $courseRegObj = new CourseRegistrationPayment();
        $courseRegObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];
        $courseRegInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        if ($courseRegInfo) {
            if ($courseRegInfo['formSubmissionStatus'] != 1 && isset($paymentRequest['txnId'])) {
                $orderInfo = $this->payUObj->fetchOrder($courseRegInfo);
                if ($orderInfo['status'] == 'SUCCESS' && $orderInfo['transactionState'] == 'SUCCESSFUL' && $orderInfo['payUReference'] == $txnId) {
                    $updateData = ['notificationResponse' => json_encode($orderInfo['jsonResponse']), 'formSubmissionStatus' => 1, 'paymentStatus' => $orderInfo['status']];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    $courseRegInfo['paymentStatus'] = $orderInfo['status'];
                    $response = $courseRegObj->createReceipt($courseRegInfo);                    
                    if ( $response == 'SUCCESS') {
                        $updateData = ['receiptStatus' => $response];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $result = $this->queryBuilder->update($tableName, $updateData, $where);
                        echo '<div class="col-md-12 text-center alert alert-success">
                                    <h4>'.str_replace("[TRANSACTION_ID]",$txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']).'</h4>
                            </div>';
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-success">
                        <h4>'. str_replace("[TRANSACTION_ID]",$txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']).'</h4>
                     </div>';
                    }
                } else {
                    if($orderInfo['status'] == 'SUCCESS' && isset($orderInfo['jsonResponse'])){
                        $updateData = ['notificationResponse' => json_encode($orderInfo['jsonResponse']), 'formSubmissionStatus' => 1 , 'paymentStatus' => $orderInfo['jsonResponse']['status']];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $this->queryBuilder->update($tableName, $updateData, $where);
                    }

                    $orderStaus = isset($orderInfo['jsonResponse']['transactionState']) ? $orderInfo['jsonResponse']['transactionState'] : 'NOT-FOUND';
                    echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>'.str_replace("[ORDER_STATUS]",$orderInfo['status'], $this->translationMsg['TRANSACTION_NOT_SUCCESS']).'</h4>
                    </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                <h4>'.$this->translationMsg['TRANSACTION_ERROR'].'.</h4>
            </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
              <h4>'.$this->translationMsg['TRANSACTION_DATA_NOT_FOUND'].'</h4>
          </div>';
        }
    }

    public function courseRegistrationPendingPaymentReceipt($paymentRequest, $connMain) {
        require_once("academia/courseRegistrationPendingPayment.php");
        $tableName = 'course_registration_pending_payment';
        $txnId = $paymentRequest['txnId'];
        $courseRegObj = new CourseRegistrationPendingPayment();
        $courseRegObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];
        $courseRegInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        if ($courseRegInfo) {
            if ($courseRegInfo['formSubmissionStatus'] != 1 && isset($paymentRequest['txnId'])) {
                $orderInfo = $this->payUObj->fetchOrder($courseRegInfo);
                if ($orderInfo['status'] == 'SUCCESS' && $orderInfo['transactionState'] == 'SUCCESSFUL' && $orderInfo['payUReference'] == $txnId) {
                    $updateData = ['notificationResponse' => json_encode($orderInfo['jsonResponse']), 'formSubmissionStatus' => 1, 'paymentStatus' => $orderInfo['status']];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    $courseRegInfo['paymentStatus'] = $orderInfo['status'];
                    $response = $courseRegObj->createReceipt($courseRegInfo);                   
                    if ($response == 'SUCCESS') {
                        $updateData = ['receiptStatus' => $response];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $result = $this->queryBuilder->update($tableName, $updateData, $where);
                        echo '<div class="col-md-12 text-center alert alert-success">
                                    <h4>'.str_replace("[TRANSACTION_ID]",$txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']).'</h4>
                            </div>';
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-success">
                        <h4>'. str_replace("[TRANSACTION_ID]",$txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']).'</h4>
                     </div>';
                    }
                } else {
                    if($orderInfo['status'] == 'SUCCESS' && isset($orderInfo['jsonResponse'])){
                        $updateData = ['notificationResponse' => json_encode($orderInfo['jsonResponse']), 'formSubmissionStatus' => 1 , 'paymentStatus' => $orderInfo['jsonResponse']['status']];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $this->queryBuilder->update($tableName, $updateData, $where);
                    }
                    $orderStaus = isset($orderInfo['jsonResponse']['transactionState']) ? $orderInfo['jsonResponse']['transactionState'] : 'NOT-FOUND';
                    echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>'.str_replace("[ORDER_STATUS]",$orderInfo['status'], $this->translationMsg['TRANSACTION_NOT_SUCCESS']).'</h4>
                    </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                <h4>'.$this->translationMsg['TRANSACTION_ERROR'].'.</h4>
            </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
              <h4>'.$this->translationMsg['TRANSACTION_DATA_NOT_FOUND'].'</h4>
          </div>';
        }
    }

    public function donationPaymentReceipt($paymentRequest , $connMain){
        require_once("academia/donationPayment.php");
        $tableName = 'donation_payment';
        $txnId =  $paymentRequest['txnId'];
        $donationObj = new DonationPayment();
        $donationObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];
        $donationInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        if ($donationInfo) {
            if ($donationInfo['formSubmissionStatus'] != 1 && isset($paymentRequest['txnId'])) {
                $orderInfo = $this->payUObj->fetchOrder($donationInfo);
                if ($orderInfo['status'] == 'SUCCESS' && $orderInfo['transactionState'] == 'SUCCESSFUL' && $orderInfo['payUReference'] == $txnId) {                    
                    $updateData = ['notificationResponse' => json_encode($orderInfo['jsonResponse']), 'formSubmissionStatus' => 1, 'paymentStatus' => $orderInfo['status']];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);     
                    $response = $donationObj->createReceipt($donationInfo, 'TXN_SUCCESS');              
                    if ( $response == 'SUCCESS') {
                        $updateData = ['receiptStatus' => $response];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $result = $this->queryBuilder->update($tableName, $updateData, $where);
                        echo '<div class="col-md-12 text-center alert alert-success">
                                   <h4>'.str_replace("[TRANSACTION_ID]",$txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']).'</h4>
                            </div>';

                    } else {
                        echo '<div class="col-md-12 text-center alert alert-success">
                                    <h4>'. str_replace("[TRANSACTION_ID]",$txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']).'</h4>
                                </div>';
                    }
                    
                } else {

                    if($orderInfo['status'] == 'SUCCESS' && isset($orderInfo['jsonResponse'])){
                        $updateData = ['notificationResponse' => json_encode($orderInfo['jsonResponse']), 'formSubmissionStatus' => 1 , 'paymentStatus' => $orderInfo['jsonResponse']['status']];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $this->queryBuilder->update($tableName, $updateData, $where);
                    }
                    $orderStaus = isset($orderInfo['jsonResponse']['transactionState']) ? $orderInfo['jsonResponse']['transactionState'] : 'NOT-FOUND';
                    echo '<div class="col-md-12 text-center alert alert-warning">
                           <h4>'.str_replace("[ORDER_STATUS]",$orderStaus, $this->translationMsg['TRANSACTION_NOT_SUCCESS']).'</h4>
                        </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>'.$this->translationMsg['TRANSACTION_ERROR'].'.</h4>
                    </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
              <h4>'.$this->translationMsg['TRANSACTION_DATA_NOT_FOUND'].'</h4>
          </div>';
        }
    }
}