<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
require_once "header.php";
require_once './config/db_config.php';
require_once "./config/QueryBuilder.php";
require_once "./config/gatewayConfig.php";
require_once 'Logger.php';
$queryBuilder      = new QueryBuilder($conn);
$gatewayConfig     = new GatewayConfig();
$redirectToMobile  = false;
$redirectToApplicantPortal = false;
$redirectToStudentPortal = false;
$activeGateways    = $gatewayConfig->getActiveGateway();
$activeGateway     = $gatewayConfig->get_session();
$translationMsg = json_decode(TRANSLATION_MSG, true);
$gatewaysToProcess = [];
if ($activeGateway) {
   
    $gatewaysToProcess = [$activeGateway];
} elseif (is_array($activeGateways)) {
    
    foreach ($activeGateways as $gateway) {
        $gatewaysToProcess[] = $gateway['value'];
    }
}
try
{
    require_once "./config/paymentGatewayLoader.php";
    $gatewayLoader = new PaymentGatewayLoader();
    if (empty($gatewaysToProcess)) {
        throw new Exception("No active gateways configured.");
    }
    if(empty($_REQUEST) || isset($_REQUEST['type']) && $_REQUEST['type'] == 'invalid')
    {
        echo '<div class="col-md-12 text-center alert alert-warning">
                <h4>' . ($translationMsg['INVALID_REQUEST'] ?? 'Invalid or missing payment parameters') . '</h4>
            </div>';
        require_once "footer.php";
        exit;
    }
    foreach ($gatewaysToProcess as $gateway) {
        switch ($gateway) {
            case 'flywire':
                if (!isset($_REQUEST['reference']) && !isset($_REQUEST['status']) || 
                (isset($_REQUEST['entity']) || isset($_REQUEST['application_code']) || isset($_REQUEST['reference_id']))) {
                    Logger::warning("Skipping Flywire: response does not contain 'reference' or 'status'");
                    continue 2;
                }            
                require_once './paymentGateway/flywire/flywirePaymentGateway.php';
                $flywireObj   = new FlywirePaymentGateway();
                $sendResponse = $flywireObj->getReq($_REQUEST);

                if ($sendResponse['status'] === true) {
                    echo '<div class="col-md-12 text-center alert alert-success">
                            <h4>' . $sendResponse['msg'] . '</h4>
                        </div>';
                    if (isset($_REQUEST['donationId'])) {
                        echo '<div class="col-md-12 text-center" id="gotohome">
                                <a href="' . $_REQUEST['redirect'] . '#/dashboard" class="btn btn-primary proceedBtn">Go to Dashboard</a>
                            </div>';
                    }

                } else {
                    echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>' . $sendResponse['msg'] . '</h4>
                    </div>';
                    if (isset($_REQUEST['donationId'])) {
                        echo '<div class="col-md-12 text-center" id="gotohome">
                            <a href="' . $_REQUEST['redirect'] . '#/dashboard" class="btn btn-primary proceedBtn">Go to Dashboard</a>
                        </div>';
                    }
                }
                
                $txnID = isset($_REQUEST['reference']) ? $_REQUEST['reference'] : '';
                if ($txnID) {
                    $where             = ['paymentType' => 'mobile', 'txnId' => $txnID];
                    $onlinePaymentInfo = $queryBuilder->selectById('online_payment', '*', $where);
                    if ($onlinePaymentInfo) {
                        $redirectToMobile = true;
                    }
                }
                break;
            case 'stripe':
                if (! isset($_REQUEST['stripeToken']) || ! isset($_REQUEST['stripeEmail'])) {
                    Logger::warning("Skipping Stripe: response does not contain 'stripeToken' or 'stripeEmail'");
                    continue 2;
                }
                $where = ['paymentId' => $_REQUEST['id'] , 'screen' => $_REQUEST['screenName']];
                if ($_REQUEST['stripeToken']) {
                    $paymentRequest  = $queryBuilder->selectById('payment_request', '*', $where);
                    $paymentRequest['data'] = $_REQUEST;
                    $gatewayLoader->loadReceiptFunctions('stripe', $connMain, $conn, $paymentRequest);
                    if (! empty($_REQUEST['paymentType']) && $_REQUEST['paymentType'] == 'mobile') {
                        $redirectToMobile = true;
                    }
                    if (! empty($paymentRequest) && $paymentRequest['screen'] == 'declaration-payment') {
                        echo '<div class="col-md-12 text-center" id="gotohome" >
                        <a href="' . baseURL . '/applicant-portal/#/dashboard" class="btn btn-primary proceedBtn">Go to Home</a>
                        </div>';
                    }
                    if (! empty($paymentRequest) && $paymentRequest['screen'] == 'donation-payment') {
                        $where = ['id' => $paymentRequest['paymentId']];
                        $paymentInfo  = $queryBuilder->selectById('donation_payment', '*', $where);
                        echo '<div class="col-md-12 text-center" id="gotohome">
                              <a href="' . $paymentInfo['redirectURL'] . '#/dashboard" class="btn btn-primary proceedBtn">Go to Dashboard</a>
                          </div>';
                    }

                    if (! empty($paymentRequest) && $paymentRequest['screen'] == 'advance-payment') {
                        $where = ['id' => $paymentRequest['paymentId']];
                        $paymentInfo  = $queryBuilder->selectById('advance_payment', '*', $where);
                        if(isset($paymentInfo['requestUrl']) && $paymentInfo['requestUrl']){
                            echo '<div class="col-md-12 text-center" id="gotohome">
                                  <a href="' . $paymentInfo['requestUrl'] . '" class="btn btn-primary proceedBtn">Go to Dashboard</a>
                              </div>';
                        }
                    }
                }
                break;
            case 'dpo':
                if(!isset($_REQUEST['TransID']) || !isset($_REQUEST['TransactionToken']) || !isset($_REQUEST['CompanyRef']) )
                {
                    Logger::warning("Skipping DPO: response does not contain 'TransID' or 'TransactionToken' or 'CompanyRef'");
                    continue 2;
                }                
                $where = ['txnId' => $_REQUEST['CompanyRef']];
                $declarationPaymentInfo = $queryBuilder->selectById('declaration_payment', '*', $where);
                $paymentRequest  = $queryBuilder->selectById('payment_request', '*', $where);
                $gatewayLoader->loadReceiptFunctions('dpo', $connMain, $conn, $paymentRequest);
                $where = ['paymentType'=> 'mobile', 'txnId' => $_REQUEST['CompanyRef']];
                $mobileInfo = $queryBuilder->selectById('online_payment','*',$where);            
                if($mobileInfo)
                {

                    $redirectToMobile = true;
                }
                if (isset($declarationPaymentInfo['paymentType']) && $declarationPaymentInfo['paymentType']  == 'applicantPortal') {
                    $redirectToApplicantPortal = true;
                }
                if (! empty($paymentRequest) && $paymentRequest['screen'] == 'donation-payment') {
                    $where = ['id' => $paymentRequest['paymentId']];
                    $paymentInfo  = $queryBuilder->selectById('donation_payment', '*', $where);
                    echo '<div class="col-md-12 text-center" id="gotohome">
                          <a href="' . $paymentInfo['redirectURL'] . '#/dashboard" class="btn btn-primary proceedBtn">Go to Dashboard</a>
                      </div>';
                }
                if (! empty($paymentRequest) && $paymentRequest['screen'] == 'advance-payment') {
                    $where = ['id' => $paymentRequest['paymentId']];
                    $paymentInfo  = $queryBuilder->selectById('advance_payment', '*', $where);
                    if(isset($paymentInfo['requestUrl']) && $paymentInfo['requestUrl']){
                        echo '<div class="col-md-12 text-center" id="gotohome">
                              <a href="' . $paymentInfo['requestUrl'] . '" class="btn btn-primary proceedBtn">Go to Dashboard</a>
                          </div>';
                    }
                }
                if (! empty($paymentRequest) && ($paymentRequest['screen'] == 'course-registration-payment' || $paymentRequest['screen'] == 'course-registration-pending-payment')) {
                    if($paymentRequest['screen'] == 'course-registration-payment')
                    {
                        $tableName = 'course_registration_payment';
                    }else{
                        $tableName = 'course_registration_pending_payment';
                    }
                    $where = ['id' => $paymentRequest['paymentId']];
                    $paymentInfo  = $queryBuilder->selectById($tableName, '*', $where);
                    if(isset($paymentInfo['requestUrl']) && $paymentInfo['requestUrl']){
                        echo '<div class="col-md-12 text-center" id="gotohome">
                              <a href="' . $paymentInfo['requestUrl'] . '" class="btn btn-primary proceedBtn">Go to Dashboard</a>
                          </div>';
                    }
                }
                break;
            case 'mpgs':
                if(!isset($_REQUEST['ord']))
                {
                    Logger::warning("Skipping MPGS: response does not contain 'ord'");
                    continue 2;
                }                
                $where = ['txnId' => $_REQUEST['ord']];
                $paymentRequest  = $queryBuilder->selectById('payment_request', '*', $where);
                $gatewayLoader->loadReceiptFunctions('mpgs', $connMain, $conn, $paymentRequest);
                $where = ['paymentType'=> 'mobile', 'txnId' => $_REQUEST['ord']];
                $mobileInfo = $queryBuilder->selectById('online_payment','*',$where);
                if($mobileInfo)
                {
                    $redirectToMobile = true;
                }
                if (! empty($paymentRequest) && $paymentRequest['screen'] == 'donation-payment') {
                    $where = ['id' => $paymentRequest['paymentId']];
                    $paymentInfo  = $queryBuilder->selectById('donation_payment', '*', $where);
                    echo '<div class="col-md-12 text-center" id="gotohome">
                          <a href="' . $paymentInfo['redirectURL'] . '#/donate-funds" class="btn btn-primary proceedBtn">Go to Dashboard</a>
                      </div>';
                }
                if (! empty($paymentRequest) && $paymentRequest['screen'] == 'advance-payment') {
                    $where = ['id' => $paymentRequest['paymentId']];
                    $paymentInfo  = $queryBuilder->selectById('advance_payment', '*', $where);
                    if(isset($paymentInfo['requestUrl']) && $paymentInfo['requestUrl']){
                        echo '<div class="col-md-12 text-center" id="gotohome">
                              <a href="' . $paymentInfo['requestUrl'] . '" class="btn btn-primary proceedBtn">Go to Dashboard</a>
                          </div>';
                    }
                }
                break;
            case 'mips':
                if(!isset($_REQUEST['mipsid']))
                {
                    Logger::warning("Skipping MIPS: response does not contain 'ord'");
                    continue 2;
                }
                echo '<div class="col-md-12 text-center alert alert-success">
                <h4>'.$translationMsg['PAYMENT_PROCESSED_GENERIC'].'</h4>
                 </div>';
                $txnID = isset($_REQUEST['mipsid']) ? $_REQUEST['mipsid'] : '';
                if ($txnID) {
                    $where = ['txnId' => $txnID];
                    $onlinePaymentInfo = $queryBuilder->selectById('online_payment', '*', $where);
                    if (isset($onlinePaymentInfo['paymentType']) && $onlinePaymentInfo['paymentType']  == 'applicantPortal') {
                        $redirectToApplicantPortal = true;
                    }else if (isset($onlinePaymentInfo['paymentType']) && $onlinePaymentInfo['paymentType'] == 'studentPortal') {
                        $redirectToStudentPortal = true;
                    }
                    $paymentRequest  = $queryBuilder->selectById('payment_request', '*', $where);
                    if (! empty($paymentRequest) && $paymentRequest['screen'] == 'donation-payment') {
                        $where = ['id' => $paymentRequest['paymentId']];
                        $paymentInfo  = $queryBuilder->selectById('donation_payment', '*', $where);
                        echo '<div class="col-md-12 text-center" id="gotohome">
                              <a href="' . $paymentInfo['redirectURL'] . '#/donate-funds" class="btn btn-primary proceedBtn">Go to Dashboard</a>
                          </div>';
                    }
                    $where = ['paymentType'=> 'mobile', 'txnId' => $txnID];
                    $mobileInfo = $queryBuilder->selectById('online_payment','*',$where);            
                    if($mobileInfo)
                    {

                        $redirectToMobile = true;
                    }
                    
                }
                
            break;
            case 'payu':
                if(!isset($_REQUEST['PayUReference']))
                {
                    Logger::warning("Skipping PaU: response does not contain 'ord'");
                    continue 2;
                }
                $where = ['txnId' => $_REQUEST['PayUReference']];
                $onlinePaymentInfo = $queryBuilder->selectById('online_payment', '*', $where);
                $paymentRequest  = $queryBuilder->selectById('payment_request', '*', $where);
                $gatewayLoader->loadReceiptFunctions('payu', $connMain, $conn, $paymentRequest);
                $where = ['paymentType'=> 'mobile', 'txnId' => $_REQUEST['PayUReference']];
                $mobileInfo = $queryBuilder->selectById('online_payment','*',$where);
                
                if($mobileInfo)
                {
                    $redirectToMobile = true;
                }
                if (isset($onlinePaymentInfo['paymentType']) && $onlinePaymentInfo['paymentType']  == 'applicantPortal') {
                    $redirectToApplicantPortal = true;
                }else if (isset($onlinePaymentInfo['paymentType']) && $onlinePaymentInfo['paymentType'] == 'studentPortal') {
                    $redirectToStudentPortal = true;
                }
                if (! empty($paymentRequest) && $paymentRequest['screen'] == 'donation-payment') {
                    $where = ['id' => $paymentRequest['paymentId']];
                    $paymentInfo  = $queryBuilder->selectById('donation_payment', '*', $where);
                    echo '<div class="col-md-12 text-center" id="gotohome">
                          <a href="' . $paymentInfo['redirectURL'] . '#/donate-funds" class="btn btn-primary proceedBtn">Go to Dashboard</a>
                      </div>';
                }
                if (! empty($paymentRequest) && $paymentRequest['screen'] == 'advance-payment') {
                    $where = ['id' => $paymentRequest['paymentId']];
                    $paymentInfo  = $queryBuilder->selectById('advance_payment', '*', $where);
                    if(isset($paymentInfo['requestUrl']) && $paymentInfo['requestUrl']){
                        echo '<div class="col-md-12 text-center" id="gotohome">
                              <a href="' . $paymentInfo['requestUrl'] . '" class="btn btn-primary proceedBtn">Go to Dashboard</a>
                          </div>';
                    }
                }
                if (! empty($paymentRequest) && ($paymentRequest['screen'] == 'course-registration-payment' || $paymentRequest['screen'] == 'course-registration-pending-payment')) {
                    $where = ['id' => $paymentRequest['paymentId']];
                    $paymentInfo  = $queryBuilder->selectById('course_registration_pending_payment', '*', $where);
                    if(isset($paymentInfo['requestUrl']) && $paymentInfo['requestUrl']){
                        echo '<div class="col-md-12 text-center" id="gotohome">
                              <a href="' . $paymentInfo['requestUrl'] . '" class="btn btn-primary proceedBtn">Go to Dashboard</a>
                          </div>';
                    }
                }
            break;
            case 'paygate':
                if(!isset($_REQUEST['payGateReference']))
                {
                    Logger::warning("Skipping PayGate: response does not contain 'payGateReference'");
                    continue 2;
                }             
                $where = ['txnId' => $_REQUEST['payGateReference']];
                $paymentRequest  = $queryBuilder->selectById('payment_request', '*', $where);
                $gatewayLoader->loadReceiptFunctions('paygate', $connMain, $conn, $paymentRequest);                
               
                if (! empty($paymentRequest) && $paymentRequest['screen'] == 'online-payment'){
                    /* Check for payGateReference value from the online payment table using like */  
                    $additionalConditions = 'gatewayConfig LIKE ?';
                    $additionalParams = ['%' . $_REQUEST['payGateReference'] . '%'];                
                    $onlinePaymentInfo = $queryBuilder->select('online_payment', '*', [] , [], $additionalConditions , $additionalParams , 'id DESC' , 1); 

                     /*Check For Mobile Payment */   
                    $where =  ['paymentType'=> 'mobile'];
                    $mobileInfo = $queryBuilder->select('online_payment', '*', $where , [], $additionalConditions , $additionalParams , 'id DESC' , 1);               
                    if($mobileInfo)
                    {
                        $redirectToMobile = true;
                    }
                    if (isset($onlinePaymentInfo[0]['paymentType']) && $onlinePaymentInfo[0]['paymentType']  == 'applicantPortal') {
                        $redirectToApplicantPortal = true;
                    }else if (isset($onlinePaymentInfo[0]['paymentType']) && $onlinePaymentInfo[0]['paymentType'] == 'studentPortal') {
                        $redirectToStudentPortal = true;
                    }
                }               
                if (! empty($paymentRequest) && $paymentRequest['screen'] == 'donation-payment') {
                    $where = ['id' => $paymentRequest['paymentId']];
                    $paymentInfo  = $queryBuilder->selectById('donation_payment', '*', $where);
                    echo '<div class="col-md-12 text-center" id="gotohome">
                          <a href="' . $paymentInfo['redirectURL'] . '#/donate-funds" class="btn btn-primary proceedBtn">Go to Dashboard</a>
                      </div>';
                }
                if (! empty($paymentRequest) && $paymentRequest['screen'] == 'advance-payment') {
                    $where = ['id' => $paymentRequest['paymentId']];
                    $paymentInfo  = $queryBuilder->selectById('advance_payment', '*', $where);
                    if(isset($paymentInfo['requestUrl']) && $paymentInfo['requestUrl']){
                        echo '<div class="col-md-12 text-center" id="gotohome">
                              <a href="' . $paymentInfo['requestUrl'] . '" class="btn btn-primary proceedBtn">Go to Dashboard</a>
                          </div>';
                    }
                }
                if (! empty($paymentRequest) && ($paymentRequest['screen'] == 'course-registration-payment' || $paymentRequest['screen'] == 'course-registration-pending-payment')) {
                    $where = ['id' => $paymentRequest['paymentId']];
                    $paymentInfo  = $queryBuilder->selectById('course_registration_pending_payment', '*', $where);
                    if(isset($paymentInfo['requestUrl']) && $paymentInfo['requestUrl']){
                        echo '<div class="col-md-12 text-center" id="gotohome">
                              <a href="' . $paymentInfo['requestUrl'] . '" class="btn btn-primary proceedBtn">Go to Dashboard</a>
                          </div>';
                    }
                }
                if (! empty($paymentRequest) && $paymentRequest['screen'] == 'declaration-payment') {
                    $redirectToApplicantPortal = true ;
                }
                
            break;
            case 'authorizedotnet':
                if(!isset($_REQUEST['authInvoiceId']))
                {
                    Logger::warning("Skipping Authorized: response does not contain 'ord'");
                    continue 2;
                }
                echo '<div class="col-md-12 text-center alert alert-success">
                    <h4>'.$translationMsg['PAYMENT_PROCESSED_GENERIC'].'</h4>
                </div>';    
                $where = ['txnId' => $_REQUEST['authInvoiceId']];
                $paymentRequest  = $queryBuilder->selectById('payment_request', '*', $where);
                // $gatewayLoader->loadReceiptFunctions('paygate', $connMain, $conn, $paymentRequest);                
               
                if (! empty($paymentRequest) && $paymentRequest['screen'] == 'online-payment'){
                    /* Check for authInvoiceId value from the online payment table using like */  
                    $additionalConditions = 'gatewayConfig LIKE ?';
                    $additionalParams = ['%' . $_REQUEST['authInvoiceId'] . '%'];                
                    $onlinePaymentInfo = $queryBuilder->select('online_payment', '*', [] , [], $additionalConditions , $additionalParams , 'id DESC' , 1); 

                     /*Check For Mobile Payment */   
                    if($onlinePaymentInfo[0]['paymentType'] == 'mobile')
                    {
                        $redirectToMobile = true;
                    }
                    if (isset($onlinePaymentInfo[0]['paymentType']) && $onlinePaymentInfo[0]['paymentType']  == 'applicantPortal') {
                        $redirectToApplicantPortal = true;
                    }else if (isset($onlinePaymentInfo[0]['paymentType']) && $onlinePaymentInfo[0]['paymentType'] == 'studentPortal') {
                        $redirectToStudentPortal = true;
                    }
                }   
          
                if (! empty($paymentRequest) && $paymentRequest['screen'] == 'declaration-payment') {
                    $redirectToApplicantPortal = true ;
                }
                  if (! empty($paymentRequest) && $paymentRequest['screen'] == 'donation-payment') {
                    $additionalConditions = 'gatewayConfig LIKE ?';
                    $additionalParams = ['%' . $_REQUEST['authInvoiceId'] . '%'];                
                    $donationInfo = $queryBuilder->select('donation_payment', '*', [] , [], $additionalConditions , $additionalParams , 'id DESC' , 1);                     
                    if(isset($donationInfo[0]['redirectURL']) && $donationInfo[0]['redirectURL']){
                        echo '<div class="col-md-12 text-center" id="gotohome">
                                <a href="' . $donationInfo[0]['redirectURL'] . '#/donate-funds" class="btn btn-primary proceedBtn">Go to Dashboard</a>
                          </div>';
                    }
                }
            break;
            case 'grayquest':
                if(!isset($_REQUEST['entity']) && !isset($_REQUEST['status']) && !isset($_REQUEST['application_code']) && !isset($_REQUEST['reference_id']))
                {
                    Logger::warning("Skipping GrayQuest: response does not contain 'entity' or 'status' or 'application code' or 'reerence id");
                    continue 2;
                }
                if($_REQUEST['entity'] == 'monthly-emi' && $_REQUEST['status'] == 'success')
                {
                    echo '<div class="col-md-12 text-center alert alert-success">
                    <h4>'.str_replace("[REFERENCE_ID]",$_REQUEST['reference_id'] , $translationMsg['EMI_PROCESSED']).'</h4>
                    </div>';
                    $where = ['txnId' => $_REQUEST['reference_id']];
                    $data = ['paymentStatus' => 'EMI FORM SUBMITTED'];
                    $update = $queryBuilder->update('online_payment' , $data , $where );
                }else
                {
                $where = ['txnId' => $_REQUEST['reference_id']];
                $paymentRequest  = $queryBuilder->selectById('payment_request', '*', $where);   

                $gatewayLoader->loadReceiptFunctions('grayquest', $connMain, $conn, $paymentRequest);
                }               
                
                $where = ['paymentType'=> 'mobile', 'txnId' => $_REQUEST['reference_id']];
                $mobileInfo = $queryBuilder->selectById('online_payment','*',$where);

                if($mobileInfo)
                {
                    $redirectToMobile = true;
                }
            break;
            case 'paytm':
                if(!isset($_REQUEST['MID']))
                {
                    Logger::warning("Skipping PAYTM: response does not contain 'MID'");
                    continue 2;
                }
                $where = ['txnId' => $_REQUEST['ORDERID']];
                $onlinePaymentInfo = $queryBuilder->selectById('online_payment', '*', $where);
                $paymentRequest  = $queryBuilder->selectById('payment_request', '*', $where);
                $gatewayLoader->loadReceiptFunctions('paytm', $connMain, $conn, $paymentRequest);                 
                if(isset($onlinePaymentInfo['paymentType']) && $onlinePaymentInfo['paymentType'] == 'mobile')
                {
                    $redirectToMobile = true;
                }
                if (! empty($paymentRequest) && $paymentRequest['screen'] == 'declaration-payment') {
                    $redirectToApplicantPortal = true ;
                }
                if (isset($onlinePaymentInfo['paymentType']) && $onlinePaymentInfo['paymentType']  == 'applicantPortal') {
                    $redirectToApplicantPortal = true;
                }else if (isset($onlinePaymentInfo['paymentType']) && $onlinePaymentInfo['paymentType'] == 'studentPortal') {
                    $redirectToStudentPortal = true;
                }
                if (! empty($paymentRequest) && $paymentRequest['screen'] == 'donation-payment') {
                    $where = ['id' => $paymentRequest['paymentId']];
                    $paymentInfo  = $queryBuilder->selectById('donation_payment', '*', $where);
                    echo '<div class="col-md-12 text-center" id="gotohome">
                          <a href="' . $paymentInfo['redirectURL'] . '#/donate-funds" class="btn btn-primary proceedBtn">Go to Dashboard</a>
                      </div>';
                }            
            break;
            case 'adityabirla':
                if(!isset($_REQUEST['pl_order_id']))
                {
                    Logger::warning("Skipping AdityaBirla: response does not contain 'pl_order_id'");
                    continue 2;
                }
                $where = ['txnId' => $_REQUEST['pl_order_id']];
                $onlinePaymentInfo = $queryBuilder->selectById('online_payment', '*', $where);
                $paymentRequest  = $queryBuilder->selectById('payment_request', '*', $where);
                $gatewayLoader->loadReceiptFunctions('adityabirla', $connMain, $conn, $paymentRequest);                 
                if(isset($onlinePaymentInfo['paymentType']) && $onlinePaymentInfo['paymentType'] == 'mobile')
                {
                    $redirectToMobile = true;
                }
                if (! empty($paymentRequest) && $paymentRequest['screen'] == 'declaration-payment') {
                    $redirectToApplicantPortal = true ;
                }                
                if (isset($onlinePaymentInfo['paymentType']) && $onlinePaymentInfo['paymentType']  == 'applicantPortal') {
                    $redirectToApplicantPortal = true;
                }else if (isset($onlinePaymentInfo['paymentType']) && $onlinePaymentInfo['paymentType'] == 'studentPortal') {
                    $redirectToStudentPortal = true;
                }
                if (! empty($paymentRequest) && $paymentRequest['screen'] == 'donation-payment') {
                    $where = ['id' => $paymentRequest['paymentId']];
                    $paymentInfo  = $queryBuilder->selectById('donation_payment', '*', $where);
                    echo '<div class="col-md-12 text-center" id="gotohome">
                          <a href="' . $paymentInfo['redirectURL'] . '#/donate-funds" class="btn btn-primary proceedBtn">Go to Dashboard</a>
                      </div>';
                }
                            
            break;
            case 'icici':
                if(!isset($_REQUEST['Response_Code']) && !isset($_REQUEST['Unique_Ref_Number']) && !isset($_REQUEST['ReferenceNo']))
                {
                    Logger::warning("Skipping ICICI: response does not contain 'Response_Code' or 'Unique_Ref_Number' or 'ReferenceNo'");
                    continue 2;
                }
                $where = ['txnId' => $_REQUEST['ReferenceNo']];
                $onlinePaymentInfo = $queryBuilder->selectById('online_payment', '*', $where);
                $paymentRequest  = $queryBuilder->selectById('payment_request', '*', $where);
                $paymentRequest['responseData'] = $_REQUEST;                
                $gatewayLoader->loadReceiptFunctions('icici', $connMain, $conn, $paymentRequest);                 
                if(isset($onlinePaymentInfo['paymentType']) && $onlinePaymentInfo['paymentType'] == 'mobile')
                {
                    $redirectToMobile = true;
                }
                if (! empty($paymentRequest) && $paymentRequest['screen'] == 'declaration-payment') {
                    $redirectToApplicantPortal = true ;
                }          
                if (isset($onlinePaymentInfo['paymentType']) && $onlinePaymentInfo['paymentType']  == 'applicantPortal') {
                    $redirectToApplicantPortal = true;
                }else if (isset($onlinePaymentInfo['paymentType']) && $onlinePaymentInfo['paymentType'] == 'studentPortal') {
                    $redirectToStudentPortal = true;
                }
                if (! empty($paymentRequest) && $paymentRequest['screen'] == 'donation-payment') {
                    $where = ['id' => $paymentRequest['paymentId']];
                    $paymentInfo  = $queryBuilder->selectById('donation_payment', '*', $where);
                    echo '<div class="col-md-12 text-center" id="gotohome">
                          <a href="' . $paymentInfo['redirectURL'] . '#/donate-funds" class="btn btn-primary proceedBtn">Go to Dashboard</a>
                      </div>';
                }
                            
            break;
            case 'bsp':
                if(!isset($_REQUEST['trx']) && !isset($_REQUEST['key']))
                {
                    Logger::warning("Skipping bsp: response does not contain 'trx' an 'key'");
                    continue 2;
                }
                $where = ['txnId' => $_REQUEST['key']];
                $onlinePaymentInfo = $queryBuilder->selectById('online_payment', '*', $where);
                $paymentRequest  = $queryBuilder->selectById('payment_request', '*', $where);
                $paymentRequest['responseData'] = $_REQUEST;                
                $gatewayLoader->loadReceiptFunctions('bsp', $connMain, $conn, $paymentRequest);                 
                if(isset($onlinePaymentInfo['paymentType']) && $onlinePaymentInfo['paymentType'] == 'mobile')
                {
                    $redirectToMobile = true;
                }
                if (! empty($paymentRequest) && $paymentRequest['screen'] == 'declaration-payment') {
                    $redirectToApplicantPortal = true ;
                }          
                if (isset($onlinePaymentInfo['paymentType']) && $onlinePaymentInfo['paymentType']  == 'applicantPortal') {
                    $redirectToApplicantPortal = true;
                }else if (isset($onlinePaymentInfo['paymentType']) && $onlinePaymentInfo['paymentType'] == 'studentPortal') {
                    $redirectToStudentPortal = true;
                }
                if (! empty($paymentRequest) && $paymentRequest['screen'] == 'donation-payment') {
                    $where = ['id' => $paymentRequest['paymentId']];
                    $paymentInfo  = $queryBuilder->selectById('donation_payment', '*', $where);
                    echo '<div class="col-md-12 text-center" id="gotohome">
                          <a href="' . $paymentInfo['redirectURL'] . '#/donate-funds" class="btn btn-primary proceedBtn">Go to Dashboard</a>
                      </div>';
                }
                            
            break;
            case 'ccavenue':
                if(!isset($_REQUEST['encResp']) || !isset($_REQUEST['accessCode']) || !isset($_REQUEST['orderNo']))
                {
                    Logger::warning("Skipping ccavenue: response does not contain 'encResp' or 'accessCode' and 'orderNo' ");
                    continue 2;
                }
                $where = ['txnId' => $_REQUEST['orderNo']];                
                $onlinePaymentInfo = $queryBuilder->selectById('online_payment', '*', $where);               
                $paymentRequest  = $queryBuilder->selectById('payment_request', '*', $where);
                $paymentRequest['responseData'] = $_REQUEST;                
                $gatewayLoader->loadReceiptFunctions('ccavenue', $connMain, $conn, $paymentRequest);                 
                if(isset($onlinePaymentInfo['paymentType']) && $onlinePaymentInfo['paymentType'] == 'mobile')
                {
                    $redirectToMobile = true;
                }
                if (! empty($paymentRequest) && $paymentRequest['screen'] == 'declaration-payment') {
                    $redirectToApplicantPortal = true ;
                }          
                if (isset($onlinePaymentInfo['paymentType']) && $onlinePaymentInfo['paymentType']  == 'applicantPortal') {
                    $redirectToApplicantPortal = true;
                }else if (isset($onlinePaymentInfo['paymentType']) && $onlinePaymentInfo['paymentType'] == 'studentPortal') {
                    $redirectToStudentPortal = true;
                }
                if (! empty($paymentRequest) && $paymentRequest['screen'] == 'donation-payment') {
                    $where = ['id' => $paymentRequest['paymentId']];
                    $paymentInfo  = $queryBuilder->selectById('donation_payment', '*', $where);
                    echo '<div class="col-md-12 text-center" id="gotohome">
                          <a href="' . $paymentInfo['redirectURL'] . '#/donate-funds" class="btn btn-primary proceedBtn">Go to Dashboard</a>
                      </div>';
                }
                            
            break;
            default:
                Logger::warning("Unsupported payment gateway: $gateway");       
                break;
        }
    }   
} catch (Exception $e) {   
    echo '<div class="col-md-12 text-center alert alert-warning">
    <h4>'.$translationMsg['TRANSACTION_ERROR'].'</h4>
  </div>';
}

if($redirectToMobile)
{
echo '<div class="col-md-12 text-center" id="gotohome" >
        <a href="'.baseURL.'/mobile-payment" class="btn btn-primary proceedBtn">'.$translationMsg['GO_TO_Home_Page'].'</a>
    </div>';
}
if($redirectToApplicantPortal)
{
echo '<div class="col-md-12 text-center" id="gotohome" >
        <a href="'.baseURL.'/applicant-portal" class="btn btn-primary proceedBtn">'.$translationMsg['GO_TO_Home_Page'].'</a>
    </div>';
}
if($redirectToStudentPortal)
{
echo '<div class="col-md-12 text-center" id="gotohome" >
        <a href="'.baseURL.'/student-portal" class="btn btn-primary proceedBtn">'.$translationMsg['GO_TO_Home_Page'].'</a>
    </div>';
}
session_destroy();

require_once "footer.php";
