<?php
require_once("./config/db_config.php");
require_once("./config/functionclass.php");

class CourseEnrollement{

    public $accessToken;
    private $conn;
    private $connMain;
    private $ClassObject;
    private $nonsec;

    function __construct() {
        $this->ClassObject = new PHPClass();
        $token =  $this->ClassObject->getToken();
        $token = json_decode($token);
        $this->accessToken = isset($token->access_token) ? $token->access_token : '';
        $this->nonsec = isset($token->nonsec) ? $token->nonsec : '';
    }

    // private $conn;

    public function setConnection($applyNowConnection, $coreERPConnection) {
        $this->conn = $applyNowConnection;
        $this->connMain = $coreERPConnection;
    }

    function createPaymentId($inputParam){
        if(!$this->accessToken)
        {
            return "ACCESS_TOKEN";
        }
        else
        {
            $responseVal = '';
            if(isset($inputParam['onlinePaymentId']) > 0 && $inputParam['onlinePaymentId'] != "")
            {
                $authorization = "Authorization: Bearer " . $this->accessToken;
                $applicantjson='{"id":"'.$inputParam['onlinePaymentId'].'"}';
                $options = array(
                    'public_key' => isset($this->nonsec)?$this->nonsec:'',
                    'params' => '',
                    'jsonData' => $applicantjson,
                    'access_token' => isset($this->accessToken)?$this->accessToken:'',
                );
                $nonce = $this->ClassObject->secMe($options);
                $ch = curl_init(baseURL . EnrollStudentDetails);
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
                curl_setopt($ch, CURLOPT_POSTFIELDS, $applicantjson);
                curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_TIMEOUT, 120);
                curl_setopt(
                    $ch,
                    CURLOPT_HTTPHEADER,
                    array(
                        'Content-Type: application/json', $authorization,
                        'Content-Length: ' . strlen($applicantjson),
                        'nonce:' .$nonce
                    )
                );
                $resultcurl = curl_exec($ch);
                $responseERP2 = json_decode($resultcurl);
                $studentName = (isset($_POST['studentName'])) ? $_POST['studentName'] : '';
                $program = (isset($_POST['programName'])) ? $_POST['programName'] : '';
                $batch = (isset($_POST['batchName'])) ? $_POST['batchName'] : '';
                $feeHead = (isset($_POST['feeHeadName'])) ? $_POST['feeHeadName'] : '';
                $costCenterId  = (isset($responseERP2->costCenterId)) ? $responseERP2->costCenterId : '';                   
                if ($responseERP2->phoneNo)
                {
                    $phoneNo = $responseERP2->phoneNo;
                }
                else
                {
                    $phoneNo = $responseERP2->mobileNo;
                }
                $receiptAmount = (isset($responseERP2->receiptAmount) && $responseERP2->receiptAmount) ? $responseERP2->receiptAmount : 0;
                $currency = (isset($responseERP2->currencyCode) && $responseERP2->currencyCode) ? $responseERP2->currencyCode : '';
                if($receiptAmount > 0)
                {
                    try {
                        $query = "INSERT INTO enrollment_payment (onlinePaymentId, txnId, paymentStatus, paymentDate, receiptStatus, amount,name,email,phoneNo,studentId,code, studentName, program, batch, feeHead,costCenterId , currency) VALUES ('" . $_POST['onlinePaymentId'] . "','','Initiate', '".date('Y-m-d H:i:s')."'  ,''," . $receiptAmount . ",'" . $responseERP2->fullName . "','" . $responseERP2->emailId . "','" . $phoneNo . "','" . $responseERP2->studentId . "','" . $responseERP2->code . "','" . $studentName . "','" . $program . "','" . $batch . "','" . $feeHead . "','".$costCenterId."','" . $currency . "' )";
                        $insert = mysqli_query($this->conn, $query);
                        $paymentId = mysqli_insert_id($this->conn);
                        $responseVal = $paymentId;
                    } catch (Exception $e) {
                        $responseVal = "QUERY_ERROR";
                    }
                }
                else
                {
                    $responseVal = "AMOUNT_ISSUE";
                }
            }
            else
            {
                $responseVal = "INVALID_PARAM";
            }
            return $responseVal;
        }
    }

    function getMerchantDetailsByAl($academyLocationId) {
        if(!$this->accessToken)
        {
             return "ACCESS_TOKEN";
        }
        else
        {
            $authorization = "Authorization: Bearer " . $this->accessToken;
            $url = baseURL . gatewayDetailsAPI . '?isActive=true&academyLocationIds=' . $academyLocationId;
            $options = array(
                'public_key' => isset($this->nonsec)?$this->nonsec:'',
                'params' => 'isActive=true&academyLocationIds=' . $academyLocationId,
                'jsonData' => '',
                'access_token' => isset($this->accessToken)?$this->accessToken:'',
            );
            $nonce = $this->ClassObject->secMe($options);
            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_TIMEOUT, 120);
            curl_setopt(
                $ch,
                CURLOPT_HTTPHEADER,
                array(
                    'Content-Type: application/json',
                    $authorization,
                    'nonce:' .$nonce
                )
            );

            $resultcurl = curl_exec($ch);
            $responseERPGateway = json_decode($resultcurl, true);
            if(count($responseERPGateway) > 0)
            {
                return $responseERPGateway[0];
            }
            else
            {
                return 'No_DATA';
            }
        }
    }

    function getStandardMerchantDetailsByAl($gatewayName , $academyLocationId, $currencyCode = '' , $costCenter = '') {
        if(!$this->accessToken)
        {
             return "ACCESS_TOKEN";
        }
        else
        {
            $authorization = "Authorization: Bearer " . $this->accessToken;
            $params = 'qry='.$gatewayName.'&academyLocationId=' . $academyLocationId.'&currencyCode='.$currencyCode.'&costCenterId='.$costCenter;
            $url = baseURL . getStandardMerchantDetails . '?'.$params;
            
            $options = array(
                'public_key' => isset($this->nonsec)?$this->nonsec:'',
                'params' => $params,
                'jsonData' => '',
                'access_token' => isset($this->accessToken)?$this->accessToken:'',
            );
            $nonce = $this->ClassObject->secMe($options);
            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_TIMEOUT, 120);
            curl_setopt(
                $ch,
                CURLOPT_HTTPHEADER,
                array(
                    'Content-Type: application/json',
                    $authorization,
                    'nonce:' .$nonce
                )
            );

            $resultcurl = curl_exec($ch);
            $responceERPGateway = json_decode($resultcurl, true);
            $responceERPGateway = array_change_key_case($responceERPGateway, CASE_LOWER);
            if(count($responceERPGateway) > 0 && !empty($responceERPGateway[$gatewayName]))
            {
                return $responceERPGateway;
            }
            else
            {
                return 'No_DATA';
            }
        }
    }

    function createReceipt($onlinePaymentId, $txnId, $orderStatus) {
        if(!$this->accessToken)
        {
            return "ACCESS_TOKEN";
        }
        else
        {
            $authorization = "Authorization: Bearer " . $this->accessToken;
            $selectInstumentCount = 0;
            if($txnId && !is_null($txnId))
            {
                $receiptInstrumentQuery = "SELECT * FROM receipt_payment_instrument where instrumentNo = '".$txnId."'";
                $selectInstument = mysqli_query($this->connMain, $receiptInstrumentQuery);
                $selectInstumentCount = mysqli_num_rows($selectInstument);
            }
            if($selectInstumentCount == 0)
            {

                $applicantjson='{"id":"'.$onlinePaymentId.'","txnid":"'.$txnId.'","status":"'.$orderStatus.'"}';
                $options = array(
                    'public_key' => isset($this->nonsec)?$this->nonsec:'',
                    'params' => '',
                    'jsonData' => $applicantjson,
                    'access_token' => isset($this->accessToken)?$this->accessToken:'',
                );
                $nonce = $this->ClassObject->secMe($options);
                $ch = curl_init(baseURL . EnrollStudentUpdateStatus);
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
                curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

                curl_setopt($ch, CURLOPT_POSTFIELDS, $applicantjson);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_TIMEOUT, 120);
                curl_setopt(
                    $ch,
                    CURLOPT_HTTPHEADER,
                    array(
                        'Content-Type: application/json', $authorization,
                        'Content-Length: ' . strlen($applicantjson),
                        'nonce:' .$nonce
                    )
                );

                $resultcurl = curl_exec($ch);

                $applicantjson_save='{"id":'.$onlinePaymentId.'}';
                $options = array(
                    'public_key' => isset($this->nonsec)?$this->nonsec:'',
                    'params' => '',
                    'jsonData' => $applicantjson_save,
                    'access_token' => isset($this->accessToken)?$this->accessToken:'',
                );
                $nonce = $this->ClassObject->secMe($options);
                $ch1 = curl_init(baseURL . EnrollStudentCreateReceipt);
                curl_setopt($ch1, CURLOPT_CUSTOMREQUEST, "POST");
                curl_setopt($ch1, CURLOPT_POSTFIELDS, $applicantjson_save);
                curl_setopt($ch1, CURLOPT_FOLLOWLOCATION, TRUE);
                curl_setopt($ch1, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch1, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch1, CURLOPT_TIMEOUT, 120);
                curl_setopt(
                    $ch1,
                    CURLOPT_HTTPHEADER,
                    array(
                    'Content-Type: application/json', $authorization,
                    'Content-Length: ' . strlen($applicantjson_save),
                    'nonce:' .$nonce
                    )
                );

                $resultcurl1 = curl_exec($ch1);
                if($resultcurl1 == 'SUCCESS' || $resultcurl1 == 'success')
                {
                    return "SUCCESS";
                }
                else
                {
                    return "RECEIPT_NOT_GENERATE";
                }
            }
            else
            {
                return "RECEIPT_ALREADY_GENERATE";
            }
        }
    }

}


// $res_result = callAPI($method, $url, $finalJsonReq);
// $dualVerifyData = json_decode($res_result, true);

// print_r($response_msg);