<?php
require_once("./config/db_config.php");
require_once("./config/functionclass.php");
class CourseRegistrationPayment{

    public $accessToken;
    private $conn;

    private $connMain;
    private $ClassObject;
    private $nonsec;

    function __construct($accessToken = '') {

        // global $conn;
        $this->ClassObject = new PHPClass();
        $token =  $this->ClassObject->getToken();
        $token = json_decode($token);
        $this->accessToken = isset($token->access_token) ? $token->access_token : '';
        $this->nonsec = isset($token->nonsec) ? $token->nonsec : '';
        // $this->conn = $conn;
    }

    // private $conn;

    public function setConnection($applyNowConnection, $coreERPConnection) {
        $this->conn = $applyNowConnection;
        $this->connMain = $coreERPConnection;
    }
    function createOnlinePaymentId($inputParam){
       if(!$this->accessToken)
       {
            return "ACCESS_TOKEN";
       }
       else
       {
            $responceVal = '';
            if(isset($inputParam['paymentId']) > 0 && $inputParam['paymentId'] != "")
            {
                $requestUrl = isset($inputParam['requestUrl']) ? $inputParam['requestUrl'] : '';
                $paymentId = $inputParam['paymentId'];
                $authorization = "Authorization: Bearer " . $this->accessToken;
                $applicantjson='{"id":"'.$paymentId.'"}';
                $options = array(
                    'public_key' => isset($this->nonsec)?$this->nonsec:'',
                    'params' => '',
                    'jsonData' => $applicantjson,
                    'access_token' => isset($this->accessToken)?$this->accessToken:'',
                );
                $nonce = $this->ClassObject->secMe($options);
                $ch = curl_init(baseURL . fetchRegistrationPortalInfo);
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
                curl_setopt($ch, CURLOPT_POSTFIELDS, $applicantjson);
                curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_TIMEOUT, 120);
                curl_setopt(
                    $ch,
                    CURLOPT_HTTPHEADER,
                    array(
                        'Content-Type: application/json', $authorization,
                        'Content-Length: ' . strlen($applicantjson),
                        'nonce:' .$nonce
                    )
                );
                $resultcurl = curl_exec($ch);
                //echo $resultcurl;
                $responceERP2 = json_decode($resultcurl);
                if(isset($responceERP2->receiptAmount) && $responceERP2->receiptAmount && $responceERP2->receiptAmount > 0)
                {
                    $academyLocationId = $responceERP2->academyLocationId;
                    $paymentType = 'Course-Wise-Payment';
                    if(empty($responceERP2->fullName))
                    {
                        $responceERP2->fullName = $responceERP2->firstName.' '.$responceERP2->lastName;
                    }
                    try {
                        $currencyCode = isset($responceERP2->currencyCode) ? $responceERP2->currencyCode : '';
                        $currentDateTime = date('Y-m-d H:i:s');
                        $query = 'INSERT INTO course_registration_payment (paymentType, onlinePaymentId, txnId, paymentStatus, paymentDate, receiptStatus, amount,name,email,studentId,code,phoneNo,mobileNo,cellCountryCode,academyLocationId, admissionId, requestUrl,currency) VALUES ("'.$paymentType.'","' . $paymentId . '","","", "'.$currentDateTime.'" ,"",' . $responceERP2->receiptAmount . ',"' . $responceERP2->fullName . '","' . $responceERP2->emailId . '","' . $responceERP2->studentId . '","' . $responceERP2->code . '","' . $responceERP2->phoneNo . '","' . $responceERP2->mobileNo . '","' . $responceERP2->cellCountryCode . '", "'.$academyLocationId.'", "'.$_REQUEST['admissionId'].'", "'.$requestUrl.'","'.$currencyCode.'")';
                        $insert = mysqli_query($this->conn, $query);
                        $paymentId = mysqli_insert_id($this->conn);
                        $responceVal = $paymentId;
                    } catch (Exception $e) {
                        $responceVal = "QUERY_ERROR";
                    }
                }
                else
                {
                    $responceVal = "AMOUNT_ISSUE";
                }
            }
            else
            {
                $responceVal = "INVALID_PARAM";
            }
            return $responceVal;
        }
    }

    function getStandardMerchantDetailsByAl($gatewayName , $academyLocationId, $currencyCode = '') {
        if(!$this->accessToken)
        {
             return "ACCESS_TOKEN";
        }
        else
        {
            $authorization = "Authorization: Bearer " . $this->accessToken;
            $params= 'qry='.$gatewayName.'&academyLocationId=' . $academyLocationId.'&$currencyCode='.$currencyCode;
            $url = baseURL . getStandardMerchantDetails . '?'.$params;
            
            $options = array(
                'public_key' => isset($this->nonsec)?$this->nonsec:'',
                'params' => $params,
                'jsonData' => '',
                'access_token' => isset($this->accessToken)?$this->accessToken:'',
            );
            $nonce = $this->ClassObject->secMe($options);
            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_TIMEOUT, 120);
            curl_setopt(
                $ch,
                CURLOPT_HTTPHEADER,
                array(
                    'Content-Type: application/json',
                    $authorization,
                    'nonce:' .$nonce
                )
            );

            $resultcurl = curl_exec($ch);
            $responceERPGateway = json_decode($resultcurl, true);
            $responceERPGateway = array_change_key_case($responceERPGateway, CASE_LOWER); 
            if(count($responceERPGateway) > 0 && !empty($responceERPGateway[$gatewayName]))
            {
                return $responceERPGateway;
            }
            else
            {
                return 'No_DATA';
            }
        }
    }
    

    function createReceipt($data) {
        $txnId = $data['txnId'];
        $onlinePaymentId = $data['onlinePaymentId'];
        if(!$this->accessToken)
        {
            return "ACCESS_TOKEN";
        }
        else
        {
            $authorization = "Authorization: Bearer " . $this->accessToken;
            $selectInstumentCount = 0;
            if (!$this->connMain) {
                die("Connection failed: " . mysqli_connect_error());
            }
            if($txnId && !is_null($txnId))
            {
                $receiptInstrumentQuery = "SELECT * FROM receipt_payment_instrument where instrumentNo = '".$txnId."'";
                $selectInstument = mysqli_query($this->connMain, $receiptInstrumentQuery);
                $selectInstumentCount = mysqli_num_rows($selectInstument);
            }

            if($selectInstumentCount == 0)
            {
                $applicantjson = '{"id":"'.$onlinePaymentId.'","txnid":"'.$txnId.'","status": "'.$data['paymentStatus'].'"}';
                $options = array(
                    'public_key' => isset($this->nonsec)?$this->nonsec:'',
                    'params' => '',
                    'jsonData' => $applicantjson,
                    'access_token' => isset($this->accessToken)?$this->accessToken:'',
                );
                $nonce = $this->ClassObject->secMe($options);
                $ch = curl_init(baseURL . updateTransactionStatus);
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
                curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

                curl_setopt($ch, CURLOPT_POSTFIELDS, $applicantjson);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_TIMEOUT, 120);
                curl_setopt(
                    $ch,
                    CURLOPT_HTTPHEADER,
                    array(
                        'Content-Type: application/json', $authorization,
                        'Content-Length: ' . strlen($applicantjson),
                        'nonce:' .$nonce
                    )
                );

                $resultcurl = curl_exec($ch);

                $applicantjson_save = '{"id":"'.$onlinePaymentId.'","admissionId":'.$data['admissionId'].'}';
                $options = array(
                    'public_key' => isset($this->nonsec)?$this->nonsec:'',
                    'params' => '',
                    'jsonData' => $applicantjson_save,
                    'access_token' => isset($this->accessToken)?$this->accessToken:'',
                );
                $nonce = $this->ClassObject->secMe($options);

                $ch1 = curl_init(baseURL . receiptGeneratedForCoursePayment);
                curl_setopt($ch1, CURLOPT_CUSTOMREQUEST, "POST");
                curl_setopt($ch1, CURLOPT_POSTFIELDS, $applicantjson_save);
                curl_setopt($ch1, CURLOPT_FOLLOWLOCATION, TRUE);
                curl_setopt($ch1, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch1, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch1, CURLOPT_TIMEOUT, 120);
                curl_setopt(
                    $ch1,
                    CURLOPT_HTTPHEADER,
                    array(
                    'Content-Type: application/json', $authorization,
                    'Content-Length: ' . strlen($applicantjson_save),
                    'nonce:' .$nonce
                    )
                );

                $resultcurl1 = curl_exec($ch1);
                if(strtolower($resultcurl1) == 'success')
                {
                    return "SUCCESS";
                }
                else
                {
                    return 'RECEIPT-FAILED';
                }
            }
            else
            {
                return "RECEIPT_ALREADY_GENERATE";
            }
        }
    }

}