<?php
require_once("./config/db_config.php");
require_once("./config/functionclass.php");
class OnlinePayment{

    public $accessToken;
    private $conn;

    private $connMain;
    private $ClassObject;
    private $nonsec;

    function __construct($accessToken = '') {

        // global $conn;
        $this->ClassObject = new PHPClass();
        $token =  $this->ClassObject->getToken();
        $token = json_decode($token);
        $this->accessToken = isset($token->access_token) ? $token->access_token : '';
        $this->nonsec = isset($token->nonsec) ? $token->nonsec : '';
        // $this->conn = $conn;
    }

    // private $conn;

    public function setConnection($applyNowConnection, $coreERPConnection) {
        $this->conn = $applyNowConnection;
        $this->connMain = $coreERPConnection;
    }
    function createOnlinePaymentId($inputParam){
       if(!$this->accessToken)
       {
            return "ACCESS_TOKEN";
       }
       else
       {
            $responceVal = '';
            if(isset($inputParam['onlinePaymentId']) > 0 && $inputParam['onlinePaymentId'] != "")
            {
                $authorization = "Authorization: Bearer " . $this->accessToken;
                $applicantjson='{"id":"'.$inputParam['onlinePaymentId'].'"}';
                $options = array(
                    'public_key' => isset($this->nonsec)?$this->nonsec:'',
                    'params' => '',
                    'jsonData' => $applicantjson,
                    'access_token' => isset($this->accessToken)?$this->accessToken:'',
                );
                $nonce = $this->ClassObject->secMe($options);
                $ch = curl_init(baseURL . fetchInfoRest);
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
                curl_setopt($ch, CURLOPT_POSTFIELDS, $applicantjson);
                curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_TIMEOUT, 120);
                curl_setopt(
                    $ch,
                    CURLOPT_HTTPHEADER,
                    array(
                        'Content-Type: application/json', $authorization,
                        'Content-Length: ' . strlen($applicantjson),
                        'nonce:' .$nonce
                    )
                );
                $resultcurl = curl_exec($ch);
                //echo $resultcurl;
                $responceERP2 = json_decode($resultcurl);
                // print_r($responceERP2); 
                if(isset($responceERP2->receiptAmount) && $responceERP2->receiptAmount && $responceERP2->receiptAmount > 0)
                {
                    if ($responceERP2->phoneNo)
                    {
                        $phoneNo = $responceERP2->phoneNo;
                    }
                    else
                    {
                        $phoneNo = $responceERP2->mobileNo;
                    }
                    $currencyCode = (isset($responceERP2->currencyCode) && !empty(($responceERP2->currencyCode)))?$responceERP2->currencyCode : '';
                    $studentName = (isset($_POST['studentName'])) ? $_POST['studentName'] : '';
                    $program = (isset($_POST['programName'])) ? $_POST['programName'] : '';
                    $batch = (isset($_POST['batchName'])) ? $_POST['batchName'] : '';
                    $feeHead = (isset($responceERP2->feeHeadDetails)) ? $responceERP2->feeHeadDetails : '';
                    $feeHead = json_encode($feeHead, true); 
                    $paymentType = (isset($_POST['paymentType'])) ? $_POST['paymentType'] : 'CORE-ERP';

                    try {
                        $query = "INSERT INTO online_payment (onlinePaymentId, txnId, paymentStatus, paymentDate, receiptStatus, amount,name,email,phoneNo,applicantId,studentId,code,currency,  studentName, program, batch, feeHead, paymentType) VALUES ('" . $inputParam['onlinePaymentId'] . "','','initiate', '".date('Y-m-d H:i:s')."'  ,''," . $responceERP2->receiptAmount . ",'" . $responceERP2->fullName . "','" . $responceERP2->emailId . "','" . $phoneNo . "','" . $responceERP2->applicantId . "','" . $responceERP2->studentId . "','" . $responceERP2->code . "','" . $currencyCode . "' ,'" . $studentName . "','" . $program . "','" . $batch . "','" . $feeHead . "', '".$paymentType."')";
                        $insert = mysqli_query($this->conn, $query);
                        $paymentId = mysqli_insert_id($this->conn);
                        $responceVal = $paymentId;
                    } catch (Exception $e) {
                        $responceVal = "QUERY_ERROR";
                    }
                }
                else
                {
                    $responceVal = "AMOUNT_ISSUE";
                }
            }
            else
            {
                $responceVal = "INVALID_PARAM";
            }
            return $responceVal;
        }
    }

    function getMerchantDetailsByAl($academyLocationId) {
        if(!$this->accessToken)
        {
             return "ACCESS_TOKEN";
        }
        else
        {
            $authorization = "Authorization: Bearer " . $this->accessToken;
            $url = baseURL . gatewayDetailsAPI . '?isActive=true&academyLocationIds=' . $academyLocationId;
            $options = array(
                'public_key' => isset($this->nonsec)?$this->nonsec:'',
                'params' => 'isActive=true&academyLocationIds=' . $academyLocationId,
                'jsonData' => '',
                'access_token' => isset($this->accessToken)?$this->accessToken:'',
            );
            $nonce = $this->ClassObject->secMe($options);
            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_TIMEOUT, 120);
            curl_setopt(
                $ch,
                CURLOPT_HTTPHEADER,
                array(
                    'Content-Type: application/json',
                    $authorization,
                    'nonce:' .$nonce
                )
            );

            $resultcurl = curl_exec($ch);
            $responceERPGateway = json_decode($resultcurl, true);
            if(count($responceERPGateway) > 0)
            {
                return $responceERPGateway[0];
            }
            else
            {
                return 'No_DATA';
            }
        }
    }

    function getStandardMerchantDetailsByAl($gatewayName , $academyLocationId, $currencyCode = '' , $costCenter = '') {
        if(!$this->accessToken)
        {
             return "ACCESS_TOKEN";
        }
        else
        {
            $authorization = "Authorization: Bearer " . $this->accessToken;
            $params = 'qry='.$gatewayName.'&academyLocationId=' . $academyLocationId.'&currencyCode='.$currencyCode.'&costCenterId='.$costCenter; //@Ashish this api calls for merchant details
            $url = baseURL . getStandardMerchantDetails . '?'.$params;
           
            $options = array(
                'public_key' => isset($this->nonsec)?$this->nonsec:'',
                'params' => $params,
                'jsonData' => '',
                'access_token' => isset($this->accessToken)?$this->accessToken:'',
            );
            $nonce = $this->ClassObject->secMe($options);
            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_TIMEOUT, 120);
            curl_setopt(
                $ch,
                CURLOPT_HTTPHEADER,
                array(
                    'Content-Type: application/json',
                    $authorization,
                    'nonce:' .$nonce
                )
            );

            $resultcurl = curl_exec($ch);
            $responceERPGateway = json_decode($resultcurl, true);
            $responceERPGateway = array_change_key_case($responceERPGateway, CASE_LOWER);
            if(count($responceERPGateway) > 0 && !empty($responceERPGateway[$gatewayName]))
            {
                return $responceERPGateway;
            }
            else
            {
                return 'No_DATA';
            }
        }
    }    

    function createReceipt($onlinePaymentId, $txnId, $orderStatus) {
        if(!$this->accessToken)
        {
            return "ACCESS_TOKEN";
        }
        else
        {
            $authorization = "Authorization: Bearer " . $this->accessToken;
            $selectInstumentCount = 0;
            if (!$this->connMain) {
                die("Connection failed: " . mysqli_connect_error());
            }
            if($txnId && !is_null($txnId))
            {
                $receiptInstrumentQuery = "SELECT * FROM receipt_payment_instrument where instrumentNo = '".$txnId."'";
                $selectInstument = mysqli_query($this->connMain, $receiptInstrumentQuery);
                $selectInstumentCount = mysqli_num_rows($selectInstument);
            }

            if($selectInstumentCount == 0)
            {
                $applicantjson='{"id":"'.$onlinePaymentId.'","txnid":"'.$txnId.'","status":"'.$orderStatus.'"}';
                $options = array(
                    'public_key' => isset($this->nonsec)?$this->nonsec:'',
                    'params' => '',
                    'jsonData' => $applicantjson,
                    'access_token' => isset($this->accessToken)?$this->accessToken:'',
                );
                $nonce = $this->ClassObject->secMe($options);
                $ch = curl_init(baseURL . successRestUpdateStatus);
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
                curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

                curl_setopt($ch, CURLOPT_POSTFIELDS, $applicantjson);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_TIMEOUT, 120);
                curl_setopt(
                    $ch,
                    CURLOPT_HTTPHEADER,
                    array(
                        'Content-Type: application/json', $authorization,
                        'Content-Length: ' . strlen($applicantjson),
                        'nonce:' .$nonce
                    )
                );

                $resultcurl = curl_exec($ch);

                $applicantjson_save='{"id":'.$onlinePaymentId.'}';
                $options = array(
                    'public_key' => isset($this->nonsec)?$this->nonsec:'',
                    'params' => '',
                    'jsonData' => $applicantjson_save,
                    'access_token' => isset($this->accessToken)?$this->accessToken:'',
                );
                $nonce = $this->ClassObject->secMe($options);

                $ch1 = curl_init(baseURL . successRestCreateReceipt);
                curl_setopt($ch1, CURLOPT_CUSTOMREQUEST, "POST");
                curl_setopt($ch1, CURLOPT_POSTFIELDS, $applicantjson_save);
                curl_setopt($ch1, CURLOPT_FOLLOWLOCATION, TRUE);
                curl_setopt($ch1, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch1, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch1, CURLOPT_TIMEOUT, 120);
                curl_setopt(
                    $ch1,
                    CURLOPT_HTTPHEADER,
                    array(
                    'Content-Type: application/json', $authorization,
                    'Content-Length: ' . strlen($applicantjson_save),
                    'nonce:' .$nonce
                    )
                );

                $resultcurl1 = curl_exec($ch1);
                $responceERP1 = json_decode($resultcurl1);
                if($responceERP1 == $onlinePaymentId)
                {
                    return "SUCCESS";
                }
                else
                {
                    return $responceERP1;
                }
            } 
            else
            {
                return "RECEIPT_ALREADY_GENERATE";
            }
        }
    }

}
