<?php
require_once("db_config.php");
require_once("functionclass.php");

class GatewayConfig {

    private $accessToken;
    private $nonsec;
    private $ClassObject;

    public function __construct() {
        $this->ClassObject = new PHPClass();
        $token =  $this->ClassObject->getToken();
        $token = json_decode($token);
        $this->accessToken = isset($token->access_token) ? $token->access_token : '';
        $this->nonsec = isset($token->nonsec) ? $token->nonsec : '';
        if (session_status() === PHP_SESSION_NONE) {
            session_start(); // Start the session if not already started
        }
    }

    public function getActiveGateway($academyLocationId = '') {
        // Check if access token is empty
        if (empty($this->accessToken)) {
            echo "Access token is missing or invalid.";
            return null;
        }
        
        $authorization = "Authorization: Bearer " . $this->accessToken;      
        $url = baseURL . standardGatewayDetailsApi.'?isActive=true&academyLocationId='.$academyLocationId;      

        $options = array(
            'public_key' => isset($this->nonsec)?$this->nonsec:'',
            'params' => 'isActive=true&academyLocationId='.$academyLocationId,
            'jsonData' => '',
            'access_token' => isset($this->accessToken)?$this->accessToken:'',
        );       
        $curl = curl_init();
        $nonce = $this->ClassObject->secMe($options);
        $ch = curl_init($url);        
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // Disable SSL verification
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 120);
        
        // Set HTTP headers
        curl_setopt(
            $ch,
            CURLOPT_HTTPHEADER,
            array(
                'Content-Type: application/json',
                $authorization,
                'nonce:' .$nonce,
                
            )
        );
        
        // Enable verbose output for debugging
        curl_setopt($ch, CURLOPT_VERBOSE, true);

        // Execute cURL request and capture response
        $response = curl_exec($ch);

        // Check for curl errors
        if (curl_errno($ch)) {
            echo 'Curl error: ' . curl_error($ch);  // Output curl error
        }

        // Check the HTTP status code
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        // echo "HTTP Status Code: $httpCode\n";

        curl_close($ch);

        // If response is not empty, process it
        if ($response) {
            // Print the raw response for debugging
            // echo "<pre>Raw Response:\n";
            // print_r($response);
            // echo "</pre>";

            // Decode JSON response and return it
            $data = json_decode($response, true);
            // $data = array_merge($data, $this->getDummyGatewayData()); //use this to add dummy response
            for($i = 0; $i < count($data); $i++){
                
                $data[$i]['value'] = strtolower($data[$i]['value']);
                if($data[$i]['value'] == 'authorize.net')
                {
                   $data[$i]['value'] = 'authorizedotnet';
                }
            }
            // Print decoded response data
            // echo "<pre>Decoded Response:\n";
            // print_r($data);
            // echo "</pre>";
            
            return $data ?? null;
        } else {
            echo "No response received from API.\n";
        }

        return null;
    }


//     private function getDummyGatewayData() {
//     return [
//         [
//             'id' => 4,
//             'name' => 'CC Aveneue',
//             'value' => 'ccaveneue',
//             'isActive' => true,
//             'activeStatus' => 1
//         ],
        
//     ];
// }


    public function set_session($gatewayName, $gatewaySelected = false)
    {
        $_SESSION['gateway'] = $gatewayName;
        $_SESSION['gateway_selected'] = $gatewaySelected;
    }

    public function get_session()
    {
        return isset($_SESSION['gateway']) ? $_SESSION['gateway'] : null;
    }
}
?>
