<?php
require_once("flywirePaymentGateway.php");
require_once("./config/QueryBuilder.php");

class PaymentRequest
{
    private $conn;
    private $queryBuilder;

    private $flywireObj;

    public function __construct($conn)
    {
        $this->conn = $conn;
        $this->queryBuilder = new QueryBuilder($conn);
        $this->flywireObj = new FlywirePaymentGateway();
    }

    public function paymentRequest($data, $screenName, $tableName, $merchantDetails)
    {
        
        if (isset($data['gatewayConfig'])) {
            echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>Please try again later because Transaction ID already generated for this order.</h4>
                    </div>';
        } else {
            if($data['phoneNo']){
                if($data['email']){
                  $time = time();
                  $order_id = "{$data['id']}-{$time}";
                  $refNo = "REF-" . time();
                  $gatewayJSON = <<<GATEWAYJSON
                  {
                      "X-Authentication-Key": "{$merchantDetails['xauthenticationKey']}",
                      "recipient": "{$merchantDetails['recipient']}",
                      "env": "{$merchantDetails['environment']}",
                      "currencyCode": "{$merchantDetails['country']}",
                      "callback_id" : "{$refNo}",
                      "orderUrl": "{$merchantDetails['orderUrl']}",
                      "order_id": "{$order_id}"
                  }
                  GATEWAYJSON;
                  $activeGateway = $data['paymentOption'];
                  $gateway = json_decode($gatewayJSON, true);
                  if (json_last_error() !== JSON_ERROR_NONE) {
                      echo 'JSON Error: ' . json_last_error_msg();
                      die();
                  }
                  $updateData = ['gatewayConfig' => $gatewayJSON, 'academyLocationId' => $data['academyLocationId'], 'paymentOption' => $activeGateway , 'paymentDate' => date('Y-m-d H:i:s')];
                  $where = ['id' => $data['id']];
                  $result = $this->queryBuilder->update($tableName, $updateData, $where);
                  if ($result == 1) {
                      $paymentRequestColumnData = ['screen' => $screenName, 'txnId' => $refNo, 'paymentDate' => date('Y-m-d H:i:s'), 'onlinePaymentId' => !empty($data['onlinePaymentId']) ? $data['onlinePaymentId'] : (isset($data['onlinePaymentId']) ? 0 : NULL), 'paymentId' => $data['id'], 'payment_gateway' => $activeGateway];
                      $this->queryBuilder->insert('payment_request', $paymentRequestColumnData);

                      $where = ['id' => $data['id']];
                      $paymentDetails = $this->queryBuilder->selectById($tableName, '*', $where);
                      $gatewayInfo = '';
                      if ($paymentDetails && $paymentDetails['gatewayConfig']) {
                          $gatewayInfoArr = json_decode($paymentDetails['gatewayConfig'], true);

                          if (isset($gatewayInfoArr['recipient']) && $gatewayInfoArr['recipient'] && isset($gatewayInfoArr['env']) && $gatewayInfoArr['env']  && isset($gatewayInfoArr['currencyCode']) && $gatewayInfoArr['currencyCode'] && isset($gatewayInfoArr['callback_id']) && $gatewayInfoArr['callback_id'] && isset($gatewayInfoArr['locale']) && $gatewayInfoArr['locale'] && isset($gatewayInfoArr['order_id']) && $gatewayInfoArr['order_id']) {
                              $gatewayInfo = 'EXIST';
                          }
                      }
                      if (!$paymentDetails || $paymentDetails == 0 || $gatewayInfo = '') {

                          echo '<div class="col-md-12 text-center alert alert-warning">
                                  <h4>Unfortunately, Your transaction could not be processed. Please try again.</h4>
                                </div>';
                      } else {
                          // echo domainURL;
                          $paymentRequest = $this->flywireObj->createOrder($paymentDetails, $gateway);
                          echo $paymentRequest;
                      }
                  }
                }
                else{
                    echo '<div class="col-md-12 text-center alert alert-warning">
                    <h4>Unfortunately, Your transaction could not be processed becuase email is not register. Please registered and try again.</h4>
                  </div>';
                }
            }else{
                echo '<div class="col-md-12 text-center alert alert-warning">
                <h4>Unfortunately, Your transaction could not be processed becuase phone no is not register. Please registered and try again.</h4>
              </div>';
            }
        }
    }

    public function onlinePaymentReceipt($paymentRequest , $connMain)
    {
        // $txnId = $paymentRequest['txnId'];
        require_once("academia/onlinePayment.php");
        $tableName = 'online_payment';
        $txnId = $paymentRequest['notificationBody']['data']['payment_id'];
        $updateWhere =  ['id' => $paymentRequest['paymentId']];
        $updateData = ['txnId' => $txnId, 'paymentStatus' => $paymentRequest['notificationBody']['data']['status']];
        $updateInfo = $this->queryBuilder->update($tableName, $updateData, $updateWhere);
        if($paymentRequest['notificationBody']['data']['status'] == 'guaranteed')
        {
            $onlinePaymentObj = new OnlinePayment();
            $onlinePaymentObj->setConnection($this->conn, $connMain);
            $where = ['id'=>$paymentRequest['paymentId'], 'txnId' => $txnId];
            $onlinePaymentInfo = $this->queryBuilder->selectById($tableName,'*',$where);
            if($onlinePaymentInfo)
            {
                if($onlinePaymentInfo['formSubmissionStatus'] != 1)
                {
                    $orderInfo = $this->flywireObj->fetchOrder($onlinePaymentInfo);
                    // print_r($orderInfo);die();
                    if($orderInfo['payment_id'] == $onlinePaymentInfo['txnId'] && $orderInfo['external_reference'] == $paymentRequest['txnId'])
                    {
                        $updateData = ['notificationResponse' => json_encode($paymentRequest['notificationBody']),'formSubmissionStatus' => 1, 'paymentStatus' => $orderInfo['status']];
                        $where = ['id'=>$paymentRequest['paymentId']];
                        $this->queryBuilder->update($tableName,$updateData,$where);

                        if($orderInfo['status'] == 'guaranteed')
                        {
                            $responce = $onlinePaymentObj->createReceipt($onlinePaymentInfo['onlinePaymentId'], $txnId, $orderInfo['status']);
                            if($responce == 'SUCCESS')
                            {
                                $updateData = ['receiptStatus'=> $responce];
                                $where = ['id'=>$paymentRequest['paymentId']];
                                $result = $this->queryBuilder->update($tableName,$updateData,$where);
                                echo 'payment success receipt generated - ';
                            }
                            else
                            {
                                echo json_encode($responce);
                            }
                        }
                        else
                        {
                            echo $orderInfo['status'];
                        }
                    }
                    else
                    {
                        $updateData = ['notificationResponse' => json_encode($paymentRequest['notificationBody']),'formSubmissionStatus' => 1];
                        $where = ['id'=>$paymentRequest['paymentId']];
                        $this->queryBuilder->update($tableName,$updateData,$where);
                        echo "Invalid Order";
                    }
                }
                else
                {
                    echo "Request Already hit";
                }

            }
            else
            {
                echo 'order not found in online payment table';
            }
        }
        else
        {
            echo 'Transaction Failed';
        }
    }

    public function courseEnrollementPaymentReceipt($paymentRequest, $connMain)
    {
        require_once("academia/courseEnrollement.php");
        $tableName = 'enrollment_payment';
        $txnId = $paymentRequest['notificationBody']['data']['payment_id'];
        $updateWhere =  ['id' => $paymentRequest['paymentId']];
        $updateData = ['txnId' => $txnId, 'paymentStatus' => $paymentRequest['notificationBody']['data']['status']];
        $updateInfo = $this->queryBuilder->update($tableName, $updateData, $updateWhere);
        if($paymentRequest['notificationBody']['data']['status'] == 'guaranteed')
        {
            $courseEnrollementPaymentObj = new CourseEnrollement();
            $courseEnrollementPaymentObj->setConnection($this->conn, $connMain);
            $where = ['id' => $paymentRequest['paymentId'] , 'txnId' => $txnId];
            $courseEnrollementInfo = $this->queryBuilder->selectById($tableName, '*', $where);

            if ($courseEnrollementInfo) {
                if ($courseEnrollementInfo['formSubmissionStatus'] != 1) {
                    $orderInfo = $this->flywireObj->fetchOrder($courseEnrollementInfo);
                    if ($orderInfo['payment_id'] == $courseEnrollementInfo['txnId'] && $orderInfo['external_reference'] == $paymentRequest['txnId']) {
                        $updateData = ['notificationResponse' => json_encode($paymentRequest['notificationBody']), 'formSubmissionStatus' => 1, 'paymentStatus' => $orderInfo['status']];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $this->queryBuilder->update($tableName, $updateData, $where);
                        if ($orderInfo['status'] == 'guaranteed') {
                            $responce = $courseEnrollementPaymentObj->createReceipt($courseEnrollementInfo['onlinePaymentId'], $txnId, $orderInfo['status']);
                            if ($responce == 'SUCCESS') {
                                $updateData = ['receiptStatus' => $responce];
                                $where = ['id' => $paymentRequest['paymentId']];
                                $result = $this->queryBuilder->update($tableName, $updateData, $where);
                                echo 'payment success receipt generated -course enrollement ';
                            } else {
                                echo $orderInfo['status'] . "--" . $responce;
                            }
                        } else {
                            echo $orderInfo['status'];
                        }
                    } else {
                        $updateData = ['notificationResponse' => json_encode($paymentRequest['notificationBody']), 'formSubmissionStatus' => 1];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $this->queryBuilder->update($tableName, $updateData, $where);
                        echo "Invalid Order- course enrollement";
                    }
                } else {
                    echo "Request Already hit";
                }
            } else {
                echo 'order not found in course enrollement payment table';
            }
        }
        else
        {
            echo 'Transaction Failed';
        }
    }
    public function examAssessmentReceipt ($paymentRequest , $connMain)
    {

        require_once("academia/examinationPayment.php");
        $tableName = 'assessment_payment';
        $txnId = $paymentRequest['notificationBody']['data']['payment_id'];
        $updateWhere =  ['id' => $paymentRequest['paymentId']];
        $updateData = ['txnId' => $txnId, 'paymentStatus' => $paymentRequest['notificationBody']['data']['status']];
        $updateInfo = $this->queryBuilder->update($tableName, $updateData, $updateWhere);

        if($paymentRequest['notificationBody']['data']['status'] == 'guaranteed')
        {
            $examObj = new ExaminationPayment();
            $examObj->setConnection($this->conn, $connMain);
            $where = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];
            $examInfo = $this->queryBuilder->selectById($tableName,'*',$where);
            if($examInfo)
            {
                if($examInfo['formSubmissionStatus'] != 1)
                {
                    $activeGateway = $examInfo['paymentOption'];
                    $orderInfo = $this->flywireObj->fetchOrder($examInfo);
                    if($orderInfo['payment_id'] == $examInfo['txnId'] && $orderInfo['external_reference'] == $paymentRequest['txnId'])
                    {
                        $updateData = ['notificationResponse' => json_encode($paymentRequest['notificationBody']),'formSubmissionStatus' => 1, 'paymentStatus' => $orderInfo['status']];
                        $where = ['id'=>$paymentRequest['paymentId']];
                        $this->queryBuilder->update($tableName,$updateData,$where);
                        if($orderInfo['status'] == 'guaranteed')
                        {
                            $responce = $examObj->createReceipt($examInfo['id'], $examInfo['academyLocationId'],$txnId ,$examInfo['amount'],$examInfo['currency']);

                            if(isset($responce['status']) && $responce['status'] == 'SUCCESS')
                            {
                                $updateData = ['receiptStatus'=> $responce['status']];
                                $where = ['id'=>$paymentRequest['paymentId']];
                                $result = $this->queryBuilder->update($tableName,$updateData,$where);

                                $tableName2 = 'assessment_payment_detail';
                                $updateDataDetail = ['receiptId'=>$responce['receiptId']];
                                $updateWhere = ['examAssessmentPaymentId'=>$paymentRequest['paymentId'] ];
                                $result2 = $this->queryBuilder->update($tableName2,$updateDataDetail,$updateWhere);
                                echo 'payment success receipt generated - Exam Payment ';
                            }
                            else
                            {
                                echo $orderInfo['status'] . "--" . $responce;
                            }
                        }
                        else
                        {
                            echo $orderInfo['status'];
                        }
                    }
                        else
                        {
                            $updateData = ['notificationResponse' => json_encode($paymentRequest['notificationBody']),'formSubmissionStatus' => 1];
                            $where = ['id'=>$paymentRequest['paymentId']];
                            $this->queryBuilder->update($tableName,$updateData,$where);
                            echo "Invalid Order- Exam Assesment";
                        }
                 }
                else
                {
                    echo "Request Already hit";
                }

            }

            else
            {
                echo 'order not found in Exam Payment table';
            }

        }
        else
        {
            echo 'Transaction Failed';
        }

    }

    public function RevaluationReceipt ($paymentRequest , $connMain)
    {

        require_once("academia/revaluationPayment.php");
        $tableName = 'reval_payment';
        $txnId = $paymentRequest['notificationBody']['data']['payment_id'];
        $updateWhere =  ['id' => $paymentRequest['paymentId']];
        $updateData = ['txnId' => $txnId, 'paymentStatus' => $paymentRequest['notificationBody']['data']['status']];
        $updateInfo = $this->queryBuilder->update($tableName, $updateData, $updateWhere);

        if($paymentRequest['notificationBody']['data']['status'] == 'guaranteed')
        {
            $revalObj = new RevaluationPayment();
            $revalObj->setConnection($this->conn, $connMain);
            $where = ['id'=>$paymentRequest['paymentId'], 'txnId' => $txnId];
            $revalInfo = $this->queryBuilder->selectById($tableName,'*',$where);
            if($revalInfo)
            {
                if($revalInfo['formSubmissionStatus'] != 1)
                {
                    $activeGateway = $revalInfo['paymentOption'];
                    $orderInfo = $this->flywireObj->fetchOrder($revalInfo);
                    if($orderInfo['payment_id'] == $revalInfo['txnId'] && $orderInfo['external_reference'] == $paymentRequest['txnId'])
                    {
                        $updateData = ['notificationResponse' => json_encode($paymentRequest['notificationBody']),'formSubmissionStatus' => 1, 'paymentStatus' => $orderInfo['status']];
                        $where = ['id'=>$paymentRequest['paymentId']];
                        $this->queryBuilder->update($tableName,$updateData,$where);
                        if($orderInfo['status'] == 'guaranteed')
                        {
                            $responce = $revalObj->createReceipt($revalInfo['id'],$revalInfo['amount'] ,$txnId ,$orderInfo['status']);

                            if(isset($responce) && isset($responce['status']))
                            {
                                $updateData = ['receiptStatus'=> $responce['status']];
                                $where = ['id'=>$paymentRequest['paymentId']];
                                $result = $this->queryBuilder->update($tableName,$updateData,$where);
                                echo 'payment success receipt generated - Revaluation Payment ';
                            }
                            else
                            {
                                echo json_encode($responce);
                            }
                        }
                        else
                        {
                            $orderInfo['status'];
                        }
                    }
                    else
                    {
                        $updateData = ['notificationResponse' => json_encode($paymentRequest['notificationBody']),'formSubmissionStatus' => 1];
                        $where = ['id'=>$paymentRequest['paymentId']];
                        $this->queryBuilder->update($tableName,$updateData,$where);
                        echo "Invalid Order- Revaluation Payment";
                    }

                }
                else
                {
                    echo "Request Already hit";
                }

            }

            else
            {
                echo 'order not found in Exam Payment table';
            }
        }
        else
        {
            echo 'Transaction Failed';
        }

    }

    public function declarationPaymentReceipt($paymentRequest , $connMain)
    {
        require_once("academia/declarationPayment.php");
        $tableName = 'declaration_payment';
        $txnId = $paymentRequest['notificationBody']['data']['payment_id'];
        $updateWhere =  ['id' => $paymentRequest['paymentId']];
        $updateData = ['txnId' => $txnId, 'paymentStatus' => $paymentRequest['notificationBody']['data']['status']];
        $updateInfo = $this->queryBuilder->update($tableName, $updateData, $updateWhere);
        if($paymentRequest['notificationBody']['data']['status'] == 'guaranteed')
        {
            $declarationPaymentObj = new DeclarationPayment();
            $declarationPaymentObj->setConnection($this->conn, $connMain);
            $where = ['id'=>$paymentRequest['paymentId'], 'txnId' => $txnId];
            $declarationPaymentInfo = $this->queryBuilder->selectById($tableName,'*',$where);
            if($declarationPaymentInfo)
            {
                if($declarationPaymentInfo['formSubmissionStatus'] != 1)
                {
                    $orderInfo = $this->flywireObj->fetchOrder($declarationPaymentInfo);
                    // print_r($orderInfo);die();
                    if($orderInfo['payment_id'] == $declarationPaymentInfo['txnId'] && $orderInfo['external_reference'] == $paymentRequest['txnId'])
                    {
                        $updateData = ['notificationResponse' => json_encode($paymentRequest['notificationBody']),'formSubmissionStatus' => 1, 'paymentStatus' => $orderInfo['status']];
                        $where = ['id'=>$paymentRequest['paymentId']];
                        $this->queryBuilder->update($tableName,$updateData,$where);

                        if($orderInfo['status'] == 'guaranteed')
                        {
                            $responce = $declarationPaymentObj->createReceipt($declarationPaymentInfo);
                            if(isset($responce['status']) && $responce['status'] == 'SUCCESS')
                            {
                                $updateData = ['receiptStatus'=> $responce['status'] , 'receiptId' => $responce['receiptId']];
                                $where = ['id'=>$declarationPaymentInfo['id']];
                                $result = $this->queryBuilder->update($tableName,$updateData,$where);
                                echo 'payment success receipt generated - ';
                            }
                            else
                            {
                                echo json_encode($responce);
                            }
                        }
                        else
                        {
                            echo $orderInfo['status'];
                        }
                    }
                    else
                    {
                        $updateData = ['notificationResponse' => json_encode($paymentRequest['notificationBody']),'formSubmissionStatus' => 1];
                        $where = ['id'=>$declarationPaymentInfo['id']];
                        $this->queryBuilder->update($tableName,$updateData,$where);
                        echo "Invalid Order";
                    }
                }
                else
                {
                    echo "Request Already hit";
                }

            }
            else
            {
                echo 'order not found in online payment table';
            }
        }
        else
        {
            echo 'Transaction Failed';
        }
    }

    public function donationPaymentReceipt($paymentRequest , $connMain)
    {
        // $txnId = $paymentRequest['txnId'];
        require_once("academia/donationPayment.php");
        $tableName = 'donation_payment';
        $txnId = $paymentRequest['notificationBody']['data']['payment_id'];
        $updateWhere =  ['id' => $paymentRequest['paymentId']];
        $updateData = ['txnId' => $txnId, 'paymentStatus' => $paymentRequest['notificationBody']['data']['status']];
        $updateInfo = $this->queryBuilder->update($tableName, $updateData, $updateWhere);
        if($paymentRequest['notificationBody']['data']['status'] == 'guaranteed')
        {
            $donationObj = new DonationPayment();
            $donationObj->setConnection($this->conn, $connMain);
            $where = ['id'=>$paymentRequest['paymentId'], 'txnId' => $txnId];
            $donationInfo = $this->queryBuilder->selectById($tableName,'*',$where);
            if($donationInfo)
            {
                if($donationInfo['formSubmissionStatus'] != 1)
                {
                    $orderInfo = $this->flywireObj->fetchOrder($donationInfo);
                    // print_r($orderInfo);die();
                    if($orderInfo['payment_id'] == $donationInfo['txnId'] && $orderInfo['external_reference'] == $paymentRequest['txnId'])
                    {
                        $updateData = ['notificationResponse' => json_encode($paymentRequest['notificationBody']),'formSubmissionStatus' => 1, 'paymentStatus' => $orderInfo['status']];
                        $where = ['id'=>$paymentRequest['paymentId']];
                        $this->queryBuilder->update($tableName,$updateData,$where);

                        if($orderInfo['status'] == 'guaranteed')
                        {
                            $responce = $donationObj->createReceipt($donationInfo,'TXN_SUCCESS');
                            if($responce == 'SUCCESS')
                            {
                                $updateData = ['receiptStatus'=> $responce];
                                $where = ['id'=>$paymentRequest['paymentId']];
                                $result = $this->queryBuilder->update($tableName,$updateData,$where);
                                echo 'payment success receipt generated - ';
                            }
                            else
                            {
                                echo json_encode($responce);
                            }
                        }
                        else
                        {
                            echo $orderInfo['status'];
                        }
                    }
                    else
                    {
                        $updateData = ['notificationResponse' => json_encode($paymentRequest['notificationBody']),'formSubmissionStatus' => 1];
                        $where = ['id'=>$paymentRequest['paymentId']];
                        $this->queryBuilder->update($tableName,$updateData,$where);
                        echo "Invalid Order";
                    }
                }
                else
                {
                    echo "Request Already hit";
                }

            }
            else
            {
                echo 'order not found in online payment table';
            }
        }
        else
        {
            echo 'Transaction Failed';
        }
    }

    public function advancePaymentReceipt($paymentRequest, $connMain)
    {
        require_once "academia/advancePayment.php";
        $tableName = 'advance_payment';
        $txnId = $paymentRequest['notificationBody']['data']['payment_id'];        
        $updateWhere =  ['id' => $paymentRequest['paymentId']];
        $updateData = ['txnId' => $txnId, 'paymentStatus' => $paymentRequest['notificationBody']['data']['status']];
        $updateInfo = $this->queryBuilder->update($tableName, $updateData, $updateWhere);
        if($paymentRequest['notificationBody']['data']['status'] == 'guaranteed')
        {
            $advancePaymentObj = new AdvancePayment();
        $advancePaymentObj->setConnection($this->conn, $connMain);
        $where = ['id'=>$paymentRequest['paymentId'], 'txnId' => $txnId];
            $advancePaymentInfo = $this->queryBuilder->selectById($tableName,'*',$where);
        if ($advancePaymentInfo) {
            if ($advancePaymentInfo['formSubmissionStatus'] != 1) {
                $orderInfo = $this->flywireObj->fetchOrder($advancePaymentInfo);
                if($orderInfo['payment_id'] == $advancePaymentInfo['txnId'] && $orderInfo['external_reference'] == $paymentRequest['txnId']) {
                    $updateData = ['notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1, 'paymentStatus' => $orderInfo['status']];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    if($orderInfo['status'] == 'guaranteed')
                    {
                        $response = $advancePaymentObj->createReceipt($advancePaymentInfo);

                        if ($response['status'] == 'SUCCESS') {
                            $updateData = ['receiptStatus'=> $responce['status'] , 'receiptId' => $responce['receiptId']];
                            $where = ['id' => $advancePaymentInfo['id']];
                            $result = $this->queryBuilder->update($tableName, $updateData, $where);
                            echo 'payment success receipt generated - ';
    
                        } else {
                            echo json_encode($responce);
    
                        }
                    }else
                    {
                        echo $orderInfo['status'];
                    }


                } else {
                    $updateData = ['notificationResponse' => json_encode($paymentRequest['notificationBody']),'formSubmissionStatus' => 1];
                        $where = ['id'=>$advancePaymentInfo['id']];
                        $this->queryBuilder->update($tableName,$updateData,$where);
                        echo "Invalid Order";
                }

            } else {
                echo "Request Already hit";
            }
        } else {
            echo 'order not found in adhoc payment table';
        }
        }else{
            echo 'Transaction Failed';
        }
    }


    public function sendPaymentLinkReceipt($paymentRequest, $connMain)
    {
        require_once("academia/sendPaymentLinkPayment.php");
        $tableName = 'online_payment';
        $txnId = $paymentRequest['notificationBody']['data']['payment_id'];
        $updateWhere =  ['id' => $paymentRequest['paymentId']];
        $updateData = ['txnId' => $txnId, 'paymentStatus' => $paymentRequest['notificationBody']['data']['status']];
        $updateInfo = $this->queryBuilder->update($tableName, $updateData, $updateWhere);
        if($paymentRequest['notificationBody']['data']['status'] == 'guaranteed'){
            $sendPaymentLinkObj = new SendPaymentLinkPayment();
            $sendPaymentLinkObj->setConnection($this->conn, $connMain);
            $where = ['id'=>$paymentRequest['paymentId'], 'txnId' => $txnId];
            $sendPaymentLinkInfo = $this->queryBuilder->selectById($tableName,'*',$where);
            if($sendPaymentLinkInfo)
            {
                if($sendPaymentLinkInfo['formSubmissionStatus'] != 1)
                {   
                    $orderInfo = $this->flywireObj->fetchOrder($sendPaymentLinkInfo);
                    if($orderInfo['payment_id'] == $sendPaymentLinkInfo['txnId'] && $orderInfo['external_reference'] == $paymentRequest['txnId'])
                    {
                        $updateData = ['notificationResponse' => json_encode($paymentRequest['notificationBody']),'formSubmissionStatus' => 1, 'paymentStatus' => $orderInfo['status']];
                        $where = ['id'=>$paymentRequest['paymentId']];
                        $this->queryBuilder->update($tableName,$updateData,$where);
                        if($orderInfo['status'] == 'guaranteed')
                        {
                            $responce = $sendPaymentLinkObj->createReceipt($sendPaymentLinkInfo['sendPaymentLinkId'],$sendPaymentLinkInfo['onlinePaymentId'], $txnId, $orderInfo['status']);
                            if($responce == 'SUCCESS')
                            {
                                $updateData = ['receiptStatus'=> $responce];
                                $where = ['id'=>$paymentRequest['paymentId']];
                                $result = $this->queryBuilder->update($tableName,$updateData,$where);
                                echo 'payment success receipt generated - Fee Payment ';
                            }
                            else
                            {
                                echo json_encode($responce);
                            }
                        }
                        else
                        {
                            echo $orderInfo['status'];
                        }
                    }
                    else
                    {
                        $updateData = ['notificationResponse' => json_encode($paymentRequest['notificationBody']),'formSubmissionStatus' => 1];
                        $where = ['id'=>$paymentRequest['paymentId']];
                        $this->queryBuilder->update($tableName,$updateData,$where);
                        echo "Invalid Order- Fee Payment";
                    }
                }
                else
                {
                    echo "Request Already hit";
                }
            }
            else
            {
                echo 'order not found in Online Payment table';
            }
        }
        else
        {
            echo 'Transaction Failed';
        }
        
    }


    
}
