<?php
require_once("NetworkPaymentGateway.php");

require_once("./config/QueryBuilder.php");
// use PaymentGateways\Network\NetworkGateway;
class PaymentRequest{
    private $conn;
    private $queryBuilder;
    private $networkObj ;
    public function __construct($conn) {
        $this->conn = $conn;
        $this->queryBuilder = new QueryBuilder($conn);
        $this->networkObj = new NetworkGateway();
    }

    public function paymentRequest($data ,$screenName,$tableName , $merchantDetails)
    {
        if($data['txnId'])
        {
            echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>Please try again later because Transaction ID already generated for this order.</h4>
                    </div>';
        }
        else
        {
            
            $currencyCode = $merchantDetails['currencyCode'];          
          
            $gatewayJSON = <<<GATEWAYJSON
            {
                "authApiKey": "{$merchantDetails['authApiKey']}",
                "outletId": "{$merchantDetails['outletId']}",
                "environment": "{$merchantDetails['environment']}",
                "currencyCode": "{$currencyCode}"
            }
            GATEWAYJSON;
            $activeGateway = $data['paymentOption'];
            $updateData = ['gatewayConfig'=> $gatewayJSON,'currency' => $currencyCode,'academyLocationId' => $data['academyLocationId'],'paymentOption'=>$activeGateway];
            $where = ['id'=>$data['id']];
            $result = $this->queryBuilder->update($tableName,$updateData,$where);
            if($result == 1)
            {
                $where = ['id'=>$data['id']];
                $updateInfo = $this->queryBuilder->selectById($tableName,'*',$where);
                $paymentRequest = $this->networkObj->createOrder($updateInfo);
                if(isset($paymentRequest['_links']['payment']['href']))
                 {
                    $txnId = $paymentRequest['reference'];
                    $updateData = ['txnId'=>$txnId,'paymentRequest'=>json_encode($paymentRequest)];
                    $where = ['id'=>$data['id']];
                    $result = $this->queryBuilder->update($tableName,$updateData,$where);
                    if($result == 1)
                    {
                        $paymentRequestColumnData = ['payment_gateway' => $activeGateway,'screen'=>$screenName ,'txnId'=>$txnId ,'paymentDate'=> date('Y-m-d H:i:s'), 'onlinePaymentId' => !empty($updateInfo['onlinePaymentId']) ? $updateInfo['onlinePaymentId'] : (isset($updateInfo['onlinePaymentId']) ? 0 : NULL), 'paymentId' => $updateInfo['id']];
                        $this->queryBuilder->insert('payment_request',$paymentRequestColumnData);
                        $columns = ['academyLocationId','txnId','gatewayConfig'];
                        $additionalConditions = "COALESCE(academyLocationId, '') <> '' AND COALESCE(txnId, '') <> ''";
                        $where = ['id'=>$data['id']];
                        $result = $this->queryBuilder->selectById($tableName,$columns,$where,$additionalConditions);
                        $gatewayInfo = '';
                        if($result && $result['gatewayConfig'])
                        {
                            $gatewayInfoArr = json_decode($result['gatewayConfig'], true);
                            if(isset($gatewayInfoArr['authApiKey']) && $gatewayInfoArr['authApiKey'] && isset($gatewayInfoArr['outletId']) && $gatewayInfoArr['outletId'] && isset($gatewayInfoArr['environment']) && $gatewayInfoArr['environment'])
                            {
                                $gatewayInfo = 'EXIT';
                            }
                        }
                        if (!$result || $result == 0 || $gatewayInfo == '')
                        {
                            echo '<div class="col-md-12 text-center alert alert-warning">
                                <h4>Unfortunately, Your transaction could not be processed. Please try again.</h4>
                            </div>';
                        }
                        else
                        {
                            header('Location:' . $paymentRequest['_links']['payment']['href']);
                        }
                    }
                    else
                    {
                        echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>Unfortunately, Your transaction could not be processed. Please try again.</h4>
                         </div>';
                    }

                }
                else
                {
                    echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>Unfortunately, Your transaction could not be processed. Please try again.</h4>
                             </div>';
                }
            }
            else
            {
                echo '<div class="col-md-12 text-center alert alert-warning">
                      <h4>Unfortunately, Your transaction could not be processed. Please try again.</h4>
                      </div>';
            }

        }
    }

    public function onlinePaymentReceipt($paymentRequest , $connMain)
    {
        $txnId = $paymentRequest['txnId'];
        require_once("academia/onlinePayment.php");
        $tableName = 'online_payment';
        $onlinePaymentObj = new OnlinePayment();
        $onlinePaymentObj->setConnection($this->conn, $connMain);
        $where = ['id'=>$paymentRequest['paymentId'], 'txnId' => $txnId];
        $onlinePaymentInfo = $this->queryBuilder->selectById($tableName,'*',$where);
        if($onlinePaymentInfo)
        {
            if($onlinePaymentInfo['formSubmissionStatus'] != 1)
            {
                $orderInfo = $this->networkObj->fetchOrder($onlinePaymentInfo);
                if($orderInfo['success'] && $orderInfo['reference'] == $txnId)
                {
                    $updateData = ['notificationResponse' => json_encode($paymentRequest['notificationBody']),'formSubmissionStatus' => 1, 'paymentStatus' => $orderInfo['status']];
                    $where = ['id'=>$paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName,$updateData,$where);

                    if($orderInfo['status'] == 'CAPTURED')
                    {
                        $responce = $onlinePaymentObj->createReceipt($onlinePaymentInfo['onlinePaymentId'], $txnId, $orderInfo['status']);
                        if($responce == 'SUCCESS')
                        {
                            $updateData = ['receiptStatus'=> $responce];
                            $where = ['id'=>$paymentRequest['paymentId']];
                            $result = $this->queryBuilder->update($tableName,$updateData,$where);
                            echo 'payment success receipt generated - ';
                        }
                        else
                        {
                            echo json_encode($responce);
                        }
                    }
                    else
                    {
                        echo $orderInfo['status'];
                    }
                }
                else
                {
                    $updateData = ['notificationResponse' => json_encode($paymentRequest['notificationBody']),'formSubmissionStatus' => 1];
                    $where = ['id'=>$paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName,$updateData,$where);
                    echo "Invalid Order";
                }
            }
            else
            {
                echo "Request Already hit";
            }

        }
        else
        {
            echo 'order not found in online payment table';
        }
    }

    public function courseEnrollementPaymentReceipt($paymentRequest , $connMain)
    {
        $txnId = $paymentRequest['txnId'];
        require_once("academia/courseEnrollement.php");
        $tableName = 'enrollment_payment';
        $courseEnrollementPaymentObj = new CourseEnrollement();
        $courseEnrollementPaymentObj->setConnection($this->conn, $connMain);
        $where = ['id'=>$paymentRequest['paymentId'], 'txnId' => $txnId];
        $courseEnrollementInfo = $this->queryBuilder->selectById($tableName,'*',$where);
        if($courseEnrollementInfo)
        {
            if($courseEnrollementInfo['formSubmissionStatus'] != 1)
            {
                $orderInfo = $this->networkObj->fetchOrder($courseEnrollementInfo);
                if($orderInfo['success'] && $orderInfo['reference'] == $txnId)
                {
                    $updateData = ['notificationResponse' => json_encode($paymentRequest['notificationBody']),'formSubmissionStatus' => 1, 'paymentStatus' => $orderInfo['status']];
                    $where = ['id'=>$paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName,$updateData,$where);
                    if($orderInfo['status'] == 'CAPTURED')
                    {
                        $responce = $courseEnrollementPaymentObj->createReceipt($courseEnrollementInfo['onlinePaymentId'], $txnId, $orderInfo['status']);
                        if($responce == 'SUCCESS')
                        {
                            $updateData = ['receiptStatus'=> $responce];
                            $where = ['id'=>$paymentRequest['paymentId']];
                            $result = $this->queryBuilder->update($tableName,$updateData,$where);
                            echo 'payment success receipt generated -course enrollement ';
                        }
                        else
                        {
                            echo $orderInfo['status']."--".json_encode($responce);
                        }
                    }
                    else
                    {
                        echo $orderInfo['status'];
                    }
                }
                else
                {
                    $updateData = ['notificationResponse' => json_encode($paymentRequest['notificationBody']),'formSubmissionStatus' => 1];
                    $where = ['id'=>$paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName,$updateData,$where);
                    echo "Invalid Order- course enrollement";
                }
            }
            else
            {
                echo "Request Already hit";
            }
        }
        else
        {
            echo 'order not found in course enrollement payment table';
        }
    }

    public function examAssessmentReceipt ($paymentRequest , $connMain)
    {
        $txnId = $paymentRequest['txnId'];
        require_once("academia/examinationPayment.php");
        $tableName = 'assessment_payment';
        $examObj = new ExaminationPayment();
        $examObj->setConnection($this->conn, $connMain);
        $where = ['id'=>$paymentRequest['paymentId'], 'txnId' => $txnId];
        $examInfo = $this->queryBuilder->selectById($tableName,'*',$where);
        if($examInfo)
        {
            if($examInfo['formSubmissionStatus'] != 1)
            {
                $orderInfo = $this->networkObj->fetchOrder($examInfo);
                if($orderInfo['success'] && $orderInfo['reference'] == $txnId)
                {
                    $updateData = ['notificationResponse' => json_encode($paymentRequest['notificationBody']),'formSubmissionStatus' => 1, 'paymentStatus' => $orderInfo['status']];
                    $where = ['id'=>$paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName,$updateData,$where);
                    if($orderInfo['status'] == 'CAPTURED')
                    {
                        $responce = $examObj->createReceipt($examInfo['id'], $examInfo['academyLocationId'],$txnId ,$examInfo['amount'],$examInfo['currency']);
                        if(isset($responce['status']) && $responce['status'] == 'SUCCESS')
                        {
                            $updateData = ['receiptStatus'=> $responce['status']];
                            $where = ['id'=>$paymentRequest['paymentId']];
                            $result = $this->queryBuilder->update($tableName,$updateData,$where);

                            $tableName2 = 'assessment_payment_detail';
                            $updateDataDetail = ['receiptId'=>$responce['receiptId']];
                            $updateWhere = ['examAssessmentPaymentId'=>$paymentRequest['paymentId'] ];
                            $result2 = $this->queryBuilder->update($tableName2,$updateDataDetail,$updateWhere);
                            echo 'payment success receipt generated - Exam Payment ';
                        }
                        else
                        {
                            echo $orderInfo['status']."--".$responce;
                        }
                    }
                    else
                    {
                        echo $orderInfo['status'];
                    }
                }
                else
                {
                    $updateData = ['notificationResponse' => json_encode($paymentRequest['notificationBody']),'formSubmissionStatus' => 1];
                    $where = ['id'=>$paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName,$updateData,$where);
                    echo "Invalid Order- Exam Assesment";
                }
            }
            else
            {
                echo "Request Already hit";
            }

        }

        else
        {
            echo 'order not found in Exam Payment table';
        }

    }

    public function declarationPaymentReceipt($paymentRequest , $connMain)
    {
        $txnId = $paymentRequest['txnId'];
        require_once("academia/declarationPayment.php");
        $tableName = 'declaration_payment';
        $declarationPaymentObj = new DeclarationPayment();
        $declarationPaymentObj->setConnection($this->conn, $connMain);
        $where = ['id'=>$paymentRequest['paymentId'], 'txnId' => $txnId];
        $declarationPaymentInfo = $this->queryBuilder->selectById($tableName,'*',$where);
        if($declarationPaymentInfo)
        {
            if($declarationPaymentInfo['formSubmissionStatus'] != 1)
            {
                $orderInfo = $this->networkObj->fetchOrder($declarationPaymentInfo);
                if($orderInfo['success'] && $orderInfo['reference'] == $txnId)
                {
                    $updateData = ['notificationResponse' => json_encode($paymentRequest['notificationBody']),'formSubmissionStatus' => 1, 'paymentStatus' => $orderInfo['status']];
                    $where = ['id'=>$paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName,$updateData,$where);

                    if($orderInfo['status'] == 'CAPTURED')
                    {
                        $declarationPaymentInfo['paymentStatus'] = $orderInfo['status'];
                        $responce = $declarationPaymentObj->createReceipt($declarationPaymentInfo);
                        if(isset($responce['status']) && $responce['status'] == 'SUCCESS')
                        {
                            $updateData = ['receiptStatus'=> $responce['status'] , 'receiptId' => $responce['receiptId']];
                            $where = ['id'=>$paymentRequest['paymentId']];
                            $result = $this->queryBuilder->update($tableName,$updateData,$where);
                            echo 'payment success receipt generated - ';
                        }
                        else
                        {
                            echo json_encode($responce);
                        }
                    }
                    else
                    {
                        echo $orderInfo['status'];
                    }
                }
                else
                {
                    $updateData = ['notificationResponse' => json_encode($paymentRequest['notificationBody']),'formSubmissionStatus' => 1];
                    $where = ['id'=>$paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName,$updateData,$where);
                    echo "Invalid Order";
                }
            }
            else
            {
                echo "Request Already hit";
            }

        }
        else
        {
            echo 'order not found in declaration payment table';
        }

    }

    public function RevaluationReceipt($paymentRequest , $connMain)
    {
        $txnId = $paymentRequest['txnId'];
        require_once("academia/revaluationPayment.php");
        $tableName = 'reval_payment';
        $revalObj = new RevaluationPayment();
        $revalObj->setConnection($this->conn, $connMain);
        $where = ['id'=>$paymentRequest['paymentId'], 'txnId' => $txnId];
        $revalInfo = $this->queryBuilder->selectById($tableName,'*',$where);
        if($revalInfo)
        {
            if($revalInfo['formSubmissionStatus'] != 1)
            {
                $orderInfo = $this->networkObj->fetchOrder($revalInfo);
                if($orderInfo['success'] && $orderInfo['reference'] == $txnId)
                {
                    $updateData = ['notificationResponse' => json_encode($paymentRequest['notificationBody']),'formSubmissionStatus' => 1, 'paymentStatus' => $orderInfo['status']];
                    $where = ['id'=>$paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName,$updateData,$where);
                    if($orderInfo['status'] == 'CAPTURED')
                    {
                        $responce = $revalObj->createReceipt($revalInfo['id'],$revalInfo['amount'] ,$txnId ,$orderInfo['status']);

                        if(isset($responce) && isset($responce['status']))
                        {
                            $updateData = ['receiptStatus'=> $responce['status']];
                            $where = ['id'=>$paymentRequest['paymentId']];
                            $result = $this->queryBuilder->update($tableName,$updateData,$where);
                            echo 'payment success receipt generated - Revaluation Payment ';
                        }
                        else
                        {
                            echo json_encode($responce);
                        }
                    }
                    else
                    {
                        echo $orderInfo['status'];
                    }
                }
                else
                {
                    $updateData = ['notificationResponse' => json_encode($paymentRequest['notificationBody']),'formSubmissionStatus' => 1];
                    $where = ['id'=>$paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName,$updateData,$where);
                    echo "Invalid Order- Revaluation Payment";
                }
            }
            else
            {
                echo "Request Already hit";
            }

        }

        else
        {
            echo 'order not found in Exam Payment table';
        }

    }

    public function advancePaymentReceipt($paymentRequest, $connMain)
    {
        $txnId = $paymentRequest['txnId'];
        require_once "academia/advancePayment.php";
        $tableName = 'advance_payment';
        $advancePaymentObj = new AdvancePayment();
        $advancePaymentObj->setConnection($this->conn, $connMain);
        $where = ['id'=>$paymentRequest['paymentId'], 'txnId' => $txnId];
        $advancePaymentInfo = $this->queryBuilder->selectById($tableName,'*',$where);
        if($advancePaymentInfo)
        {
            if($advancePaymentInfo['formSubmissionStatus'] != 1)
            {
                $orderInfo = $this->networkObj->fetchOrder($advancePaymentInfo);
                if($orderInfo['success'] && $orderInfo['reference'] == $txnId)
                {
                    $updateData = ['notificationResponse' => json_encode($paymentRequest['notificationBody']),'formSubmissionStatus' => 1, 'paymentStatus' => $orderInfo['status']];
                    $where = ['id'=>$paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName,$updateData,$where);
                    if($orderInfo['status'] == 'CAPTURED')
                    {
                        $responce = $advancePaymentObj->createReceipt($advancePaymentInfo);

                        if(isset($responce) && isset($responce['status']))
                        {
                            $updateData = ['receiptStatus'=> $responce['status']];
                            $where = ['id'=>$paymentRequest['paymentId']];
                            $result = $this->queryBuilder->update($tableName,$updateData,$where);
                            echo 'payment success receipt generated - Advance Payment ';
                        }
                        else
                        {
                            echo json_encode($responce);
                        }
                    }
                    else
                    {
                        echo $orderInfo['status'];
                    }
                }
                else
                {
                    $updateData = ['notificationResponse' => json_encode($paymentRequest['notificationBody']),'formSubmissionStatus' => 1];
                    $where = ['id'=>$paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName,$updateData,$where);
                    echo "Invalid Order- Advance Payment";
                }
            }
            else
            {
                echo "Request Already hit";
            }
        }
        else
        {
            echo 'order not found in Advance Payment table';
        }
    }

    public function sendPaymentLinkReceipt($paymentRequest, $connMain)
    {
        $txnId = $paymentRequest['txnId'];
        require_once("academia/sendPaymentLinkPayment.php");
        $tableName = 'online_payment';
        $sendPaymentLinkObj = new SendPaymentLinkPayment();
        $sendPaymentLinkObj->setConnection($this->conn, $connMain);
        $where = ['id'=>$paymentRequest['paymentId'], 'txnId' => $txnId];
        $sendPaymentLinkInfo = $this->queryBuilder->selectById($tableName,'*',$where);
        if($sendPaymentLinkInfo)
        {
            if($sendPaymentLinkInfo['formSubmissionStatus'] != 1)
            {   
                $orderInfo = $this->networkObj->fetchOrder($sendPaymentLinkInfo);
                if($orderInfo['success'] && $orderInfo['reference'] == $txnId)
                {
                    $updateData = ['notificationResponse' => json_encode($paymentRequest['notificationBody']),'formSubmissionStatus' => 1, 'paymentStatus' => $orderInfo['status']];
                    $where = ['id'=>$paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName,$updateData,$where);
                    if($orderInfo['status'] == 'CAPTURED')
                    {
                        $responce = $sendPaymentLinkObj->createReceipt($sendPaymentLinkInfo['sendPaymentLinkId'],$sendPaymentLinkInfo['onlinePaymentId'], $txnId, $orderInfo['status']);
                        if($responce == 'SUCCESS')
                        {
                            $updateData = ['receiptStatus'=> $responce['status']];
                            $where = ['id'=>$paymentRequest['paymentId']];
                            $result = $this->queryBuilder->update($tableName,$updateData,$where);
                            echo 'payment success receipt generated - Fee Payment ';
                        }
                        else
                        {
                            echo json_encode($responce);
                        }
                    }
                    else
                    {
                        echo $orderInfo['status'];
                    }
                }
                else
                {
                    $updateData = ['notificationResponse' => json_encode($paymentRequest['notificationBody']),'formSubmissionStatus' => 1];
                    $where = ['id'=>$paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName,$updateData,$where);
                    echo "Invalid Order- Fee Payment";
                }
            }
            else
            {
                echo "Request Already hit";
            }
        }
        else
        {
            echo 'order not found in Online Payment table';
        }
    }

    public function donationPaymentReceipt($paymentRequest , $connMain)
    {
        $txnId =  $paymentRequest['txnId'];
        require_once("academia/donationPayment.php");
        $tableName = 'donation_payment';
        $donationObj = new DonationPayment();
        $donationObj->setConnection($this->conn, $connMain);
        $where = ['id'=>$paymentRequest['paymentId'], 'txnId' => $txnId];
        $donationInfo = $this->queryBuilder->selectById($tableName,'*',$where);
        if($donationInfo){
            if($donationInfo['formSubmissionStatus'] != 1)
            {
                $orderInfo = $this->networkObj->fetchOrder($donationInfo);
                if($orderInfo['success'] && $orderInfo['reference'] == $txnId)
                {
                    $updateData = ['notificationResponse' => json_encode($paymentRequest['notificationBody']),'formSubmissionStatus' => 1, 'paymentStatus' => $orderInfo['status']];
                    $where = ['id'=>$paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName,$updateData,$where);
                    $response = $donationObj->createReceipt($donationInfo, 'TXN_SUCCESS');
                    if ($response == 'SUCCESS') {
                        $updateData = ['receiptStatus' => $response];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $result = $this->queryBuilder->update($tableName, $updateData, $where);
                        echo '<div class="col-md-12 text-center alert alert-success">
                                    <h4>Fee Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is '.$txnId.'.<br /> Please close the window.</h4>
                            </div>';

                    } else {
                        echo '<div class="col-md-12 text-center alert alert-success">
                                    <h4>Fee Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is '.$txnId.'.<br /> However, the receipt could not be generated. Please contact the administrator for assistance. You may now close this window..</h4>
                                </div>';
                    }
                }
                else
                {
                    $updateData = ['notificationResponse' => json_encode($paymentRequest['notificationBody']),'formSubmissionStatus' => 1 , 'paymentStatus'=>$orderInfo['status']];
                    $where = ['id'=>$paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName,$updateData,$where);
                    echo "Invalid Order- Fee Payment";
                }
            }
            else
            {
                echo "Request Already hit";
            }
        }
        else
        {
            echo 'order not found in Online Payment table';
        }
    }
}
