<?php
require_once("adityaBirlaPaymentGateway.php");
require_once("./config/QueryBuilder.php");
class PaymentRequest
{
    private $conn;
    private $queryBuilder;
    private $adityaBirlaObj;
    private $translationMsg;
    public function __construct($conn)
    {
        $this->conn = $conn;
        $this->queryBuilder = new QueryBuilder($conn);
        $this->adityaBirlaObj = new AdityaBirlaGateway();
        $this->translationMsg = json_decode(TRANSLATION_MSG, true);
    }

    public function paymentRequest($data, $screenName, $tableName, $merchantDetails)
    {
        if ($data['txnId']) {
            echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>' . $this->translationMsg['TXN_ID_ALREADY_GENERATED'] . '</h4>
                    </div>';
        } else {            
            $currencyCode = $merchantDetails['currencyCode'];
            $activeGateway = $data['paymentOption'];
            $gatewayJSON = <<<GATEWAYJSON
            {
                "merchantId": "{$merchantDetails['merchantID']}",
                "iv": "{$merchantDetails['iv']}",
                "key": "{$merchantDetails['adityaBirlaKey']}",
                "environment": "{$merchantDetails['environment']}",
                "currencyCode": "{$merchantDetails['currencyCode']}",
                "accountIfsc": "{$merchantDetails['accountIfsc']}",
                "accountNo": "{$merchantDetails['accountNo']}"
            }
            GATEWAYJSON;
            $orderIDCreated = time().rand(100,999);
            $updateData = ['gatewayConfig' => $gatewayJSON, 'currency' => $currencyCode, 'academyLocationId' => $data['academyLocationId'], 'paymentOption' => $activeGateway, 'txnId' => 'ABC'.$orderIDCreated];
            $where = ['id' => $data['id']];
            $result = $this->queryBuilder->update($tableName, $updateData, $where);
            if ($result == 1) {
                $where = ['id' => $data['id']];
                $updateInfo = $this->queryBuilder->selectById($tableName, '*', $where);
                $paymentRequest = $this->adityaBirlaObj->createOrder($updateInfo);                
                if (isset($paymentRequest['order_data']['links']['payment_link_web']) && $updateInfo['txnId'] == $paymentRequest['order_data']['pl_order_id']) {
                    $txnId = $updateInfo['txnId'];
                    $updateData = ['paymentRequest' => json_encode($paymentRequest)];
                    $where = ['id' => $data['id']];
                    $result = $this->queryBuilder->update($tableName, $updateData, $where);
                    if ($result == 1) {
                        $paymentRequestColumnData = ['payment_gateway' => $activeGateway, 'screen' => $screenName, 'txnId' => $txnId, 'paymentDate' => date('Y-m-d H:i:s'), 'onlinePaymentId' => !empty($updateInfo['onlinePaymentId']) ? $updateInfo['onlinePaymentId'] : (isset($updateInfo['onlinePaymentId']) ? 0 : NULL), 'paymentId' => $updateInfo['id']];
                        $this->queryBuilder->insert('payment_request', $paymentRequestColumnData);
                        $columns = ['academyLocationId', 'txnId', 'gatewayConfig'];
                        $additionalConditions = "COALESCE(academyLocationId, '') <> '' AND COALESCE(txnId, '') <> ''";
                        $where = ['id' => $data['id']];
                        $result = $this->queryBuilder->selectById($tableName, $columns, $where, $additionalConditions);
                        $gatewayInfo = '';
                        if ($result && $result['gatewayConfig']) {
                            $gatewayInfoArr = json_decode($result['gatewayConfig'], true);
                            if (isset($gatewayInfoArr['merchantId']) && $gatewayInfoArr['merchantId'] && isset($gatewayInfoArr['iv']) && $gatewayInfoArr['iv'] && isset($gatewayInfoArr['key']) && $gatewayInfoArr['key'] && isset($gatewayInfoArr['environment']) && $gatewayInfoArr['environment'] && isset($gatewayInfoArr['accountIfsc']) && $gatewayInfoArr['accountIfsc'] && isset($gatewayInfoArr['accountNo']) && $gatewayInfoArr['accountNo']) {
                                $gatewayInfo = 'EXIT';
                            }
                        }
                        if (!$result || $result == 0 || $gatewayInfo == '') {
                            echo '<div class="col-md-12 text-center alert alert-warning">
                                <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
                            </div>';
                        } else {
                            header('Location:' . $paymentRequest['order_data']['links']['payment_link_web']);
                        }
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
                         </div>';
                    }
                } else {
                    $errorReson = isset($paymentRequest['error_message']) ? $paymentRequest['error_message'] : '';
                    if($errorReson){
                        $error = 'Unfortunately, Your transaction could not be processed. because '.$errorReson.' Please try again';
                    }else{
                        $error =  $this->translationMsg['TRANSACTION_ERROR']  ;
                    }
                    echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>'.$error.'</h4>
                             </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                      <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
                      </div>';
            }
        }
    }

    public function onlinePaymentReceipt($paymentRequest, $connMain)
    {
        $txnId = $paymentRequest['txnId'];
        require_once("academia/onlinePayment.php");
        $tableName = 'online_payment';
        $onlinePaymentObj = new OnlinePayment();
        $onlinePaymentObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];
        $onlinePaymentInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        if ($onlinePaymentInfo) {
            if ($onlinePaymentInfo['formSubmissionStatus'] != 1) {
                $orderInfo = $this->adityaBirlaObj->fetchOrder($onlinePaymentInfo);
                if ($orderInfo['order_data']['status'] && $orderInfo['order_data']['pl_order_id'] == $txnId) {
                    $updateData = ['notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1, 'paymentStatus' => $orderInfo['order_data']['status']];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);

                    if ($orderInfo['order_data']['status'] == 'SUCCESS') {
                        $response = $onlinePaymentObj->createReceipt($onlinePaymentInfo['onlinePaymentId'], $txnId, $orderInfo['order_data']['status']);
                        if ($response == 'SUCCESS') {
                            $updateData = ['receiptStatus' => $response];
                            $where = ['id' => $paymentRequest['paymentId']];
                            $result = $this->queryBuilder->update($tableName, $updateData, $where);
                            echo '<div class="col-md-12 text-center alert alert-success">
                                        <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']) . '</h4>
                                </div>';

                        } else {
                            echo '<div class="col-md-12 text-center alert alert-success">
                                       <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']) . '</h4>
                                    </div>';
                        }
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-warning">
                                <h4>' . str_replace("[ORDER_STATUS]", $orderInfo['order_data']['status'], $this->translationMsg['TRANSACTION_NOT_SUCCESS']) . '</h4>
                            </div>';
                    }
                } else {
                    $updateData = ['notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>' . $this->translationMsg['TRANSACTION_DATA_NOT_FOUND'] . '</h4>
                        </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                         <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
                    </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
               <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
          </div>';
        }
    }

    public function courseEnrollementPaymentReceipt($paymentRequest,$connMain)
    {
        $txnId = $paymentRequest['txnId'];
        require_once("academia/courseEnrollement.php");
        $tableName = 'enrollment_payment';
        $courseEnrollementPaymentObj = new CourseEnrollement();
        $courseEnrollementPaymentObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];
        $courseEnrollementInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        if ($courseEnrollementInfo) {
            if ($courseEnrollementInfo['formSubmissionStatus'] != 1) {
                $orderInfo = $this->adityaBirlaObj->fetchOrder($courseEnrollementInfo);
                if ($orderInfo['order_data']['status'] && $orderInfo['order_data']['pl_order_id'] == $txnId) {
                    $updateData = ['notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1, 'paymentStatus' => $orderInfo['order_data']['status']];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    if ($orderInfo['order_data']['status'] == 'SUCCESS') {
                        $response = $courseEnrollementPaymentObj->createReceipt($courseEnrollementInfo['onlinePaymentId'], $txnId, $orderInfo['order_data']['status']);
                        if ($response == 'SUCCESS') {
                            $updateData = ['receiptStatus' => $response];
                            $where = ['id' => $paymentRequest['paymentId']];
                            $result = $this->queryBuilder->update($tableName, $updateData, $where);
                            echo '<div class="col-md-12 text-center alert alert-success">
                                        <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']) . '</h4>
                                </div>';

                        } else {
                            echo '<div class="col-md-12 text-center alert alert-success">
                                       <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']) . '</h4>
                                    </div>';
                        }
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-warning">
                                <h4>' . str_replace("[ORDER_STATUS]", $orderInfo['order_data']['status'], $this->translationMsg['TRANSACTION_NOT_SUCCESS']) . '</h4>
                            </div>';
                    }
                } else {
                    $updateData = ['notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>' . $this->translationMsg['TRANSACTION_DATA_NOT_FOUND'] . '</h4>
                        </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>Unfortunately, Your transaction could not be processed. Please try again.</h4>
                    </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
            <h4>Unfortunately, Your transaction could not be processed becuase your order details not found. Please contact to administrator.</h4>
        </div>';
        }
    }

    public function examAssessmentReceipt($paymentRequest, $connMain)
    {
        $txnId = $paymentRequest['txnId'];
        require_once("academia/examinationPayment.php");
        $tableName = 'assessment_payment';
        $examObj = new ExaminationPayment();
        $examObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];
        $examInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        if ($examInfo) {
            if ($examInfo['formSubmissionStatus'] != 1) {
                $activeGateway = $examInfo['paymentOption'];
                $orderInfo = $this->adityaBirlaObj->fetchOrder($examInfo);
                if ($orderInfo['order_data']['status'] && $orderInfo['order_data']['pl_order_id'] == $txnId) {
                    $updateData = ['notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1, 'paymentStatus' => $orderInfo['order_data']['status']];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    if ($orderInfo['order_data']['status'] == 'SUCCESS') {
                        $response = $examObj->createReceipt($examInfo['id'], $examInfo['academyLocationId'], $txnId, $examInfo['amount'],$examInfo['currency']);

                        if (isset($response['status']) && $response['status'] == 'SUCCESS') {
                            $updateData = ['receiptStatus' => $response['status']];
                            $where = ['id' => $paymentRequest['paymentId']];
                            $result = $this->queryBuilder->update($tableName, $updateData, $where);

                            $tableName2 = 'assessment_payment_detail';
                            $updateDataDetail = ['receiptId' => $response['receiptId']];
                            $updateWhere = ['examAssessmentPaymentId' => $paymentRequest['paymentId']];
                            $result2 = $this->queryBuilder->update($tableName2, $updateDataDetail, $updateWhere);
                           echo '<div class="col-md-12 text-center alert alert-success">
                                        <h4>Exam Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is '.$txnId.'.<br /> Please close the window.</h4>
                                </div>';
                        } else {
                            echo '<div class="col-md-12 text-center alert alert-success">
                            <h4>Exam Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is '.$txnId.'.<br /> However, the receipt could not be generated. Please contact the administrator for assistance. You may now close this window..</h4>
                         </div>';
                        }
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>' . str_replace("[ORDER_STATUS]", $orderInfo['order_data']['status'], $this->translationMsg['TRANSACTION_NOT_SUCCESS']) . '</h4>
                    </div>';
                    }
                } else {
                    $updateData = ['notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    echo '<div class="col-md-12 text-center alert alert-warning">
                    <h4>' . $this->translationMsg['TRANSACTION_DATA_NOT_FOUND'] . '</h4>
                </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                <h4>Unfortunately, Your transaction could not be processed. Please try again.</h4>
            </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
            <h4>Unfortunately, Your transaction could not be processed becuase your order details not found. Please contact to administrator.</h4>
        </div>';
        }
    }

    public function declarationPaymentReceipt($paymentRequest, $connMain)
    {
        $txnId = $paymentRequest['txnId'];
        require_once("academia/declarationPayment.php");
        $tableName = 'declaration_payment';
        $declarationPaymentObj = new DeclarationPayment();
        $declarationPaymentObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];
        $declarationPaymentInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        if ($declarationPaymentInfo) {
            if ($declarationPaymentInfo['formSubmissionStatus'] != 1) {
                $orderInfo = $this->adityaBirlaObj->fetchOrder($declarationPaymentInfo);
                if ($orderInfo['order_data']['status'] && $orderInfo['order_data']['pl_order_id'] == $txnId) {
                    $updateData = ['notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1, 'paymentStatus' => $orderInfo['order_data']['status']];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);

                    if ($orderInfo['order_data']['status'] == 'SUCCESS') {
                        $declarationPaymentInfo['paymentStatus'] = $orderInfo['order_data']['status'];
                        $response = $declarationPaymentObj->createReceipt($declarationPaymentInfo);
                        if (isset($response['status']) && $response['status'] == 'SUCCESS') {
                            $updateData = ['receiptStatus' => $response['status'], 'receiptId' => $response['receiptId']];
                            $where = ['id' => $paymentRequest['paymentId']];
                            $result = $this->queryBuilder->update($tableName, $updateData, $where);
                            echo '<div class="col-md-12 text-center alert alert-success">
                                        <h4>Declaration Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is '.$txnId.'.<br /> Please close the window.</h4>
                                </div>';
                        } else {
                            echo '<div class="col-md-12 text-center alert alert-success">
                            <h4>Declaration Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is '.$txnId.'.<br /> However, the receipt could not be generated. Please contact the administrator for assistance. You may now close this window..</h4>
                         </div>';
                        }
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-warning">
                                <h4>' . str_replace("[ORDER_STATUS]", $orderInfo['order_data']['status'], $this->translationMsg['TRANSACTION_NOT_SUCCESS']) . '</h4>
                            </div>';
                    }
                } else {
                    $updateData = ['notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    echo '<div class="col-md-12 text-center alert alert-warning">
                    <h4>' . $this->translationMsg['TRANSACTION_DATA_NOT_FOUND'] . '</h4>
                </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                <h4>Unfortunately, Your transaction could not be processed. Please try again.</h4>
            </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
              <h4>Unfortunately, Your transaction could not be processed becuase your order details not found. Please contact to administrator.</h4>
          </div>';
        }
    }

    public function RevaluationReceipt($paymentRequest, $connMain)
    {
        $txnId = $paymentRequest['txnId'];
        require_once("academia/revaluationPayment.php");
        $tableName = 'reval_payment';
        $revalObj = new RevaluationPayment();
        $revalObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];

        $revalInfo = $this->queryBuilder->selectById($tableName, '*', $where);

        if ($revalInfo) {
            if ($revalInfo['formSubmissionStatus'] != 1) {
                $activeGateway = $revalInfo['paymentOption'];
                $orderInfo = $this->adityaBirlaObj->fetchOrder($revalInfo);
                if ($orderInfo['order_data']['status'] && $orderInfo['order_data']['pl_order_id'] == $txnId) {
                    $updateData = ['notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1, 'paymentStatus' => $orderInfo['order_data']['status']];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    if ($orderInfo['order_data']['status'] == 'SUCCESS') {
                        $response = $revalObj->createReceipt($revalInfo['id'], $revalInfo['amount'], $txnId, $orderInfo['order_data']['status']);

                        if (isset($response) && isset($response['status'])) {
                            $updateData = ['receiptStatus' => $response['status']];
                            $where = ['id' => $paymentRequest['paymentId']];
                            $result = $this->queryBuilder->update($tableName, $updateData, $where);
                            echo '<div class="col-md-12 text-center alert alert-success">
                                        <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']) . '</h4>
                                </div>';
                        } else {
                            echo '<div class="col-md-12 text-center alert alert-success">
                            <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']) . '</h4>
                         </div>';
                        }
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>' . str_replace("[ORDER_STATUS]", $orderInfo['order_data']['status'], $this->translationMsg['TRANSACTION_NOT_SUCCESS']) . '</h4>
                    </div>';
                    }
                } else {
                    $updateData = ['notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>' . $this->translationMsg['TRANSACTION_DATA_NOT_FOUND'] . '</h4>
                        </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>Unfortunately, Your transaction could not be processed. Please try again.</h4>
                    </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
            <h4>Unfortunately, Your transaction could not be processed becuase your order details not found. Please contact to administrator.</h4>
        </div>';
        }
    }
    public function sendPaymentLinkReceipt($paymentRequest, $connMain)
    {
        $txnId = $paymentRequest['txnId'];
        require_once("academia/sendPaymentLinkPayment.php");
        $tableName = 'online_payment';
        $sendPaymentLinkObj = new SendPaymentLinkPayment();
        $sendPaymentLinkObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];
        $sendPaymentLinkInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        if ($sendPaymentLinkInfo) {
            if ($sendPaymentLinkInfo['formSubmissionStatus'] != 1) {
                $orderInfo = $this->adityaBirlaObj->fetchOrder($sendPaymentLinkInfo);
                if ($orderInfo['order_data']['status'] && $orderInfo['order_data']['pl_order_id'] == $txnId) {
                    $updateData = ['notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1, 'paymentStatus' => $orderInfo['order_data']['status']];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);

                    if ($orderInfo['order_data']['status'] == 'SUCCESS') {
                        $response = $sendPaymentLinkObj->createReceipt($sendPaymentLinkInfo['sendPaymentLinkId'],$sendPaymentLinkInfo['onlinePaymentId'] , $txnId, $orderInfo['order_data']['status']);

                        if ($response == 'SUCCESS') {
                            $updateData = ['receiptStatus' => $response];
                            $where = ['id' => $paymentRequest['paymentId']];
                            $result = $this->queryBuilder->update($tableName, $updateData, $where);
                            $paymentData = $this->queryBuilder->selectById($tableName,'*',$where);
                            $expirePayment = $sendPaymentLinkObj->setPaymentLinkExpire($paymentData['sendPaymentLinkId'] , $paymentData['onlinePaymentId']);
                            echo '<div class="col-md-12 text-center alert alert-success">
                                        <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']) . '</h4>
                                </div>';

                        } else {
                            echo '<div class="col-md-12 text-center alert alert-success">
                                       <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']) . '</h4>
                                    </div>';
                        }
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-warning">
                                <h4>' . str_replace("[ORDER_STATUS]", $orderInfo['order_data']['status'], $this->translationMsg['TRANSACTION_NOT_SUCCESS']) . '</h4>
                            </div>';
                    }
                } else {
                    $updateData = ['notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>' . $this->translationMsg['TRANSACTION_DATA_NOT_FOUND'] . '</h4>
                        </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                         <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '.</h4>
                    </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
               <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '.</h4>
          </div>';
        }
    }

    public function donationPaymentReceipt($paymentRequest, $connMain)
    {
        $txnId = $paymentRequest['txnId'];
        require_once("academia/donationPayment.php");
        $tableName = 'donation_payment';

        $donationObj = new DonationPayment();
        $donationObj->setConnection($this->conn, $connMain);

        $where = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];
        $donationInfo = $this->queryBuilder->selectById($tableName, '*', $where);

        if ($donationInfo) {
            if ($donationInfo['formSubmissionStatus'] != 1) {
                $activeGateway = $donationInfo['paymentOption'];
                $orderInfo = $this->adityaBirlaObj->fetchOrder($donationInfo);

                if (
                    isset($orderInfo['order_data']['status']) &&
                    $orderInfo['order_data']['pl_order_id'] == $txnId
                ) {
                    $updateData = [
                        'notificationResponse' => json_encode($orderInfo),
                        'formSubmissionStatus' => 1,
                        'paymentStatus' => $orderInfo['order_data']['status']
                    ];
                    $this->queryBuilder->update($tableName, $updateData, $where);

                    if ($orderInfo['order_data']['status'] == 'SUCCESS') {
                        $response = $donationObj->createReceipt($donationInfo, 'TXN_SUCCESS');

                        if ($response == 'SUCCESS') {
                            $updateData = ['receiptStatus' => $response];
                            $this->queryBuilder->update($tableName, $updateData, $where);

                            echo '<div class="col-md-12 text-center alert alert-success">
                                    <h4>Donation is successful !!!<br /><br />Thank you for your support. Your Transaction ID is ' . $txnId . '.<br /> Please close the window.</h4>
                                </div>';
                        } else {
                            echo '<div class="col-md-12 text-center alert alert-success">
                                    <h4>Donation is successful !!!<br /><br />Thank you for your support. Your Transaction ID is ' . $txnId . '.<br /> However, the receipt could not be generated. Please contact the administrator. You may now close this window.</h4>
                                </div>';
                        }
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-warning">
                                <h4>Your transaction status is ' . $orderInfo['order_data']['status'] . '. Please try again.</h4>
                            </div>';
                    }
                } else {
                    $updateData = [
                        'notificationResponse' => json_encode($orderInfo),
                        'formSubmissionStatus' => 1
                    ];
                    $this->queryBuilder->update($tableName, $updateData, $where);

                    echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>Unfortunately, your transaction could not be processed because order details were not found from the payment gateway server.</h4>
                        </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>Unfortunately, your transaction could not be processed. Please try again.</h4>
                    </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
                    <h4>Unfortunately, your transaction could not be processed because your order details were not found. Please contact the administrator.</h4>
                </div>';
        }
    }

    public function advancePaymentReceipt($paymentRequest, $connMain)
    {
        require_once("academia/advancePayment.php");
        $tableName = 'advance_payment';
        $txnId = $paymentRequest['txnId'];
        $advancePaymentObj = new AdvancePayment();
        $advancePaymentObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];
        $advancePaymentInfo = $this->queryBuilder->selectById($tableName, '*', $where);                
        if ($advancePaymentInfo) {
            if ($advancePaymentInfo['formSubmissionStatus'] != 1) {
                $orderInfo = $this->adityaBirlaObj->fetchOrder($advancePaymentInfo);           
                if ($orderInfo['order_data']['status'] && $orderInfo['order_data']['pl_order_id'] == $txnId) {
                    $updateData = [
                        'notificationResponse' => json_encode($orderInfo),
                        'formSubmissionStatus' => 1,
                        'paymentStatus' => $orderInfo['order_data']['status']
                    ];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);                    
                    $advancePaymentInfo['paymentStatus'] = $orderInfo['order_data']['status'];                   
                    $response = $advancePaymentObj->createReceipt($advancePaymentInfo);
                    if (isset($response['status']) && $response['status'] == 'SUCCESS') {
                        $updateData = ['receiptStatus' => $response['status'], 'receiptId' => $response['receiptId']];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $result = $this->queryBuilder->update($tableName, $updateData, $where);
                        echo '<div class="col-md-12 text-center alert alert-success">
                                    <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']) . '</h4>
                            </div>';
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-success">
                        <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']) . '</h4>
                     </div>';
                    }
                } else {
                    $updateData = ['notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>' . $this->translationMsg['TRANSACTION_DATA_NOT_FOUND'] . '</h4>
                        </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '.2</h4>
            </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
              <h4>' . $this->translationMsg['TRANSACTION_DATA_NOT_FOUND'] . '1</h4>
          </div>';
        }
    }

}
