<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
require_once "ccavenuePaymentGateway.php";
require_once "./config/QueryBuilder.php";

class PaymentRequest
{
    private $conn;
    private $queryBuilder;
    private $ccavenueObj;
    private $translationMsg;

    public function __construct($conn)
    {
        $this->conn           = $conn;
        $this->queryBuilder   = new QueryBuilder($conn);
        $this->ccavenueObj    = new CCAveneuePaymentGateway();
        $this->translationMsg = json_decode(TRANSLATION_MSG, true);
    }

    public function paymentRequest($data, $screenName, $tableName, $merchantDetails)
    {

        if (! empty($data['gatewayConfig'])) {
            echo '<div class="col-md-12 text-center alert alert-warning">
                    <h4>' . $this->translationMsg['TXN_ID_ALREADY_GENERATED'] . '</h4>
                </div>';
            return;
        }
        $gatewayJSON = json_encode([
            'workingKey'     => $merchantDetails['workingKey'],
            'accessCode'     => $merchantDetails['accessCode'],
            'paymentURL'     => $merchantDetails['paymentURL'],
            'orderStatusURL' => $merchantDetails['orderStatusURL'],
            'merchantId'     => $merchantDetails['merchantId'],
            'currencyCode'   => $merchantDetails['currencyCode'],
            'language'       => $merchantDetails['language'],
        ]);

        $txnId      = 'INV' . rand(100000, 199999) . '-' . time();
        $updateData = [
            'txnId'             => $txnId,
            'gatewayConfig'     => $gatewayJSON,
            'academyLocationId' => $data['academyLocationId'],
            'paymentOption'     => $data['paymentOption'],
        ];
        $where  = ['id' => $data['id']];
        $result = $this->queryBuilder->update($tableName, $updateData, $where);

        if ($result == 1) {
            $paymentRequestColumnData = [
                'screen'          => $screenName,
                'txnId'           => $txnId,
                'paymentDate'     => date('Y-m-d H:i:s'),
                'onlinePaymentId' => ! empty($data['onlinePaymentId']) ? $data['onlinePaymentId'] : (isset($data['onlinePaymentId']) ? 0 : null),
                'paymentId'       => $data['id'],
                'payment_gateway' => $data['paymentOption'],
            ];
            $this->queryBuilder->insert('payment_request', $paymentRequestColumnData);
            $paymentDetails = $this->queryBuilder->selectById($tableName, '*', $where);
            $gatewayInfo    = '';

            if ($paymentDetails && $paymentDetails['gatewayConfig']) {
                $gatewayInfoArr = json_decode($paymentDetails['gatewayConfig'], true);
                $requiredKeys   = ['workingKey', 'accessCode', 'paymentURL', 'merchantId', 'currencyCode','orderStatusURL','language'];

                if (count(array_filter($gatewayInfoArr, fn($value) => ! empty($value) && isset($value))) === count($requiredKeys)) {
                    $gatewayInfo = 'EXIST';
                }
            }
               
            if (!$paymentDetails || $paymentDetails == 0 || $gatewayInfo != 'EXIST') {
                echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
                    </div>';
                return;
            }

            $paymentRequest = $this->ccavenueObj->createOrder($paymentDetails);
            $updateData     = [
                'paymentRequest' => json_encode($paymentRequest),
                'paymentStatus'  => 'PENDING',
            ];
            $this->queryBuilder->update($tableName, $updateData, $where);
            if (isset($paymentRequest['form']) && ! empty($paymentRequest['form'])) {
                echo $paymentRequest['form'];
                echo "
                <script language='javascript'>
                    document.addEventListener('DOMContentLoaded', function() {
                        var form = document.forms['redirect'];
                        if (form) {
                            form.submit();
                        } else {
                            console.error('Form with name \'redirect\' not found.');
                        }
                    });
                </script>";
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>' . $this->translationMsg['PAYMENT_GATEWAY_SERVER_ERROR'] . '</h4>
                    </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
                    <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
                </div>';
        }

    }

    public function onlinePaymentReceipt($paymentRequest, $connMain)
    {
        require_once "academia/onlinePayment.php";
        $tableName        = 'online_payment';
        $txnId            = $paymentRequest['txnId'];
        $paymentId        = $paymentRequest['paymentId'];
        $onlinePaymentObj = new OnlinePayment();
        $onlinePaymentObj->setConnection($this->conn, $connMain);
        $where             = ['id' => $paymentId, 'txnId' => $txnId];
        $onlinePaymentInfo = $this->queryBuilder->selectById($tableName, '*', $where);

        if ($onlinePaymentInfo) {
            if ($onlinePaymentInfo['formSubmissionStatus'] != 1 && isset($paymentRequest['txnId'])) {
                $orderInfo = $this->ccavenueObj->fetchOrder($onlinePaymentInfo);

                $orderInfo['jsonResponse'] = array_merge(
                    $orderInfo['jsonResponse'],
                    $paymentRequest['responseData']
                );
                $updateData = [
                    'notificationResponse' => json_encode($orderInfo['jsonResponse']),
                    'formSubmissionStatus' => 1,
                    'paymentStatus'        => $orderInfo['status'],
                ];
                $where = ['id' => $paymentId];
                $this->queryBuilder->update($tableName, $updateData, $where);

                if ($orderInfo['status'] === 'SUCCESS') {
                    $response = $onlinePaymentObj->createReceipt(
                        $onlinePaymentInfo['onlinePaymentId'],
                        $txnId,
                        $transactionState
                    );
                    if ($response === 'SUCCESS') {
                        $updateData = ['receiptStatus' => $response];
                        $where      = ['id' => $paymentId];
                        $this->queryBuilder->update($tableName, $updateData, $where);
                        echo '<div class="col-md-12 text-center alert alert-success">
                               <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']) . '</h4>
                            </div>';
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-success">
                               <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']) . '</h4>
                            </div>';
                    }
                } else {
                    echo '<div class="col-md-12 text-center alert alert-warning">
                           <h4>' . str_replace("[ORDER_STATUS]", $orderInfo['status'], $this->translationMsg['TRANSACTION_NOT_SUCCESS']) . '</h4>
                        </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                       <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
                    </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
                   <h4>' . $this->translationMsg['TRANSACTION_DATA_NOT_FOUND'] . '</h4>
                </div>';
        }
    }

    public function declarationPaymentReceipt($paymentRequest, $connMain)
    {
        require_once "academia/declarationPayment.php";
        $txnId                 = $paymentRequest['txnId'];
        $paymentId             = $paymentRequest['paymentId'];
        $tableName             = 'declaration_payment';
        $declarationPaymentObj = new DeclarationPayment();
        $declarationPaymentObj->setConnection($this->conn, $connMain);
        $where                  = ['id' => $paymentId, 'txnId' => $txnId];
        $declarationPaymentInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        if ($declarationPaymentInfo) {
            if ($declarationPaymentInfo['formSubmissionStatus'] != 1) {
                $orderInfo = $this->ccavenueObj->fetchOrder($declarationPaymentInfo);

                $orderInfo['jsonResponse'] = array_merge(
                    $orderInfo['jsonResponse'],
                    $paymentRequest['responseData']
                );
                $updateData = [
                    'notificationResponse' => json_encode($orderInfo['jsonResponse']),
                    'formSubmissionStatus' => 1,
                    'paymentStatus'        => $orderInfo['status'],
                ];
                $where = ['id' => $paymentId];
                $this->queryBuilder->update($tableName, $updateData, $where);

                if ($orderInfo['status'] === 'SUCCESS') {
                    $declarationPaymentInfo['paymentStatus'] = $orderInfo['status'];
                    $response                                = $declarationPaymentObj->createReceipt($declarationPaymentInfo);
                    if (isset($response['status']) && $response['status'] == 'SUCCESS') {
                        $updateData = ['receiptStatus' => $response['status'], 'receiptId' => $response['receiptId']];
                        $where      = ['id' => $paymentId];
                        $result     = $this->queryBuilder->update($tableName, $updateData, $where);
                        echo '<div class="col-md-12 text-center alert alert-success">
                                        <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']) . '</h4>
                                </div>';
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-success">
                           <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']) . '</h4>
                         </div>';
                    }
                } else {
                    echo '<div class="col-md-12 text-center alert alert-warning">
                           <h4>' . str_replace("[ORDER_STATUS]", $orderInfo['status'], $this->translationMsg['TRANSACTION_NOT_SUCCESS']) . '</h4>
                        </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                       <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
                    </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
                   <h4>' . $this->translationMsg['TRANSACTION_DATA_NOT_FOUND'] . '</h4>
                </div>';
        }
    }

    public function courseEnrollementPaymentReceipt($paymentRequest, $connMain)
    {
        require_once "academia/courseEnrollement.php";
        $txnId = $paymentRequest['txnId'];
        $paymentId             = $paymentRequest['paymentId'];    
        $tableName                   = 'enrollment_payment';
        $courseEnrollementPaymentObj = new CourseEnrollement();
        $courseEnrollementPaymentObj->setConnection($this->conn, $connMain);
        $where                 = ['id' => $paymentId, 'txnId' => $txnId];
        $courseEnrollementInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        if ($courseEnrollementInfo) {
            if ($courseEnrollementInfo['formSubmissionStatus'] != 1) {
                $orderInfo = $this->ccavenueObj->fetchOrder($courseEnrollementInfo);

                $orderInfo['jsonResponse'] = array_merge(
                    $orderInfo['jsonResponse'],
                    $paymentRequest['responseData']
                );
                $updateData = [
                    'notificationResponse' => json_encode($orderInfo['jsonResponse']),
                    'formSubmissionStatus' => 1,
                    'paymentStatus'        => $orderInfo['status'],
                ];
                $where = ['id' => $paymentId];
                $this->queryBuilder->update($tableName, $updateData, $where);
                    if ($orderInfo['status'] == 'SUCCESS') {
                        $response = $courseEnrollementPaymentObj->createReceipt($courseEnrollementInfo['onlinePaymentId'], $txnId, $orderInfo['status']);
                        if ($response == 'SUCCESS') {
                            $updateData = ['receiptStatus' => $response];
                            $where      = ['id' => $paymentId];
                            $result     = $this->queryBuilder->update($tableName, $updateData, $where);
                            echo '<div class="col-md-12 text-center alert alert-success">
                                        <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']) . '</h4>
                                </div>';

                        } else {
                            echo '<div class="col-md-12 text-center alert alert-success">
                                       <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']) . '</h4>
                                    </div>';
                        }
                    } else {
                    echo '<div class="col-md-12 text-center alert alert-warning">
                           <h4>' . str_replace("[ORDER_STATUS]", $orderInfo['status'], $this->translationMsg['TRANSACTION_NOT_SUCCESS']) . '</h4>
                        </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                       <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
                    </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
                   <h4>' . $this->translationMsg['TRANSACTION_DATA_NOT_FOUND'] . '</h4>
                </div>';
        }
    }

     public function examAssessmentReceipt($paymentRequest, $connMain)
    {
        require_once "academia/examinationPayment.php";
        $txnId = $paymentRequest['txnId'];
        $paymentId             = $paymentRequest['paymentId'];
        $tableName = 'assessment_payment';
        $examObj   = new ExaminationPayment();
        $examObj->setConnection($this->conn, $connMain);
        $where    = ['id' => $paymentId, 'txnId' => $txnId];
        $examInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        if ($examInfo) {
            if ($examInfo['formSubmissionStatus'] != 1) {                
                $orderInfo = $this->ccavenueObj->fetchOrder($examInfo);

                $orderInfo['jsonResponse'] = array_merge(
                    $orderInfo['jsonResponse'],
                    $paymentRequest['responseData']
                );
                $updateData = [
                    'notificationResponse' => json_encode($orderInfo['jsonResponse']),
                    'formSubmissionStatus' => 1,
                    'paymentStatus'        => $orderInfo['status'],
                ];
                $where = ['id' => $paymentId];
                $this->queryBuilder->update($tableName, $updateData, $where);
                    if ($orderInfo['status'] == 'SUCCESS') {
                        $response = $examObj->createReceipt($examInfo['id'], $examInfo['academyLocationId'], $txnId, $examInfo['amount'], $examInfo['currency']);

                        if (isset($response['status']) && $response['status'] == 'SUCCESS') {
                            $updateData = ['receiptStatus' => $response['status']];
                            $where      = ['id' => $paymentId];
                            $result     = $this->queryBuilder->update($tableName, $updateData, $where);

                            $tableName2       = 'assessment_payment_detail';
                            $updateDataDetail = ['receiptId' => $response['receiptId']];
                            $updateWhere      = ['examAssessmentPaymentId' => $paymentId];
                            $result2          = $this->queryBuilder->update($tableName2, $updateDataDetail, $updateWhere);
                            echo '<div class="col-md-12 text-center alert alert-success">
                                        <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']) . '</h4>
                                </div>';
                        } else {
                            echo '<div class="col-md-12 text-center alert alert-success">
                              <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']) . '</h4>
                         </div>';
                        }
                    }else {
                    echo '<div class="col-md-12 text-center alert alert-warning">
                           <h4>' . str_replace("[ORDER_STATUS]", $orderInfo['status'], $this->translationMsg['TRANSACTION_NOT_SUCCESS']) . '</h4>
                        </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                       <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
                    </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
                   <h4>' . $this->translationMsg['TRANSACTION_DATA_NOT_FOUND'] . '</h4>
                </div>';
        }
    }

    public function RevaluationReceipt($paymentRequest, $connMain)
    {
        require_once "academia/revaluationPayment.php";
        $txnId = $paymentRequest['txnId'];
        $paymentId             = $paymentRequest['paymentId'];
        $tableName = 'reval_payment';
        $revalObj  = new RevaluationPayment();
        $revalObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentId, 'txnId' => $txnId];

        $revalInfo = $this->queryBuilder->selectById($tableName, '*', $where);

        if ($revalInfo) {
            if ($revalInfo['formSubmissionStatus'] != 1) {
                
                $orderInfo = $this->ccavenueObj->fetchOrder($revalInfo);

                $orderInfo['jsonResponse'] = array_merge(
                    $orderInfo['jsonResponse'],
                    $paymentRequest['responseData']
                );
                $updateData = [
                    'notificationResponse' => json_encode($orderInfo['jsonResponse']),
                    'formSubmissionStatus' => 1,
                    'paymentStatus'        => $orderInfo['status'],
                ];
                $where = ['id' => $paymentId];
                $this->queryBuilder->update($tableName, $updateData, $where);
                    if ($orderInfo['status'] == 'SUCCESS') {
                        $response = $revalObj->createReceipt($revalInfo['id'], $revalInfo['amount'], $txnId, $orderInfo['status']);

                        if (isset($response) && isset($response['status'])) {
                            $updateData = ['receiptStatus' => $response['status']];
                            $where      = ['id' => $paymentId];
                            $result     = $this->queryBuilder->update($tableName, $updateData, $where);
                            echo '<div class="col-md-12 text-center alert alert-success">
                                        <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']) . '</h4>
                                </div>';
                        } else {
                            echo '<div class="col-md-12 text-center alert alert-success">
                            <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']) . '</h4>
                         </div>';
                        }
                    }else {
                    echo '<div class="col-md-12 text-center alert alert-warning">
                           <h4>' . str_replace("[ORDER_STATUS]", $orderInfo['status'], $this->translationMsg['TRANSACTION_NOT_SUCCESS']) . '</h4>
                        </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                       <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
                    </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
                   <h4>' . $this->translationMsg['TRANSACTION_DATA_NOT_FOUND'] . '</h4>
                </div>';
        }
    }

    public function sendPaymentLinkReceipt($paymentRequest, $connMain)
    {
        require_once "academia/sendPaymentLinkPayment.php";
        $txnId = $paymentRequest['txnId'];
        $paymentId             = $paymentRequest['paymentId'];
        $tableName          = 'online_payment';
        $sendPaymentLinkObj = new SendPaymentLinkPayment();
        $sendPaymentLinkObj->setConnection($this->conn, $connMain);
        $where               = ['id' => $paymentId, 'txnId' => $txnId];
        $sendPaymentLinkInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        if ($sendPaymentLinkInfo) {
            if ($sendPaymentLinkInfo['formSubmissionStatus'] != 1) {
                $orderInfo = $this->ccavenueObj->fetchOrder($sendPaymentLinkInfo);

                $orderInfo['jsonResponse'] = array_merge(
                    $orderInfo['jsonResponse'],
                    $paymentRequest['responseData']
                );
                $updateData = [
                    'notificationResponse' => json_encode($orderInfo['jsonResponse']),
                    'formSubmissionStatus' => 1,
                    'paymentStatus'        => $orderInfo['status'],
                ];
                $where = ['id' => $paymentId];
                $this->queryBuilder->update($tableName, $updateData, $where);

                    if ($orderInfo['status'] == 'SUCCESS') {
                        $response = $sendPaymentLinkObj->createReceipt($sendPaymentLinkInfo['sendPaymentLinkId'], $sendPaymentLinkInfo['onlinePaymentId'], $txnId, $orderInfo['status']);

                        if ($response == 'SUCCESS') {
                            $updateData    = ['receiptStatus' => $response];
                            $where         = ['id' => $paymentId];
                            $result        = $this->queryBuilder->update($tableName, $updateData, $where);
                            $paymentData   = $this->queryBuilder->selectById($tableName, '*', $where);
                            $expirePayment = $sendPaymentLinkObj->setPaymentLinkExpire($paymentData['sendPaymentLinkId'], $paymentData['onlinePaymentId']);
                            echo '<div class="col-md-12 text-center alert alert-success">
                                        <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']) . '</h4>
                                </div>';

                        } else {
                            echo '<div class="col-md-12 text-center alert alert-success">
                                      <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']) . '</h4>
                                    </div>';
                        }
                    } else {
                    echo '<div class="col-md-12 text-center alert alert-warning">
                           <h4>' . str_replace("[ORDER_STATUS]", $orderInfo['status'], $this->translationMsg['TRANSACTION_NOT_SUCCESS']) . '</h4>
                        </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                       <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
                    </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
                   <h4>' . $this->translationMsg['TRANSACTION_DATA_NOT_FOUND'] . '</h4>
                </div>';
        }
    }

    public function donationPaymentReceipt($paymentRequest, $connMain)
    {
        require_once "academia/donationPayment.php";
        $tableName = 'donation_payment';
        $txnId = $paymentRequest['txnId'];
        $paymentId             = $paymentRequest['paymentId'];

        $donationObj = new DonationPayment();
        $donationObj->setConnection($this->conn, $connMain);

        $where        = ['id' => $paymentId, 'txnId' => $txnId];
        $donationInfo = $this->queryBuilder->selectById($tableName, '*', $where);

        if ($donationInfo) {
            if ($donationInfo['formSubmissionStatus'] != 1) {
                $orderInfo = $this->ccavenueObj->fetchOrder($donationInfo);

                $orderInfo['jsonResponse'] = array_merge(
                    $orderInfo['jsonResponse'],
                    $paymentRequest['responseData']
                );
                $updateData = [
                    'notificationResponse' => json_encode($orderInfo['jsonResponse']),
                    'formSubmissionStatus' => 1,
                    'paymentStatus'        => $orderInfo['status'],
                ];
                $where = ['id' => $paymentId];
                $this->queryBuilder->update($tableName, $updateData, $where);

                    if ($orderInfo['status'] == 'SUCCESS') {
                        $response = $donationObj->createReceipt($donationInfo, 'TXN_SUCCESS');
                        if ($response == 'SUCCESS') {
                            $updateData = ['receiptStatus' => $response];
                            $this->queryBuilder->update($tableName, $updateData, $where);

                            echo '<div class="col-md-12 text-center alert alert-success">
                                <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']) . '</h4>
                            </div>';
                        } else {
                            echo '<div class="col-md-12 text-center alert alert-success">
                                    <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']) . '</h4>
                                </div>';
                        }
                    } else {
                    echo '<div class="col-md-12 text-center alert alert-warning">
                           <h4>' . str_replace("[ORDER_STATUS]", $orderInfo['status'], $this->translationMsg['TRANSACTION_NOT_SUCCESS']) . '</h4>
                        </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                       <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
                    </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
                   <h4>' . $this->translationMsg['TRANSACTION_DATA_NOT_FOUND'] . '</h4>
                </div>';
        }
    }

    public function advancePaymentReceipt($paymentRequest, $connMain)
    {    
        require_once("academia/advancePayment.php");
        $tableName = 'advance_payment';
        $txnId = $paymentRequest['txnId'];
        $paymentId             = $paymentRequest['paymentId'];
        $advancePaymentObj = new AdvancePayment();
        $advancePaymentObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentId, 'txnId' => $txnId];
        $advancePaymentInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        if ($advancePaymentInfo) {
            if ($advancePaymentInfo['formSubmissionStatus'] != 1 ) {                
                $orderInfo = $this->ccavenueObj->fetchOrder($advancePaymentInfo);

                $orderInfo['jsonResponse'] = array_merge(
                    $orderInfo['jsonResponse'],
                    $paymentRequest['responseData']
                );
                $updateData = [
                    'notificationResponse' => json_encode($orderInfo['jsonResponse']),
                    'formSubmissionStatus' => 1,
                    'paymentStatus'        => $orderInfo['status'],
                ];
                $where = ['id' => $paymentId];
                $this->queryBuilder->update($tableName, $updateData, $where);
                    if ($orderInfo['status'] == 'SUCCESS') {
                    $response = $advancePaymentObj->createReceipt($advancePaymentInfo);
                    if (isset($response['status']) && $response['status'] == 'SUCCESS') {
                        $updateData = ['receiptStatus' => $response['status'], 'receiptId' => $response['receiptId']];
                        $where = ['id' => $paymentId];
                        $result = $this->queryBuilder->update($tableName, $updateData, $where);
                        echo '<div class="col-md-12 text-center alert alert-success">
                                    <h4>'.str_replace("[TRANSACTION_ID]",$txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']).'</h4>
                            </div>';
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-success">
                        <h4>'. str_replace("[TRANSACTION_ID]",$txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']).'</h4>
                     </div>';
                    }
                 }else {
                    echo '<div class="col-md-12 text-center alert alert-warning">
                           <h4>' . str_replace("[ORDER_STATUS]", $orderInfo['status'], $this->translationMsg['TRANSACTION_NOT_SUCCESS']) . '</h4>
                        </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                       <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
                    </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
                   <h4>' . $this->translationMsg['TRANSACTION_DATA_NOT_FOUND'] . '</h4>
                </div>';
        }
    }
}
