<?php
require_once("./config/db_config.php");
class ICICIPaymentGateway{

public $domainURL;
private $createOrderUrl = '/EazyPG';
private $fetchOrderUrl = '/EazyPGVerify'; 
function __construct()
{
    $this->domainURL = domainURL;
}

private function aes128Encrypt($cipher , $plaintext , $aesKey)
{    
    in_array($cipher, openssl_get_cipher_methods(true));
    $ivlen = openssl_cipher_iv_length($cipher);    
    $iv = openssl_random_pseudo_bytes(1);
    $ciphertext = openssl_encrypt($plaintext, $cipher, $aesKey, $options=0, "");    
    return $ciphertext;   
}

public function createOrder($data)
{
    $gatewayJson = json_decode($data['gatewayConfig'], true);
    $merchantId = $gatewayJson['merchantId'];
    $paymentMode = $gatewayJson['paymentMode'];
    $aesKey = $gatewayJson['aesKey'];
    $submerchantId = $gatewayJson['submerchantId'];
    $environment = $gatewayJson['environment'];
    $cipher = $gatewayJson['cipherKey'];
    $ref_no = $data['txnId'];
    $currecny = $data['currency'];
    $amount = $data['amount'];
    $name = $data['name'];
    $email = $data['email'];
    $phone = $data['phoneNo'];
    if(isset($data['studentCode']))
    {
        $data['code'] = $data['studentCode'];
    }
    $student_id = isset($data['code'])?$data['code']:'';
    $returnUrl = $this->domainURL.'/paymentResponse.php';
    $mandatoryFields = $ref_no .'|'. $submerchantId . '|' . $amount ;//. '|' . $student_id . '|' . $name . '|' . $email . '|' . $phone;
    $optionalFields = '';

    $submerchantIdEncrypt = $this->aes128Encrypt($cipher ,$submerchantId, $aesKey);
    $referenceNoEncrypt = $this->aes128Encrypt($cipher ,$ref_no, $aesKey);
    $transactionAmountEncrypt = $this->aes128Encrypt($cipher ,$amount, $aesKey);
    $returnURLEncrypt = $this->aes128Encrypt($cipher ,$returnUrl, $aesKey);
    $paymentModeEncrypt = $this->aes128Encrypt($cipher ,$paymentMode, $aesKey);
    $mandatoryFieldsEncrypt = $this->aes128Encrypt($cipher ,$mandatoryFields, $aesKey);
    $optionalFieldsEncrypt = $this->aes128Encrypt($cipher ,$optionalFields, $aesKey);

    return [
        'beforeEncryptionURL' => $environment.$this->createOrderUrl.'?merchantid=' . $merchantId . '&mandatory%20fields=' .$mandatoryFields. '&optional%20fields=' .$optionalFields. '&returnurl=' .$returnUrl. '&Reference%20No=' .$ref_no. '&submerchantid=' .$submerchantId. '&transaction%20amount=' .$amount. '&paymode='.$paymentMode,
        'redirectUrl' => $environment.$this->createOrderUrl.'?merchantid=' . $merchantId . '&mandatory%20fields=' .$mandatoryFieldsEncrypt. '&optional%20fields=' .$optionalFieldsEncrypt. '&returnurl=' .$returnURLEncrypt. '&Reference%20No=' .$referenceNoEncrypt. '&submerchantid=' .$submerchantIdEncrypt. '&transaction%20amount=' .$transactionAmountEncrypt. '&paymode='.$paymentModeEncrypt,
    ];

    
}

public function fetchOrder($data)
{    
    $gatewayJson = json_decode($data['gatewayConfig'], true);
    $merchantId = $gatewayJson['merchantId'];
    $environment = $gatewayJson['environment'];
    $ref_no = $data['txnId'];
    $url = $environment.'/EazyPGVerify?ezpaytranid=&amount=&paymentmode=&merchantid='.$merchantId.'&trandate=&pgreferenceno='.$ref_no.'&dstatus=Y';    
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 120);
    curl_setopt(
        $ch,
        CURLOPT_HTTPHEADER,
        array(
            'Content-Type: application/json'
        )
    );
    $resultcurl = curl_exec($ch);
    $responsePaymentGateway = explode('&', $resultcurl);  
    $responseArray = [];
        foreach ($responsePaymentGateway as $val) {
            $keyValArr = explode('=', $val, 2);
            if (count($keyValArr) == 2) {
                $responseArray[$keyValArr[0]] = $keyValArr[1];
            }
        }
        
    return $responseArray;
}



}