<?php
require_once "iciciOrangePaymentGateway.php";
require_once "./config/QueryBuilder.php";

class PaymentRequest
{
    private $conn;
    private $queryBuilder;
    private $iciciOrangeObj;
    private $translationMsg;
    public function __construct($conn)
    {
        $this->conn           = $conn;
        $this->queryBuilder   = new QueryBuilder($conn);
        $this->iciciOrangeObj = new ICICIOrangePaymentGateway();
        $this->translationMsg = json_decode(TRANSLATION_MSG, true);
    }

public function paymentRequest($data, $screenName, $tableName, $merchantDetails)
{
    if (!empty($data['txnId'])) {
        echo '<div class="col-md-12 text-center alert alert-warning">
                <h4>' . $this->translationMsg['TXN_ID_ALREADY_GENERATED'] . '</h4>
              </div>';
        return;
    }

    $activeGateway = $data['paymentOption'];
    $currency      = $merchantDetails['currency'];

    $gatewayJSON = json_encode([
        'merchantId'      => $merchantDetails['merchantId'],
        'secretKey'       => $merchantDetails['secretKey'],
        'apiUrl'          => $merchantDetails['environmentURL'],
        'payType'         => $merchantDetails['payType'],
        'transactionType' => $merchantDetails['transactionType']
    ]);

    $orderIDCreated = time() . rand(100, 999);

    $updateData = [
        'gatewayConfig'     => $gatewayJSON,
        'currency'          => $currency,
        'academyLocationId' => $data['academyLocationId'],
        'paymentOption'     => $activeGateway,
        'txnId'             => $orderIDCreated,
    ];

    $where  = ['id' => $data['id']];
    $result = $this->queryBuilder->update($tableName, $updateData, $where);

    if ($result != 1) {
        echo '<div class="col-md-12 text-center alert alert-warning">
                <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
              </div>';
        return;
    }

    // Fetch updated row
    $updateInfo = $this->queryBuilder->selectById($tableName, '*', $where);

    // Call gateway
    $paymentRequest = $this->iciciOrangeObj->createOrder($updateInfo);
    /**
     * ALWAYS SAVE paymentRequest (success OR failure)
     */
    $this->queryBuilder->update(
        $tableName,
        ['paymentRequest' => json_encode($paymentRequest)],
        $where
    );

    /**
     * Insert request log in payment_request table
     */
    $this->queryBuilder->insert('payment_request', [
        'payment_gateway' => $activeGateway,
        'screen'          => $screenName,
        'txnId'           => $updateInfo['txnId'],
        'paymentDate'     => date('Y-m-d H:i:s'),
        'onlinePaymentId' => $updateInfo['onlinePaymentId'] ?? 0,
        'paymentId'       => $updateInfo['id'],
    ]);

    /**
     * SUCCESS → Redirect
     */
    if (!empty($paymentRequest['redirectUrl'])) {
        header('Location: ' . $paymentRequest['redirectUrl']);
        exit;
    }


    /**
     * ❌ FAILURE → Show Gateway Error
     */
    $errorMsg = $paymentRequest['message']
        ?? $paymentRequest['rawResponse']['responseDescription']
        ?? $this->translationMsg['PAYMENT_GATEWAY_SERVER_ERROR'];

    echo '<div class="col-md-12 text-center alert alert-warning">
            <h4>' . htmlspecialchars($errorMsg) . '</h4>
          </div>';
}


    public function onlinePaymentReceipt($paymentRequest, $connMain)  //Online Payment Function Accepts payment Request from loadReceiptFunction and Main Connection --- Check PaymentResponse.php
    {
        $txnId = $paymentRequest['txnId'];

        require_once "academia/onlinePayment.php";

        $tableName        = 'online_payment';
        $onlinePaymentObj = new OnlinePayment();
        $onlinePaymentObj->setConnection($this->conn, $connMain);

        $where = [
            'id'    => $paymentRequest['paymentId'],
            'txnId' => $txnId
        ];

        $onlinePaymentInfo = $this->queryBuilder->selectById($tableName, '*', $where);

        if (!$onlinePaymentInfo) {
            echo '<div class="col-md-12 text-center alert alert-warning">
                    <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
                </div>';
            return;
        }

        // Prevent duplicate processing
        if ((int)$onlinePaymentInfo['formSubmissionStatus'] === 1) {
            echo '<div class="col-md-12 text-center alert alert-warning">
                    <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
                </div>';
            return;
        }

        /**
         *  PhiCommerce STATUS verification
         */
        $orderInfo = $this->iciciOrangeObj->fetchOrder($onlinePaymentInfo);      

        /**
         *  SUCCESS CASE
         */
        if (isset($orderInfo['status']) && $orderInfo['status'] === 'Success' && isset($orderInfo['merchantTxnNo']) && $orderInfo['merchantTxnNo'] === $txnId ) {
            $fullOrderInfoArr = [
                'initialResponse'  => $paymentRequest['responseData'] ?? [],
                'verifiedResponse' => $orderInfo,
            ];

            $updateData = [
                'notificationResponse' => json_encode($fullOrderInfoArr),
                'formSubmissionStatus' => 1,
                'paymentStatus'        => 'Success',
            ];

            $this->queryBuilder->update($tableName, $updateData,['id' => $paymentRequest['paymentId']]);

            /**
             *  Generate receipt
             */
            $response = $onlinePaymentObj->createReceipt($onlinePaymentInfo['onlinePaymentId'],$txnId, $orderInfo['status'] );

            if ($response === 'SUCCESS') {
                $this->queryBuilder->update($tableName, ['receiptStatus' => 'SUCCESS'], ['id' => $paymentRequest['paymentId']] );

                echo '<div class="col-md-12 text-center alert alert-success">
                        <h4>' .
                            str_replace(
                                "[TRANSACTION_ID]",
                                $txnId,
                                $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']
                            ) .
                    '</h4></div>';
            } else {
                echo '<div class="col-md-12 text-center alert alert-success">
                        <h4>' .
                            str_replace(
                                "[TRANSACTION_ID]",
                                $txnId,
                                $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']
                            ) .
                    '</h4></div>';
            }

            return;
        }

        /**
         * ⏳ PENDING / NOT SUCCESS
         */
        $updateData = [
            'notificationResponse' => json_encode($orderInfo),
            'formSubmissionStatus' => 1,
            'paymentStatus'        => $orderInfo['txnStatus'] ?? 'FAILED'
        ];

        $this->queryBuilder->update(
            $tableName,
            $updateData,
            ['id' => $paymentRequest['paymentId']]
        );

        if (($orderInfo['txnStatus'] ?? '') === 'PEN') {
            echo '<div class="col-md-12 text-center alert alert-info">
                    <h4>Your transaction is still pending. Please try again later.</h4>
                </div>';
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
                    <h4>' .
                        ($orderInfo['message']
                            ?? $this->translationMsg['TRANSACTION_NOT_SUCCESS']) .
                '</h4></div>';
        }
    }


    public function declarationPaymentReceipt($paymentRequest, $connMain)
    {
        $txnId = $paymentRequest['txnId'];
        require_once "academia/declarationPayment.php";
        $tableName             = 'declaration_payment';
        $declarationPaymentObj = new DeclarationPayment();
        $declarationPaymentObj->setConnection($this->conn, $connMain);
        $where                  = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];
        $declarationPaymentInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        if ($declarationPaymentInfo) {
            if ($declarationPaymentInfo['formSubmissionStatus'] != 1) {
                $orderInfo = $this->iciciOrangeObj->fetchOrder($declarationPaymentInfo);
                if ($orderInfo['status'] == 'Success' && $orderInfo['pgreferenceno'] == $txnId) {
                    $fullOrderInfoArr = [
                        'initialResponse'  => $paymentRequest['responseData'],
                        'verifiedResponse' => $orderInfo,
                    ];
                    $updateData = [
                        'notificationResponse' => json_encode($fullOrderInfoArr),
                        'formSubmissionStatus' => 1,
                        'paymentStatus'        => $orderInfo['status'],
                    ];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);

                    if ($orderInfo['status'] == 'Success') {
                        $declarationPaymentInfo['paymentStatus'] = $orderInfo['status'];
                        $response                                = $declarationPaymentObj->createReceipt($declarationPaymentInfo);
                        if (isset($response['status']) && $response['status'] == 'SUCCESS') {
                            $updateData = ['receiptStatus' => $response['status'], 'receiptId' => $response['receiptId']];
                            $where      = ['id' => $paymentRequest['paymentId']];
                            $result     = $this->queryBuilder->update($tableName, $updateData, $where);
                            echo '<div class="col-md-12 text-center alert alert-success">
                                        <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']) . '</h4>
                                </div>';
                        } else {
                            echo '<div class="col-md-12 text-center alert alert-success">
                           <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']) . '</h4>
                         </div>';
                        }
                    } elseif ($orderInfo['status'] == 'CHALLAN_GENERATED') {
                        echo '<div class="col-md-12 text-center alert alert-info">
                                <h4>Your transaction status is CHALLAN_GENERATED. Please proceed with the challan payment.</h4>
                            </div>';
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-warning">
                                <h4>' . str_replace("[ORDER_STATUS]", $orderInfo['status'], $this->translationMsg['TRANSACTION_NOT_SUCCESS']) . '</h4>
                            </div>';
                    }
                } else {
                    $updateData = [
                        'notificationResponse' => json_encode($orderInfo),
                        'formSubmissionStatus' => 1,
                    ];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>' . $this->translationMsg['TRANSACTION_DATA_NOT_FOUND'] . '</h4>
                        </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
            </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
              <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
          </div>';
        }
    }

    public function courseEnrollementPaymentReceipt($paymentRequest, $connMain)
    {
        $txnId = $paymentRequest['txnId'];
        require_once "academia/courseEnrollement.php";
        $tableName                   = 'enrollment_payment';
        $courseEnrollementPaymentObj = new CourseEnrollement();
        $courseEnrollementPaymentObj->setConnection($this->conn, $connMain);
        $where                 = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];
        $courseEnrollementInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        if ($courseEnrollementInfo) {
            if ($courseEnrollementInfo['formSubmissionStatus'] != 1) {
                $orderInfo = $this->iciciOrangeObj->fetchOrder($courseEnrollementInfo);
                if ($orderInfo['status'] == 'Success' && $orderInfo['pgreferenceno'] == $txnId) {
                    $fullOrderInfoArr = [
                        'initialResponse'  => $paymentRequest['responseData'],
                        'verifiedResponse' => $orderInfo,
                    ];
                    $updateData = [
                        'notificationResponse' => json_encode($fullOrderInfoArr),
                        'formSubmissionStatus' => 1,
                        'paymentStatus'        => $orderInfo['status'],
                    ];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    if ($orderInfo['status'] == 'Success') {
                        $response = $courseEnrollementPaymentObj->createReceipt($courseEnrollementInfo['onlinePaymentId'], $txnId, $orderInfo['status']);
                        if ($response == 'SUCCESS') {
                            $updateData = ['receiptStatus' => $response];
                            $where      = ['id' => $paymentRequest['paymentId']];
                            $result     = $this->queryBuilder->update($tableName, $updateData, $where);
                            echo '<div class="col-md-12 text-center alert alert-success">
                                        <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']) . '</h4>
                                </div>';

                        } else {
                            echo '<div class="col-md-12 text-center alert alert-success">
                                       <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']) . '</h4>
                                    </div>';
                        }
                    } elseif ($orderInfo['status'] == 'CHALLAN_GENERATED') {
                        echo '<div class="col-md-12 text-center alert alert-info">
                                <h4>Your transaction status is CHALLAN_GENERATED. Please proceed with the challan payment.</h4>
                            </div>';
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-warning">
                                <h4>' . str_replace("[ORDER_STATUS]", $orderInfo['status'], $this->translationMsg['TRANSACTION_NOT_SUCCESS']) . '</h4>
                            </div>';
                    }
                } else {
                    $updateData = [
                        'notificationResponse' => json_encode($orderInfo),
                        'formSubmissionStatus' => 1,
                    ];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>' . $this->translationMsg['TRANSACTION_DATA_NOT_FOUND'] . '</h4>
                        </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
                    </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
            <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
        </div>';
        }
    }

    public function examAssessmentReceipt($paymentRequest, $connMain)
    {
        $txnId = $paymentRequest['txnId'];
        require_once "academia/examinationPayment.php";
        $tableName = 'assessment_payment';
        $examObj   = new ExaminationPayment();
        $examObj->setConnection($this->conn, $connMain);
        $where    = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];
        $examInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        if ($examInfo) {
            if ($examInfo['formSubmissionStatus'] != 1) {
                $activeGateway = $examInfo['paymentOption'];
                $orderInfo     = $this->iciciOrangeObj->fetchOrder($examInfo);
                if ($orderInfo['status'] == 'Success' && $orderInfo['pgreferenceno'] == $txnId) {
                    $fullOrderInfoArr = [
                        'initialResponse'  => $paymentRequest['responseData'],
                        'verifiedResponse' => $orderInfo,
                    ];
                    $updateData = [
                        'notificationResponse' => json_encode($fullOrderInfoArr),
                        'formSubmissionStatus' => 1,
                        'paymentStatus'        => $orderInfo['status'],
                    ];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    if ($orderInfo['status'] == 'Success') {
                        $response = $examObj->createReceipt($examInfo['id'], $examInfo['academyLocationId'], $txnId, $examInfo['amount'], $examInfo['currency']);

                        if (isset($response['status']) && $response['status'] == 'SUCCESS') {
                            $updateData = ['receiptStatus' => $response['status']];
                            $where      = ['id' => $paymentRequest['paymentId']];
                            $result     = $this->queryBuilder->update($tableName, $updateData, $where);

                            $tableName2       = 'assessment_payment_detail';
                            $updateDataDetail = ['receiptId' => $response['receiptId']];
                            $updateWhere      = ['examAssessmentPaymentId' => $paymentRequest['paymentId']];
                            $result2          = $this->queryBuilder->update($tableName2, $updateDataDetail, $updateWhere);
                            echo '<div class="col-md-12 text-center alert alert-success">
                                        <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']) . '</h4>
                                </div>';
                        } else {
                            echo '<div class="col-md-12 text-center alert alert-success">
                              <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']) . '</h4>
                         </div>';
                        }
                    } elseif ($orderInfo['status'] == 'CHALLAN_GENERATED') {
                        echo '<div class="col-md-12 text-center alert alert-info">
                                <h4>Your transaction status is CHALLAN_GENERATED. Please proceed with the challan payment.</h4>
                            </div>';
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-warning">
                                <h4>' . str_replace("[ORDER_STATUS]", $orderInfo['status'], $this->translationMsg['TRANSACTION_NOT_SUCCESS']) . '</h4>
                            </div>';
                    }
                } else {
                    $updateData = [
                        'notificationResponse' => json_encode($orderInfo),
                        'formSubmissionStatus' => 1,
                    ];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>' . $this->translationMsg['TRANSACTION_DATA_NOT_FOUND'] . '</h4>
                        </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
            </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
            <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
        </div>';
        }
    }

    public function RevaluationReceipt($paymentRequest, $connMain)
    {
        $txnId = $paymentRequest['txnId'];
        require_once "academia/revaluationPayment.php";
        $tableName = 'reval_payment';
        $revalObj  = new RevaluationPayment();
        $revalObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];

        $revalInfo = $this->queryBuilder->selectById($tableName, '*', $where);

        if ($revalInfo) {
            if ($revalInfo['formSubmissionStatus'] != 1) {
                $activeGateway = $revalInfo['paymentOption'];
                $orderInfo     = $this->iciciOrangeObj->fetchOrder($revalInfo);
                if ($orderInfo['status'] == 'Success' && $orderInfo['pgreferenceno'] == $txnId) {
                    $fullOrderInfoArr = [
                        'initialResponse'  => $paymentRequest['responseData'],
                        'verifiedResponse' => $orderInfo,
                    ];
                    $updateData = [
                        'notificationResponse' => json_encode($fullOrderInfoArr),
                        'formSubmissionStatus' => 1,
                        'paymentStatus'        => $orderInfo['status'],
                    ];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    if ($orderInfo['status'] == 'Success') {
                        $response = $revalObj->createReceipt($revalInfo['id'], $revalInfo['amount'], $txnId, $orderInfo['status']);

                        if (isset($response) && isset($response['status'])) {
                            $updateData = ['receiptStatus' => $response['status']];
                            $where      = ['id' => $paymentRequest['paymentId']];
                            $result     = $this->queryBuilder->update($tableName, $updateData, $where);
                            echo '<div class="col-md-12 text-center alert alert-success">
                                        <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']) . '</h4>
                                </div>';
                        } else {
                            echo '<div class="col-md-12 text-center alert alert-success">
                            <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']) . '</h4>
                         </div>';
                        }
                    } elseif ($orderInfo['status'] == 'CHALLAN_GENERATED') {
                        echo '<div class="col-md-12 text-center alert alert-info">
                                <h4>Your transaction status is CHALLAN_GENERATED. Please proceed with the challan payment.</h4>
                            </div>';
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-warning">
                                <h4>' . str_replace("[ORDER_STATUS]", $orderInfo['status'], $this->translationMsg['TRANSACTION_NOT_SUCCESS']) . '</h4>
                            </div>';
                    }
                } else {
                    $updateData = [
                        'notificationResponse' => json_encode($orderInfo),
                        'formSubmissionStatus' => 1,
                    ];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>' . $this->translationMsg['TRANSACTION_DATA_NOT_FOUND'] . '</h4>
                        </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
                    </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
            <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
        </div>';
        }
    }

    public function sendPaymentLinkReceipt($paymentRequest, $connMain)
    {
        $txnId = $paymentRequest['txnId'];
        require_once "academia/sendPaymentLinkPayment.php";
        $tableName          = 'online_payment';
        $sendPaymentLinkObj = new SendPaymentLinkPayment();
        $sendPaymentLinkObj->setConnection($this->conn, $connMain);
        $where               = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];
        $sendPaymentLinkInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        if ($sendPaymentLinkInfo) {
            if ($sendPaymentLinkInfo['formSubmissionStatus'] != 1) {
                $orderInfo = $this->iciciOrangeObj->fetchOrder($sendPaymentLinkInfo);
                if ($orderInfo['status'] == 'Success' && $orderInfo['pgreferenceno'] == $txnId) {
                    $fullOrderInfoArr = [
                        'initialResponse'  => $paymentRequest['responseData'],
                        'verifiedResponse' => $orderInfo,
                    ];
                    $updateData = [
                        'notificationResponse' => json_encode($fullOrderInfoArr),
                        'formSubmissionStatus' => 1,
                        'paymentStatus'        => $orderInfo['status'],
                    ];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);

                    if ($orderInfo['status'] == 'Success') {
                        $response = $sendPaymentLinkObj->createReceipt($sendPaymentLinkInfo['sendPaymentLinkId'], $sendPaymentLinkInfo['onlinePaymentId'], $txnId, $orderInfo['status']);

                        if ($response == 'SUCCESS') {
                            $updateData    = ['receiptStatus' => $response];
                            $where         = ['id' => $paymentRequest['paymentId']];
                            $result        = $this->queryBuilder->update($tableName, $updateData, $where);
                            $paymentData   = $this->queryBuilder->selectById($tableName, '*', $where);
                            $expirePayment = $sendPaymentLinkObj->setPaymentLinkExpire($paymentData['sendPaymentLinkId'], $paymentData['onlinePaymentId']);
                            echo '<div class="col-md-12 text-center alert alert-success">
                                        <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']) . '</h4>
                                </div>';

                        } else {
                            echo '<div class="col-md-12 text-center alert alert-success">
                                      <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']) . '</h4>
                                    </div>';
                        }
                    } elseif ($orderInfo['status'] == 'CHALLAN_GENERATED') {
                        echo '<div class="col-md-12 text-center alert alert-info">
                                <h4>Your transaction status is CHALLAN_GENERATED. Please proceed with the challan payment.</h4>
                            </div>';
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-warning">
                                <h4>' . str_replace("[ORDER_STATUS]", $orderInfo['status'], $this->translationMsg['TRANSACTION_NOT_SUCCESS']) . '</h4>
                            </div>';
                    }
                } else {
                    $updateData = [
                        'notificationResponse' => json_encode($orderInfo),
                        'formSubmissionStatus' => 1,
                    ];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>' . $this->translationMsg['TRANSACTION_DATA_NOT_FOUND'] . '</h4>
                        </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
                    </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
              <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
          </div>';
        }
    }

    public function donationPaymentReceipt($paymentRequest, $connMain)
    {
        require_once "academia/donationPayment.php";
        $tableName = 'donation_payment';
        $txnId     = $paymentRequest['txnId'];

        $donationObj = new DonationPayment();
        $donationObj->setConnection($this->conn, $connMain);

        $where        = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];
        $donationInfo = $this->queryBuilder->selectById($tableName, '*', $where);

        if ($donationInfo) {
            if ($donationInfo['formSubmissionStatus'] != 1) {
                $orderInfo = $this->iciciOrangeObj->fetchOrder($donationInfo);

                if ($orderInfo['status'] == 'Success' && $orderInfo['pgreferenceno'] == $txnId) {
                    $fullOrderInfoArr = [
                        'initialResponse'  => $paymentRequest['responseData'],
                        'verifiedResponse' => $orderInfo,
                    ];

                    $updateData = [
                        'notificationResponse' => json_encode($fullOrderInfoArr),
                        'formSubmissionStatus' => 1,
                        'paymentStatus'        => $orderInfo['status'],
                    ];

                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);

                    if ($orderInfo['status'] == 'Success') {
                        $response = $donationObj->createReceipt($donationInfo, 'TXN_SUCCESS');
                        if ($response == 'SUCCESS') {
                            $updateData = ['receiptStatus' => $response];
                            $this->queryBuilder->update($tableName, $updateData, $where);

                            echo '<div class="col-md-12 text-center alert alert-success">
                                <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']) . '</h4>
                            </div>';
                        } else {
                            echo '<div class="col-md-12 text-center alert alert-success">
                                    <h4>' . str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']) . '</h4>
                                </div>';
                        }
                    } elseif ($orderInfo['status'] == 'CHALLAN_GENERATED') {
                        echo '<div class="col-md-12 text-center alert alert-info">
                            <h4>Your transaction status is CHALLAN_GENERATED. Please proceed with the challan payment.</h4>
                        </div>';
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>' . str_replace("[ORDER_STATUS]", $orderInfo['status'], $this->translationMsg['TRANSACTION_NOT_SUCCESS']) . '</h4>
                        </div>';
                    }

                } else {
                    $updateData = [
                        'notificationResponse' => json_encode($orderInfo),
                        'formSubmissionStatus' => 1,
                    ];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);

                    echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>' . $this->translationMsg['TRANSACTION_DATA_NOT_FOUND'] . '</h4>
                    </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
                    </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
                    <h4>' . $this->translationMsg['TRANSACTION_ERROR'] . '</h4>
                </div>';
        }
    }

    public function advancePaymentReceipt($paymentRequest, $connMain)
    {    
        require_once("academia/advancePayment.php");
        $tableName = 'advance_payment';
        $txnId = $paymentRequest['txnId'];
        $advancePaymentObj = new AdvancePayment();
        $advancePaymentObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];
        $advancePaymentInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        if ($advancePaymentInfo) {
            if ($advancePaymentInfo['formSubmissionStatus'] != 1 ) {                
                $orderInfo = $this->iciciOrangeObj->fetchOrder($advancePaymentInfo);               
                if ($orderInfo['status'] == 'Success' && $orderInfo['pgreferenceno'] == $txnId) {
                    $fullOrderInfoArr = [
                        'initialResponse'  => $paymentRequest['responseData'],
                        'verifiedResponse' => $orderInfo,
                    ];
                    $updateData = [
                        'notificationResponse' => json_encode($fullOrderInfoArr),
                        'formSubmissionStatus' => 1,
                        'paymentStatus'        => $orderInfo['status'],
                    ];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    $advancePaymentInfo['paymentStatus'] = $orderInfo['status'];
                    if ($orderInfo['status'] == 'Success') {
                    $response = $advancePaymentObj->createReceipt($advancePaymentInfo);
                    if (isset($response['status']) && $response['status'] == 'SUCCESS') {
                        $updateData = ['receiptStatus' => $response['status'], 'receiptId' => $response['receiptId']];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $result = $this->queryBuilder->update($tableName, $updateData, $where);
                        echo '<div class="col-md-12 text-center alert alert-success">
                                    <h4>'.str_replace("[TRANSACTION_ID]",$txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']).'</h4>
                            </div>';
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-success">
                        <h4>'. str_replace("[TRANSACTION_ID]",$txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']).'</h4>
                     </div>';
                    }
                 } elseif ($orderInfo['status'] == 'CHALLAN_GENERATED') {
                        echo '<div class="col-md-12 text-center alert alert-info">
                                <h4>Your transaction status is CHALLAN_GENERATED. Please proceed with the challan payment.</h4>
                            </div>';
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-warning">
                                <h4>' . str_replace("[ORDER_STATUS]", $orderInfo['status'], $this->translationMsg['TRANSACTION_NOT_SUCCESS']) . '</h4>
                            </div>';
                    }
                } else {
                      $updateData = [
                        'notificationResponse' => json_encode($orderInfo),
                        'formSubmissionStatus' => 1,
                    ];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>' . $this->translationMsg['TRANSACTION_DATA_NOT_FOUND'] . '</h4>
                        </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                <h4>'.$this->translationMsg['TRANSACTION_ERROR'].'.</h4>
            </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
              <h4>'.$this->translationMsg['TRANSACTION_DATA_NOT_FOUND'].'</h4>
          </div>';
        }
    }
}
