## JNCB Payment Gateway Integration ##

# Overview:
This module handles payment processing for various payment scenarios in an application. It covers functionalities for generating payment receipts, updating payment statuses, and managing payment-related notifications.

# Prerequisites:

                    "powerTranz_id": "{$merchantDetails['username']}",
                    "powerTranz_password": "{$merchantDetails['password']}",
                    "pageSet": "{$merchantDetails['safekey']}",
                    "env": "{$merchantDetails['environment']}",
                    "pageName": "{$currencyCode}"

Environment -  https://staging.ptranz.com/Api   Live -   https://gateway.ptranz.com/Api 
Username -     88801357
Password -     6C9ez4QYThmHQZwxMXIgRkb8DkisTZzPoZOtUz8BZhQyC7MGEnfGmz1
CurrencyCode - Checkout
Safekey -      JNCBCV

# Key Features:
•	Processes payments for exams, declarations, revaluations, online payment links, and ad hoc payments.

•	Handles success and failure scenarios for transactions.

•	Updates database records with transaction details.

•	Generates payment receipts.

# # Payment Request File:
This file implements methods for processing different types of payments and generating receipts.

# Key Methods:
1) paymentRequest($data, $screenName, $tableName, $merchantDetails) ->
• Description: Handles payment requests by validating input, configuring the payment gateway, and updating payment details.

• Flow: Validate transaction ID and currency availability.
        Configure payment gateway and generate a unique order identifier.
        Update the database with payment details and request payment from the gateway.

2) onlinePaymentReceipt($paymentRequest, $connMain) ->
• Description: Processes online payment receipts by verifying payment details and updating the database.

• Flow: Fetch payment details using transaction and payment IDs.
        Validate transaction status with the payment gateway.
        Update database with transaction and receipt details.
        Display appropriate success or failure messages to the user.

3) courseEnrollementPaymentReceipt($paymentRequest, $connMain) ->
• Description: Manages payments for course enrollments and receipt generation.

• Flow: Validate and fetch payment details from the database.
        Confirm payment status with the gateway and update records.
        Generate receipts and provide feedback on transaction success or failure.

4) examAssessmentReceipt($paymentRequest, $connMain) ->
• Description: Processes exam payments and updates payment details.

• Flow: Fetch order details from the payment gateway.
        Update database with payment and receipt details.
        Generate success or failure messages based on transaction status.

5) declarationPaymentReceipt($paymentRequest, $connMain) ->
• Description: Handles declaration payments and receipt generation.

• Flow: Validate transaction ID and payment ID.
        Fetch order details and generate receipts if payment is successful.
        Update database with payment status.

6) RevaluationReceipt($paymentRequest, $connMain) ->
• Description: Manages payments for revaluation services.

• Flow: Verify payment and order details.
        Update database records with transaction and receipt status.
        Provide appropriate user feedback.

7) sendPaymentLinkReceipt($paymentRequest, $connMain) ->
• Description: Processes payments made via online payment links.

• Flow: Fetch payment details using payment and transaction IDs.
        Handle success and failure responses from the payment gateway.
        Generate receipts and update database records.

8) advancePaymentReceipt($paymentRequest, $connMain) ->
• Description: Processes ad hoc payments and manages receipts.

• Flow: Validate and fetch payment details.
        Update database with transaction status and generate receipts.
        Provide user feedback based on success or failure.

# # JNCB Payment Gateway File:
The JncbPaymentGateway class is designed to integrate and handle payment operations with a third-party payment gateway. It provides functionalities to create orders, update payments, and fetch transaction details.

# Key Methods:
1) createOrder($data) ->
• Description: Creates a new order by configuring the payment gateway and sending transaction details.

• Flow: Parse and validate the input data.
        Configure payment details, including billing address, amount, and currency.
        Send the payment request to the gateway.
        Log responses and handle redirection or errors as needed.

2) updatePaymentOnGatewayDashboard($data, $spiToken) ->
• Description: Updates payment status on the gateway dashboard using a provided token.

• Flow: Parse the gatewayConfig from input data.
        Send a POST request to the gateway with the token.
        Handle response and errors appropriately.

3) fetchOrder($data) ->
• Description: Retrieves and updates order details by communicating with the payment gateway.

• Flow: Parse the input data and decode the payment request.
        Fetch the order status using the gateway's API.
        If the order is successful, update the database with the response.
        Log errors or handle unsuccessful transactions.

# Database Interactions

**Tables Used**
‣ exam_assessment_payment
‣ assessment_payment_detail
‣ declaration_payment
‣ reval_payment
‣ online_payment
‣ advance_payment

**QueryBuilder**
‣ selectById: Fetches specific records.
‣ update: Updates records with the provided data and conditions.

# Dependencies

**Files**
‣ academia/advancePayment.php
‣ academia/courseEnrollment.php
‣ academia/declarationPayment.php
‣ academia/examinationPayment.php
‣ academia/onlinePayment.php
‣ academia/revaluationPayment.php
‣ academia/sendPaymentLinkPayment.php

**External Libraries**
‣ Payment Gateway Integration (jncbObj)

# Error Handling

**Scenarios**
‣ Transaction failures due to incorrect details.
‣ Receipt generation issues.
‣ Missing payment records in the database.
‣ Handles invalid configurations and missing keys.
‣ Logs cURL errors and displays appropriate error messages.

**User Feedback**
‣Provides clear success or error messages displayed in a formatted manner using Bootstrap alerts.

# Usage Instructions
1) Setup Database: 
                 • Ensure all necessary tables (exam_payment, declaration_payment, etc.) are created.
                 • Configure the database connection in the QueryBuilder class.

2) Payment Gateway Integration:
                 • Replace placeholders in fetchOrder and other payment gateway-related functions with actual API calls.
                 • Configure payment gateway credentials and endpoints.

3) Server Configuration:
                 • Host the files on a server with PHP support.
                 • Ensure necessary libraries (e.g., cURL) are enabled.

4) Testing: 
                 • Test each payment flow (exam, declaration, revaluation, etc.) with dummy data.
                 • Validate the receipt generation and database updates.

# Notes
• This module is designed to be extensible for additional payment types.
• Proper validation should be ensured for inputs to prevent inconsistencies.
• Review and update configurations for the payment gateway integration (jncbObj).
• Ensure SSL is enabled for production environments. Current settings disable SSL verification for debugging purposes:

# Conclusion:
This project provides a robust framework for handling various payment types and their associated workflows. With proper configuration and testing, it can be integrated seamlessly into applications requiring payment functionalities.