<?php



require_once("./config/db_config.php");
// namespace PaymentGateways\Network;

// use PaymentGateways\PaymentGatewayInterface;

class PayDunyaGateway
{
    // private $tokenUrl = 'identity/auth/access-token';
    public $domainURL;
    private $createOrderUrl = 'v1/checkout-invoice/create';
    private $fetchOrderUrl = 'v1/checkout-invoice/confirm/';
    // private $accessToken;
    public const GCM_TAG_LENGTH = 16;
    function __construct()
    {
        $this->domainURL = domainURL;
    }
    public function createOrder($data)
    {
        $gatewayJson = json_decode($data['gatewayConfig'], true);
        $environment = $gatewayJson['environment'];
        $masterKey = $gatewayJson['masterKey'];
        $privateKey = $gatewayJson['privateKey'];
        $token = $gatewayJson['token'];

        $jsonParam = '{
            "invoice": {
                "total_amount": '.$data['amount'].'
            },
            "store": {
                "name": "'.$data['name'].'",
                "phone": "'.$data['phoneNo'].'",
                "logo_url": "https://paydunya.com/images/logo_blue.png",
                "website_url": ""
            },
            "actions": {
                "callback_url":"' . $this->domainURL . '/paymentResponse.php",
                "cancel_url": "' . $this->domainURL . '/paymentResponse.php",
                "return_url": "' . $this->domainURL . '/paymentResponse.php"
            }
        }';
        $headerArr = array(
            'Content-Type: application/json',
            'PAYDUNYA-MASTER-KEY: '.$masterKey,
            'PAYDUNYA-PRIVATE-KEY: '.$privateKey,
            'PAYDUNYA-TOKEN: '.$token
        );
        // echo $environment.$this->createOrderUrl;
        // print_r($headerArr);return 'Check';
        $curl = curl_init();

        curl_setopt_array($curl, array(
        CURLOPT_URL => $environment.$this->createOrderUrl,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => $jsonParam,
        CURLOPT_HTTPHEADER => $headerArr,
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        // echo $response;

        $jsonResponse = json_decode($response, true);
        return $jsonResponse;
    }

    public function fetchOrder($data) {

        $gatewayJson = isset($data['gatewayConfig'])? json_decode($data['gatewayConfig'], true):'';
        $paymentRequest =  isset($data['paymentRequest'])? json_decode($data['paymentRequest'],  true):'';
        if($gatewayJson){
            $masterKey = $gatewayJson['masterKey'] ?? '';
            $environment = $gatewayJson['environment'] ?? '';
            $privateKey = $gatewayJson['privateKey'] ?? '';
            $token = $gatewayJson['token'] ?? '';
        }else {
            return false;
        }
        $orderId = $data['txnId'];

        $curl = curl_init();

        curl_setopt_array($curl, array(
        CURLOPT_URL =>  $environment.$this->fetchOrderUrl.$orderId,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'PAYDUNYA-MASTER-KEY: '.$masterKey,
            'PAYDUNYA-PRIVATE-KEY: '.$privateKey,
            'PAYDUNYA-TOKEN: '.$token
        ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        return json_decode($response, true);
    }
}
