<?php
require_once("payDunyaPaymentGateway.php");
require_once("./config/QueryBuilder.php");
class PaymentRequest
{
    private $conn;
    private $queryBuilder;
    private $payDunyaObj;
    public function __construct($conn)
    {
        $this->conn = $conn;
        $this->queryBuilder = new QueryBuilder($conn);
        $this->payDunyaObj = new PayDunyaGateway();
    }

    public function paymentRequest($data, $screenName, $tableName, $merchantDetails)
    {


        if ($data['txnId']) {
            echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>Please try again later because Transaction ID already generated for this order.</h4>
                    </div>';
        } else {
            $currencyCode = $merchantDetails['currencyCode'];
            $activeGateway = $data['paymentOption'];
            $gatewayJSON = <<<GATEWAYJSON
            {
                "environment": "{$merchantDetails['environment']}",
                "masterKey": "{$merchantDetails['username']}",
                "privateKey": "{$merchantDetails['password']}",
                "token": "{$merchantDetails['safekey']}",
                "currencyCode": "{$merchantDetails['currencyCode']}"
            }
            GATEWAYJSON;
            $orderIDCreated = time() . rand(100, 999);
            $updateData = ['gatewayConfig' => $gatewayJSON, 'currency' => $currencyCode, 'academyLocationId' => $data['academyLocationId'], 'paymentOption' => $activeGateway];
            $where = ['id' => $data['id']];
            $result = $this->queryBuilder->update($tableName, $updateData, $where);
            if ($result == 1) {
                $where = ['id' => $data['id']];
                $updateInfo = $this->queryBuilder->selectById($tableName, '*', $where);
                $paymentRequest = $this->payDunyaObj->createOrder($updateInfo);
                // echo "<pre>";
                // print_r($paymentRequest);
                // echo $updateInfo['txnId'];
                if (isset($paymentRequest['response_code']) && $paymentRequest['response_code'] == '00' && isset($paymentRequest['token']) && $paymentRequest['token']) {
                    $txnId = $paymentRequest['token'];
                    $updateData = ['paymentRequest' => json_encode($paymentRequest), 'txnId' => $txnId];
                    $where = ['id' => $data['id']];
                    $result = $this->queryBuilder->update($tableName, $updateData, $where);
                    if ($result == 1) {
                        $paymentRequestColumnData = ['payment_gateway' => $activeGateway, 'screen' => $screenName, 'txnId' => $txnId, 'paymentDate' => date('Y-m-d H:i:s'), 'onlinePaymentId' => !empty($updateInfo['onlinePaymentId']) ? $updateInfo['onlinePaymentId'] : (isset($updateInfo['onlinePaymentId']) ? 0 : NULL), 'paymentId' => $updateInfo['id']];
                        $this->queryBuilder->insert('payment_request', $paymentRequestColumnData);
                        $columns = ['academyLocationId', 'txnId', 'gatewayConfig'];
                        $additionalConditions = "COALESCE(academyLocationId, '') <> '' AND COALESCE(txnId, '') <> ''";
                        $where = ['id' => $data['id']];
                        $result = $this->queryBuilder->selectById($tableName, $columns, $where, $additionalConditions);
                        $gatewayInfo = '';
                        if ($result && $result['gatewayConfig']) {
                            $gatewayInfoArr = json_decode($result['gatewayConfig'], true);
                            if (isset($gatewayInfoArr['masterKey']) && $gatewayInfoArr['masterKey'] && isset($gatewayInfoArr['privateKey']) && $gatewayInfoArr['privateKey'] && isset($gatewayInfoArr['token']) && $gatewayInfoArr['token'] && isset($gatewayInfoArr['environment']) && $gatewayInfoArr['environment']) {
                                $gatewayInfo = 'EXIT';
                            }
                        }
                        if (!$result || $result == 0 || $gatewayInfo == '') {
                            echo '<div class="col-md-12 text-center alert alert-warning">
                                <h4>Unfortunately, Your transaction could not be processed. Please try again.</h4>
                            </div>';
                        } else {
                            header('Location:' . $paymentRequest['response_text']);
                        }
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>Unfortunately, Your transaction could not be processed. Please try again.</h4>
                         </div>';
                    }
                } else {
                    $errorReson = isset($paymentRequest['response_text']) ? $paymentRequest['response_text'] : '';
                    if ($errorReson) {
                        $error = 'Unfortunately, Your transaction could not be processed. because ' . $errorReson . ' Please try again';
                    } else {
                        $error = 'Unfortunately, Your transaction could not be processed. Please try again.';
                    }
                    echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>' . $error . '</h4>
                             </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                      <h4>Unfortunately, Your transaction could not be processed. Please try again.</h4>
                      </div>';
            }
        }
    }

    public function declarationPaymentReceipt($paymentRequest, $connMain)
    {
        $txnId = $paymentRequest['txnId'];
        require_once("academia/declarationPayment.php");
        $tableName = 'declaration_payment';
        $declarationPaymentObj = new DeclarationPayment();
        $declarationPaymentObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];
        $declarationPaymentInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        if ($declarationPaymentInfo) {
            if ($declarationPaymentInfo['formSubmissionStatus'] != 1) {
                $orderInfo = $this->payDunyaObj->fetchOrder($declarationPaymentInfo);
                if (isset($orderInfo['response_code']) && $orderInfo['response_code'] == '00' && $orderInfo['status'] && $orderInfo['invoice']['token'] == $txnId) {
                    $updateData = ['notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1, 'paymentStatus' => $orderInfo['status']];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);

                    if ($orderInfo['status'] == 'completed') {
                        $declarationPaymentInfo['paymentStatus'] = $orderInfo['status'];
                        $response = $declarationPaymentObj->createReceipt($declarationPaymentInfo);
                        // print_r($response);die();
                        if (isset($response['status']) && $response['status'] == 'SUCCESS') {
                            $updateData = ['receiptStatus' => $response['status'], 'receiptId' => $response['receiptId']];
                            $where = ['id' => $paymentRequest['paymentId']];
                            $result = $this->queryBuilder->update($tableName, $updateData, $where);
                            echo '<div class="col-md-12 text-center alert alert-success">
                                        <h4>Declaration Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is ' . $txnId . '.<br /> Please close the window.</h4>
                                </div>';
                        } else {
                            echo '<div class="col-md-12 text-center alert alert-success">
                            <h4>Declaration Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is ' . $txnId . '.<br /> However, the receipt could not be generated. Please contact the administrator for assistance. You may now close this window..</h4>
                         </div>';
                        }
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-warning">
                                <h4>Your transaction status is ' . $orderInfo['status'] . '. Please try again.</h4>
                            </div>';
                    }
                } else {
                    $updateData = ['notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    echo '<div class="col-md-12 text-center alert alert-warning">
                    <h4>Unfortunately, Your transaction could not be processed becuase order details not found from payment gateway server.</h4>
                </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                <h4>Unfortunately, Your transaction could not be processed. Please try again.</h4>
            </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
              <h4>Unfortunately, Your transaction could not be processed becuase your order details not found. Please contact to administrator.</h4>
          </div>';
        }
    }

    public function onlinePaymentReceipt($paymentRequest, $connMain)
    {
        $txnId = $paymentRequest['txnId'];
        require_once "academia/onlinePayment.php";
        $tableName = 'online_payment';
        $onlinePaymentObj = new OnlinePayment();
        $onlinePaymentObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];
        $onlinePaymentInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        if ($onlinePaymentInfo) {
            if ($onlinePaymentInfo['formSubmissionStatus'] != 1) {
                $orderInfo = $this->payDunyaObj->fetchOrder($onlinePaymentInfo);
                if (isset($orderInfo['response_code']) && $orderInfo['response_code'] == '00' && $orderInfo['status'] && $orderInfo['invoice']['token'] == $txnId) {
                    $updateData = ['notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1, 'paymentStatus' => $orderInfo['status']];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);

                    if ($orderInfo['status'] == 'completed') {
                        $response = $onlinePaymentObj->createReceipt($onlinePaymentInfo['onlinePaymentId'], $txnId, $orderInfo['response_code']);
                        if ($response['status'] == 'SUCCESS') {
                            $updateData = ['receiptStatus' => $response['status'], 'receiptId' => $response['receiptId']];
                            $where = ['id' => $paymentRequest['paymentId']];
                            $result = $this->queryBuilder->update($tableName, $updateData, $where);
                            echo '<div class="col-md-12 text-center alert alert-success">
                                        <h4>Online Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is ' . $txnId . '.<br /> Please close the window.</h4>
                                </div>';
                        } else {
                            echo '<div class="col-md-12 text-center alert alert-success">
                            <h4>Online Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is ' . $txnId . '.<br /> However, the receipt could not be generated. Please contact the administrator for assistance. You may now close this window..</h4>
                         </div>';
                        }
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-warning">
                                <h4>Your transaction status is ' . $orderInfo['status'] . '. Please try again.</h4>
                            </div>';
                    }
                } else {
                    $updateData = ['notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    echo '<div class="col-md-12 text-center alert alert-warning">
                    <h4>Unfortunately, Your transaction could not be processed becuase order details not found from payment gateway server.</h4>
                </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                <h4>Unfortunately, Your transaction could not be processed. Please try again.</h4>
            </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
              <h4>Unfortunately, Your transaction could not be processed becuase your order details not found. Please contact to administrator.</h4>
          </div>';
        }
    }


    public function advancePaymentReceipt($paymentRequest, $connMain)
    {
        $txnId = $paymentRequest['txnId'];
        require_once "academia/advancePayment.php";
        $tableName = 'advance_payment';
        $advancePaymentObj = new AdvancePayment();
        $advancePaymentObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];
        $advancePaymentInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        if ($advancePaymentInfo) {
            if ($advancePaymentInfo['formSubmissionStatus'] != 1) {
                $orderInfo = $this->payDunyaObj->fetchOrder($advancePaymentInfo);
                if (isset($orderInfo['response_code']) && $orderInfo['response_code'] == '00' && $orderInfo['status'] && $orderInfo['invoice']['token'] == $txnId) {
                    $updateData = ['notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1, 'paymentStatus' => $orderInfo['status']];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);

                    if ($orderInfo['status'] == 'completed') {
                        $advancePaymentInfo['paymentStatus'] = $orderInfo['status'];
                        $response = $advancePaymentObj->createReceipt($advancePaymentInfo);

                        if ($response['status'] == 'SUCCESS') {
                            $updateData = ['receiptStatus' => $response['status'], 'receiptId' => $response['receiptId']];
                            $where = ['id' => $paymentRequest['paymentId']];
                            $result = $this->queryBuilder->update($tableName, $updateData, $where);
                            echo '<div class="col-md-12 text-center alert alert-success">
                                            <h4>Fee Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is ' . $txnId . '.<br /> Please close the window.</h4>
                                    </div>';
                        } else {
                            echo '<div class="col-md-12 text-center alert alert-success">
                                           <h4>Fee Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is ' . $txnId . '.<br /> However, the receipt could not be generated. Please contact the administrator for assistance. You may now close this window..</h4>
                                        </div>';
                        }
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-warning">
                                <h4>Your transaction status is ' . $orderInfo['status'] . '. Please try again.</h4>
                            </div>';
                    }
                } else {
                    $updateData = ['notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    echo '<div class="col-md-12 text-center alert alert-warning">
                                    <h4>Your transaction status is ' . $orderInfo['ResponseMessage'] . '. Please try again.</h4>
                            </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>Unfortunately, Your transaction could not be processed. Please try again.</h4>
                    </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
              <h4>Unfortunately, Your transaction could not be processed becuase your order details not found. Please contact to administrator.</h4>
          </div>';
        }
    }


    public function sendPaymentLinkReceipt($paymentRequest, $connMain)
    {
        $txnId = $paymentRequest['txnId'];
        require_once("academia/sendPaymentLinkPayment.php");
        $tableName = 'online_payment';
        $sendPaymentLinkObj = new SendPaymentLinkPayment();
        $sendPaymentLinkObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];
        $sendPaymentLinkInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        if ($sendPaymentLinkInfo) {
            if ($sendPaymentLinkInfo['formSubmissionStatus'] != 1) {
                $orderInfo = $this->payDunyaObj->fetchOrder($sendPaymentLinkInfo);
                if (isset($orderInfo['response_code']) && $orderInfo['response_code'] == '00' && $orderInfo['status'] && $orderInfo['invoice']['token'] == $txnId) {
                    $updateData = ['notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1, 'paymentStatus' => $orderInfo['status']];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);

                    if ($orderInfo['status'] == 'completed') {
                        $response = $sendPaymentLinkObj->createReceipt($sendPaymentLinkInfo['sendPaymentLinkId'],$sendPaymentLinkInfo['onlinePaymentId'], $txnId, $orderInfo['response_code']);

                        if ($response == 'SUCCESS') {
                            $updateData = ['receiptStatus' => $response];
                            $where = ['id' => $paymentRequest['paymentId']];
                            $result = $this->queryBuilder->update($tableName, $updateData, $where);
                            echo '<div class="col-md-12 text-center alert alert-success">
                                        <h4>Your Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is ' . $txnId . '.<br /> Please close the window.</h4>
                                </div>';
                        } else {
                            echo '<div class="col-md-12 text-center alert alert-warning">
                                    <h4>Your transaction status is ' . $orderInfo['status'] . '. Please try again.</h4>
                                </div>';
                        }
                    } else {
                        $updateData = ['notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $this->queryBuilder->update($tableName, $updateData, $where);
                        echo '<div class="col-md-12 text-center alert alert-warning">
                                <h4>Unfortunately, Your transaction could not be processed becuase order details not found from payment gateway server.</h4>
                            </div>';
                    }
                } else {
                    echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>Unfortunately, Your transaction could not be processed. Please try again.</h4>
                        </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                  <h4>Unfortunately, Your transaction could not be processed becuase your order details not found. Please contact to administrator.</h4>
              </div>';
            }
        }
    }

    public function RevaluationReceipt($paymentRequest, $connMain)
    {
        $txnId = $paymentRequest['txnId'];
        require_once("academia/revaluationPayment.php");
        $tableName = 'reval_payment';
        $revalObj = new RevaluationPayment();
        $revalObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];
        $revalInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        if ($revalInfo) {
            if ($revalInfo['formSubmissionStatus'] != 1) {
                $orderInfo = $this->payDunyaObj->fetchOrder($revalInfo);
                if (isset($orderInfo['response_code']) && $orderInfo['response_code'] == '00' && $orderInfo['status'] && $orderInfo['invoice']['token'] == $txnId) {
                    $updateData = ['notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1, 'paymentStatus' => $orderInfo['status']];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);

                    if ($orderInfo['status'] == 'completed') {
                        $response = $revalObj->createReceipt($revalInfo['id'], $revalInfo['amount'], $txnId, $orderInfo['response_code']);
                        if (isset($response) && isset($response['status']) == 'SUCCESS') {
                            $updateData = ['receiptStatus' => $response];
                            $where = ['id' => $paymentRequest['paymentId']];
                            $result = $this->queryBuilder->update($tableName, $updateData, $where);
                            echo '<div class="col-md-12 text-center alert alert-success">
                                        <h4>Fee Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is ' . $txnId . '.<br /> Please close the window.</h4>
                             </div>';
                        } else {
                            echo '<div class="col-md-12 text-center alert alert-success">
                                    <h4>Fee Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is ' . $txnId . '.<br /> However, the receipt could not be generated. Please contact the administrator for assistance. You may now close this window..</h4>
                        </div>';
                        }
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>Your transaction status is ' . $orderInfo['status'] . '. Please try again.</h4>
                        </div>';
                    }
                } else {
                    $updateData = ['notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    echo '<div class="col-md-12 text-center alert alert-warning">
                                    <h4>Your transaction status is ' . $orderInfo['ResponseMessage'] . '. Please try again.</h4>
                            </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
            <h4>Unfortunately, Your transaction could not be processed. Please try again.</h4>
        </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
          <h4>Unfortunately, Your transaction could not be processed becuase your order details not found. Please contact to administrator.</h4>
      </div>';
        }
    }

    public function examAssessmentReceipt($paymentRequest, $connMain)
    {
        $txnId = $paymentRequest['txnId'];
        require_once "academia/examinationPayment.php";
        $tableName = 'assessment_payment';
        $examObj = new ExaminationPayment();
        $examObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];
        $examInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        if ($examInfo) {
            if ($examInfo['formSubmissionStatus'] != 1) {
                $activeGateway = $examInfo['paymentOption'];
                $orderInfo = $this->payDunyaObj->fetchOrder($examInfo);
                if (isset($orderInfo['response_code']) && $orderInfo['response_code'] == '00' && $orderInfo['status'] && $orderInfo['invoice']['token'] == $txnId) {
                    $updateData = ['notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1, 'paymentStatus' => $orderInfo['status']];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);

                    if ($orderInfo['status'] == 'completed') {
                        $response = $examObj->createReceipt($examInfo['id'], $examInfo['academyLocationId'], $txnId, $examInfo['amount'],$examInfo['currency']);

                        if (isset($response['status']) && $response['status'] == 'SUCCESS') {
                            $updateData = ['receiptStatus' => $response['status']];
                            $where = ['id' => $paymentRequest['paymentId']];
                            $result = $this->queryBuilder->update($tableName, $updateData, $where);
                            $tableName2 = 'assessment_payment_detail';
                            $updateDataDetail = ['receiptId' => $response['receiptId']];
                            $updateWhere = ['examAssessmentPaymentId' => $paymentRequest['paymentId']];
                            $result2 = $this->queryBuilder->update($tableName2, $updateDataDetail, $updateWhere);
                            echo '<div class="col-md-12 text-center alert alert-success">
                                            <h4>Exam Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is ' . $txnId . '.<br /> Please close the window.</h4>
                                    </div>';
                        } else {
                            echo '<div class="col-md-12 text-center alert alert-success">
                                <h4>Exam Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is ' . $txnId . '.<br /> However, the receipt could not be generated. Please contact the administrator for assistance. You may now close this window..</h4>
                             </div>';
                        }
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-warning">
                                <h4>Your transaction status is ' . $orderInfo['status'] . '. Please try again.</h4>
                            </div>';
                    }
                } else {
                    $updateData = ['notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>Your transaction status is ' . $orderInfo['ResponseMessage'] . '. Please try again.</h4>
                         </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                <h4>Unfortunately, Your transaction could not be processed. Please try again.</h4>
            </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
            <h4>Unfortunately, Your transaction could not be processed becuase your order details not found. Please contact to administrator.</h4>
        </div>';
        }
    }

    public function courseEnrollementPaymentReceipt($paymentRequest, $connMain)
    {
        $txnId = $paymentRequest['txnId'];
        require_once "academia/courseEnrollement.php";
        $tableName = 'enrollment_payment';
        $courseEnrollementPaymentObj = new CourseEnrollement();
        $courseEnrollementPaymentObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['paymentId'], 'txnId' => $txnId];
        $courseEnrollementInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        if ($courseEnrollementInfo) {
            if ($courseEnrollementInfo['formSubmissionStatus'] != 1) {
                $orderInfo = $this->payDunyaObj->fetchOrder($courseEnrollementInfo);
                if (isset($orderInfo['response_code']) && $orderInfo['response_code'] == '00' && $orderInfo['status'] && $orderInfo['invoice']['token'] == $txnId) {
                    $updateData = ['notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1, 'paymentStatus' => $orderInfo['status']];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    if ($orderInfo['status'] == 'completed') {
                        $response = $courseEnrollementPaymentObj->createReceipt($courseEnrollementInfo['onlinePaymentId'], $txnId, $orderInfo['response_code']);
                        if ($response == 'SUCCESS') {
                            $updateData = ['receiptStatus' => $response];
                            $where = ['id' => $paymentRequest['paymentId']];
                            $result = $this->queryBuilder->update($tableName, $updateData, $where);
                            echo '<div class="col-md-12 text-center alert alert-success">
                                 <h4>Fee Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is ' . $txnId . '.<br /> Please close the window.</h4>
                         </div>';
                        } else {
                            echo '<div class="col-md-12 text-center alert alert-success">
                               <h4>Fee Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is ' . $txnId . '.<br /> However, the receipt could not be generated. Please contact the administrator for assistance. You may now close this window..</h4>
                            </div>';
                        }
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>Your transaction status is ' . $orderInfo['status'] . '. Please try again.</h4>
                        </div>';
                    }
                } else {
                    $updateData = ['notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>Your transaction status is ' . $orderInfo['ResponseMessage'] . '. Please try again.</h4>
                </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
            <h4>Unfortunately, Your transaction could not be processed. Please try again.</h4>
        </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
          <h4>Unfortunately, Your transaction could not be processed becuase your order details not found. Please contact to administrator.</h4>
      </div>';
        }
    }
}
