<?php
require_once("stripePaymentGateway.php");
require_once("./config/QueryBuilder.php");

class PaymentRequest
{
    private $conn;
    private $queryBuilder;

    private $stripeObj;

    public function __construct($conn)
    {
        $this->conn = $conn;
        $this->queryBuilder = new QueryBuilder($conn);
        $this->stripeObj = new StripePaymentGateway();
    }

    public function paymentRequest($data, $screenName, $tableName, $merchantDetails)
    {
        
        if ($data['gatewayConfig']) {
            echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>Please try again later because Transaction ID already generated for this order.</h4>
                    </div>';
        } else {
            if($data['phoneNo']){
                if($data['email']){             
                  
                  $gatewayJSON = <<<GATEWAYJSON
                  {
                      "secretKey": "{$merchantDetails['secretKey']}",
                      "publicKey": "{$merchantDetails['publicKey']}",
                      "env": "{$merchantDetails['environment']}",
                      "currencyCode": "{$merchantDetails['currencyCode']}"               
                  }
                GATEWAYJSON;                
                  $activeGateway = $data['paymentOption'];
                  $gateway = json_decode($gatewayJSON, true);
                  if (json_last_error() !== JSON_ERROR_NONE) {
                      echo 'JSON Error: ' . json_last_error_msg();
                      die();
                  }
                  $updateData = ['gatewayConfig' => $gatewayJSON, 'academyLocationId' => $data['academyLocationId'], 'paymentOption' => $activeGateway , 'paymentDate' => date('Y-m-d H:i:s')];
                  $where = ['id' => $data['id']];
                  $result = $this->queryBuilder->update($tableName, $updateData, $where);
                  if ($result == 1) {
                      $paymentRequestColumnData = ['screen' => $screenName, 'txnId' => '', 'paymentDate' => date('Y-m-d H:i:s'), 'onlinePaymentId' => !empty($data['onlinePaymentId']) ? $data['onlinePaymentId'] : (isset($data['onlinePaymentId']) ? 0 : NULL), 'paymentId' => $data['id'], 'payment_gateway' => $activeGateway];
                      $this->queryBuilder->insert('payment_request', $paymentRequestColumnData);

                      $where = ['id' => $data['id']];
                      $paymentDetails = $this->queryBuilder->selectById($tableName, '*', $where);
                      $gatewayInfo = '';
                      if ($paymentDetails && $paymentDetails['gatewayConfig']) {
                          $gatewayInfoArr = json_decode($paymentDetails['gatewayConfig'], true);

                          if (isset($gatewayInfoArr['secretKey']) && $gatewayInfoArr['secretKey'] && isset($gatewayInfoArr['publicKey']) && $gatewayInfoArr['publicKey']  && isset($gatewayInfoArr['currencyCode']) && $gatewayInfoArr['currencyCode'] && isset($gatewayInfoArr['env']) && $gatewayInfoArr['env']) {
                              $gatewayInfo = 'EXIST';
                          }
                      }
                      if (!$paymentDetails || $paymentDetails == 0 || $gatewayInfo = '') {

                          echo '<div class="col-md-12 text-center alert alert-warning">
                                  <h4>Unfortunately, Your transaction could not be processed. Please try again.<h4>
                                </div>';
                      } else {
                          // echo domainURL;
                          $paymentDetails['screenName'] = $screenName;
                          $paymentRequest = $this->stripeObj->createOrder($paymentDetails, $gateway);
                          $updateData = ['paymentRequest' => json_encode($paymentRequest)];
                          $where = ['id' => $data['id']];
                          $result = $this->queryBuilder->update($tableName, $updateData, $where);
                          echo $paymentRequest;
                      }
                  }
                }
                else{
                    echo '<div class="col-md-12 text-center alert alert-warning">
                    <h4>Unfortunately, Your transaction could not be processed becuase email is not register. Please registered and try again.</h4>
                  </div>';
                }
                  }else{
                echo '<div class="col-md-12 text-center alert alert-warning">
                <h4>Unfortunately, Your transaction could not be processed becuase phone no is not register. Please registered and try again.</h4>
              </div>';
            }
        }
              
    }

       public function onlinePaymentReceipt($paymentRequest, $connMain)
    {
        $onlinePaymentId = $paymentRequest['data']['onlinePaymentId'];
        require_once "academia/onlinePayment.php";
        $tableName = 'online_payment';
        $onlinePaymentObj = new OnlinePayment();
        $onlinePaymentObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['data']['id'], 'onlinePaymentId' => $onlinePaymentId];
        $onlinePaymentInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        $onlinePaymentInfo['stripeData'] =  $paymentRequest['data'];
        if ($onlinePaymentInfo) {
            if ($onlinePaymentInfo['formSubmissionStatus'] != 1) {    
                $activeGateway = $onlinePaymentInfo['paymentOption'];              
                $orderInfo = $this->stripeObj->fetchOrder($onlinePaymentInfo);   
                if (isset($orderInfo['stripeId']) && $orderInfo['txnId'] && $orderInfo['transactionStatus'] == 'Success') {
                    $updateData = ['notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1,'txnId'=>$orderInfo['stripeId'],'paymentStatus' => $orderInfo['transactionStatus']];
                    $where = ['id' => $paymentRequest['data']['id']];
                    $this->queryBuilder->update($tableName, $updateData, $where);                
                        $response = $onlinePaymentObj->createReceipt($onlinePaymentInfo['onlinePaymentId'],$orderInfo['stripeId'],$orderInfo['transactionStatus']);
                        if ($response == 'SUCCESS') {
                            $updateData = ['receiptStatus'=> $response];
                            $where = ['id' => $paymentRequest['paymentId']];
                            $result = $this->queryBuilder->update($tableName, $updateData, $where);
                            echo '<div class="col-md-12 text-center alert alert-success">
                                        <h4>Online Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is ' . $orderInfo['stripeId'] . '.<br /> Please close the window.</h4>
                                </div>';
                        } else {
                            echo '<div class="col-md-12 text-center alert alert-success">
                            <h4>Online Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is ' . $orderInfo['stripeId'] . '.<br /> However, the receipt could not be generated. Please contact the administrator for assistance. You may now close this window..</h4>
                         </div>';
                        }
                  
                } else {
                    $updateData = ['paymentStatus'=> isset($orderInfo['error'])?$orderInfo['error']:'','notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1];
                    $where = ['id' => $paymentRequest['data']['id']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    echo '<div class="col-md-12 text-center alert alert-warning">
                    <h4>Unfortunately, Your transaction could not be processed becuase '.$orderInfo['error'].'</h4>
                </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                <h4>Unfortunately, Your transaction could not be processed. Please try again.</h4>
            </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
              <h4>Unfortunately, Your transaction could not be processed becuase your order details not found. Please contact to administrator.</h4>
          </div>';
        }
    }

    public function declarationPaymentReceipt($paymentRequest, $connMain)
    {
        $onlinePaymentId = $paymentRequest['data']['onlinePaymentId'];
        require_once "academia/declarationPayment.php";
        $tableName = 'declaration_payment';
        $declarationPaymentObj = new DeclarationPayment();
        $declarationPaymentObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['data']['id'], 'onlinePaymentId' => $onlinePaymentId];
        $declarationPaymentInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        $declarationPaymentInfo['stripeData'] =  $paymentRequest['data'];
        if ($declarationPaymentInfo) {
            if ($declarationPaymentInfo['formSubmissionStatus'] != 1) {
                $activeGateway = $declarationPaymentInfo['paymentOption'];               
                    $orderInfo = $this->stripeObj->fetchOrder($declarationPaymentInfo);                    
                    if (isset($orderInfo['stripeId']) && $orderInfo['txnId'] && $orderInfo['transactionStatus'] == 'Success') {
                        $updateData = ['notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1,'txnId'=>$orderInfo['stripeId'],'paymentStatus' => $orderInfo['transactionStatus']];
                        $where = ['id' => $paymentRequest['data']['id']];
                        $this->queryBuilder->update($tableName, $updateData, $where);
                        $where2 = ['id' => $paymentRequest['data']['id'], 'onlinePaymentId' => $onlinePaymentId];
                        $declarationPaymentInfo2 = $this->queryBuilder->selectById($tableName, '*', $where2);                      
                            $response = $declarationPaymentObj->createReceipt($declarationPaymentInfo2);
                            if (isset($response['status']) && $response['status'] == 'SUCCESS') {
                                $updateData = ['receiptStatus' => $response['status'], 'receiptId' => $response['receiptId']];
                                $where = ['id' => $paymentRequest['paymentId']];
                                $result = $this->queryBuilder->update($tableName, $updateData, $where);
                                echo '<div class="col-md-12 text-center alert alert-success">
                                        <h4>Declaration Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is ' . $orderInfo['stripeId'] . '.<br /> Please close the window.</h4>
                                </div>';
                            } else {
                                echo '<div class="col-md-12 text-center alert alert-success">
                                <h4>Declaration Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is ' . $orderInfo['stripeId'] . '.<br /> However, the receipt could not be generated. Please contact the administrator for assistance. You may now close this window..</h4>
                             </div>';
                            }
                    } else {
                        $updateData = ['paymentStatus'=> isset($orderInfo['error'])?$orderInfo['error']:'','notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1];
                        $where = ['id' => $paymentRequest['data']['id']];
                        $this->queryBuilder->update($tableName, $updateData, $where);
                        echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>Your transaction status is ' . $orderInfo['error'] . '. Please try again.</h4>
                        </div>';
                    }


            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
              <h4>Unfortunately, Your transaction could not be processed becuase your order details not found. Please contact to administrator.</h4>
          </div>';
            }
        }else
        {
            echo '<div class="col-md-12 text-center alert alert-warning">
            <h4>Unfortunately, Your transaction could not be processed becuase your order details not found. Please contact to administrator.</h4>
        </div>';
        }
    }

    public function examAssessmentReceipt($paymentRequest, $connMain)
    {
        
        require_once "academia/examinationPayment.php";
        $tableName = 'assessment_payment';
        $examObj = new ExaminationPayment();
        $examObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['data']['id']];
        $examInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        $examInfo['stripeData'] = $paymentRequest['data'];
        if ($examInfo) {
            if ($examInfo['formSubmissionStatus'] != 1) {                
                $orderInfo = $this->stripeObj->fetchOrder($examInfo);
                if (isset($orderInfo['stripeId']) && $orderInfo['txnId'] && $orderInfo['transactionStatus'] == 'Success') {
                    $updateData = ['notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1,'txnId'=>$orderInfo['stripeId'],'paymentStatus' => $orderInfo['transactionStatus']];
                    $where = ['id' => $paymentRequest['data']['id']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    $response = $examObj->createReceipt($examInfo['id'], $examInfo['academyLocationId'],$orderInfo['stripeId'], $examInfo['amount'],$examInfo['currency']);
                    if (isset($response['status']) && $response['status'] == 'SUCCESS') {
                        $updateData = ['receiptStatus' => $response['status']];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $result = $this->queryBuilder->update($tableName, $updateData, $where);
                        $tableName2 = 'assessment_payment_detail';
                        $updateDataDetail = ['receiptId' => $response['receiptId']];
                        $updateWhere = ['examAssessmentPaymentId' => $paymentRequest['paymentId']];
                        $result2 = $this->queryBuilder->update($tableName2, $updateDataDetail, $updateWhere);
                        echo '<div class="col-md-12 text-center alert alert-success">
                                        <h4>Exam Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is ' . $orderInfo['stripeId'] . '.<br /> Please close the window.</h4>
                                </div>';
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-success">
                            <h4>Exam Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is ' . $orderInfo['stripeId'] . '.<br /> However, the receipt could not be generated. Please contact the administrator for assistance. You may now close this window..</h4>
                         </div>';
                    }
                } else {
                    $updateData = ['paymentStatus'=> isset($orderInfo['error'])?$orderInfo['error']:'','notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>Your transaction status is ' . $orderInfo['error'] . '. Please try again.</h4>
                         </div>';
                }

            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                <h4>Unfortunately, Your transaction could not be processed. Please try again.</h4>
            </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
            <h4>Unfortunately, Your transaction could not be processed becuase your order details not found. Please contact to administrator.</h4>
        </div>';
        }
    }

    public function courseEnrollementPaymentReceipt($paymentRequest, $connMain)
    {
        $onlinePaymentId = $paymentRequest['data']['onlinePaymentId'];
        require_once "academia/courseEnrollement.php";
        $tableName = 'enrollment_payment';
        $courseEnrollementPaymentObj = new CourseEnrollement();
        $courseEnrollementPaymentObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['data']['id'], 'onlinePaymentId' => $onlinePaymentId];
        $courseEnrollementInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        $courseEnrollementInfo['stripeData'] =  $paymentRequest['data'];
        if ($courseEnrollementInfo) {
            if ($courseEnrollementInfo['formSubmissionStatus'] != 1) {
                $activeGateway = $courseEnrollementInfo['paymentOption'];
                $orderInfo = $this->stripeObj->fetchOrder($courseEnrollementInfo);
                if (isset($orderInfo['stripeId']) && $orderInfo['txnId'] && $orderInfo['transactionStatus'] == 'Success') {
                    $updateData = ['notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1,'txnId'=>$orderInfo['stripeId'],'paymentStatus' => $orderInfo['transactionStatus']];
                    $where = ['id' => $paymentRequest['data']['id']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    $response = $courseEnrollementPaymentObj->createReceipt($courseEnrollementInfo['onlinePaymentId'], $orderInfo['stripeId'],$orderInfo['transactionStatus'] );
                    if ($response == 'SUCCESS') { 
                        $updateData = ['receiptStatus'=> $response];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $result = $this->queryBuilder->update($tableName, $updateData, $where);
                        echo '<div class="col-md-12 text-center alert alert-success">
                                 <h4>Fee Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is ' . $orderInfo['stripeId'] . '.<br /> Please close the window.</h4>
                         </div>';
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-success">
                               <h4>Fee Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is ' . $orderInfo['stripeId'] . '.<br /> However, the receipt could not be generated. Please contact the administrator for assistance. You may now close this window..</h4>
                            </div>';
                    }
                } else {
                    $updateData = ['paymentStatus'=> isset($orderInfo['error'])?$orderInfo['error']:'','notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1];
                    $where = ['id' => $paymentRequest['data']['id']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>Your transaction status is ' . $orderInfo['error'] . '. Please try again.</h4>
                    </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
              <h4>Unfortunately, Your transaction could not be processed becuase your order details not found. Please contact to administrator.</h4>
          </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
            <h4>Unfortunately, Your transaction could not be processed becuase your order details not found. Please contact to administrator.</h4>
        </div>';
        }
    }

    public function RevaluationReceipt($paymentRequest, $connMain)
    {
        require_once("academia/revaluationPayment.php");
        $tableName = 'reval_payment';
        $revalObj = new RevaluationPayment();
        $revalObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['data']['id']];
        $revalInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        $revalInfo['stripeData'] =  $paymentRequest['data'];
        if ($revalInfo) {
            if ($revalInfo['formSubmissionStatus'] != 1) {
                $activeGateway = $revalInfo['paymentOption'];
                $orderInfo = $this->stripeObj->fetchOrder($revalInfo);
                if (isset($orderInfo['stripeId']) && $orderInfo['txnId'] && $orderInfo['transactionStatus'] == 'Success') {
                    $updateData = ['notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1,'txnId'=>$orderInfo['stripeId'],'paymentStatus' => $orderInfo['transactionStatus']];
                    $where = ['id' => $paymentRequest['data']['id']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    $response = $revalObj->createReceipt($revalInfo['id'], $revalInfo['amount'], $orderInfo['stripeId'],$orderInfo['transactionStatus']);
                    if (isset($response['status']) && $response['status'] == 'SUCCESS') {
                        $updateData = ['receiptStatus' => $response['status']];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $result = $this->queryBuilder->update($tableName, $updateData, $where);
                        echo '<div class="col-md-12 text-center alert alert-success">
                                        <h4>Fee Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is ' . $orderInfo['stripeId'] . '.<br /> Please close the window.</h4>
                             </div>';
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-success">
                                <h4>Fee Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is ' . $orderInfo['stripeId'] . '.<br /> However, the receipt could not be generated. Please contact the administrator for assistance. You may now close this window..</h4>
                    </div>';
                    }
                } else {
                    $updateData = ['paymentStatus'=> isset($orderInfo['error'])?$orderInfo['error']:'','notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1];
                    $where = ['id' => $paymentRequest['data']['id']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>Your transaction status is ' . $orderInfo['error'] . '. Please try again.</h4>
                    </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
              <h4>Unfortunately, Your transaction could not be processed becuase your order details not found. Please contact to administrator.</h4>
          </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
            <h4>Unfortunately, Your transaction could not be processed becuase your order details not found. Please contact to administrator.</h4>
        </div>';
        }
    }

    public function advancePaymentReceipt($paymentRequest, $connMain)
    {
        $onlinePaymentId = $paymentRequest['data']['onlinePaymentId'];
        require_once "academia/advancePayment.php";
        $tableName = 'advance_payment';
        $advancePaymentObj = new AdvancePayment();
        $advancePaymentObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['data']['id'], 'onlinePaymentId' => $onlinePaymentId];
        $advancePaymentInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        $advancePaymentInfo['stripeData'] =  $paymentRequest['data'];
        if ($advancePaymentInfo) {
            if ($advancePaymentInfo['formSubmissionStatus'] != 1) {
                $orderInfo = $this->stripeObj->fetchOrder($advancePaymentInfo);
                if (isset($orderInfo['stripeId']) && $orderInfo['txnId'] && $orderInfo['transactionStatus'] == 'Success') {
                    $updateData = ['notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1,'txnId'=>$orderInfo['stripeId'],'paymentStatus' => $orderInfo['transactionStatus']];
                    $where = ['id' => $paymentRequest['data']['id']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    $where2 = ['id' => $paymentRequest['data']['id'], 'onlinePaymentId' => $onlinePaymentId];
                    $advancePaymentInfo2 = $this->queryBuilder->selectById($tableName, '*', $where2);
                    $response = $advancePaymentObj->createReceipt($advancePaymentInfo2);
                    if (isset($response['status']) && $response['status'] == 'SUCCESS') {
                        $updateData = ['receiptStatus' => $response['status'], 'receiptId' => $response['receiptId']];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $result = $this->queryBuilder->update($tableName, $updateData, $where);
                        echo '<div class="col-md-12 text-center alert alert-success">
                                <h4>Fee Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is ' . $orderInfo['stripeId'] . '.<br /> Please close the window.</h4>
                            </div>';
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-success">
                        <h4>Fee Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is ' . $orderInfo['stripeId'] . '.<br /> However, the receipt could not be generated. Please contact the administrator for assistance. You may now close this window..</h4>
                     </div>';
                    }
                } else {
                    $updateData = ['paymentStatus'=> isset($orderInfo['error'])?$orderInfo['error']:'','notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1];
                    $where = ['id' => $paymentRequest['paymentId']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>Your transaction status is ' . $orderInfo['error'] . '. Please try again.</h4>
                         </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                <h4>Unfortunately, Your transaction could not be processed. Please try again.</h4>
            </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
            <h4>Unfortunately, Your transaction could not be processed becuase your order details not found. Please contact to administrator.</h4>
        </div>';
        }
    }

    public function sendPaymentLinkReceipt($paymentRequest, $connMain)
    {
        $onlinePaymentId = $paymentRequest['data']['onlinePaymentId'];
        require_once("academia/sendPaymentLinkPayment.php");
        $tableName = 'online_payment';
        $sendPaymentLinkObj = new SendPaymentLinkPayment();
        $sendPaymentLinkObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['data']['id'], 'onlinePaymentId' => $onlinePaymentId];
        $sendPaymentLinkInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        $sendPaymentLinkInfo['stripeData'] =  $paymentRequest['data'];
        if ($sendPaymentLinkInfo) {
            if ($sendPaymentLinkInfo['formSubmissionStatus'] != 1) {
                $orderInfo = $this->stripeObj->fetchOrder($sendPaymentLinkInfo);
                if (isset($orderInfo['stripeId']) && $orderInfo['txnId'] && $orderInfo['transactionStatus'] == 'Success') {
                    $updateData = ['notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1,'txnId'=>$orderInfo['stripeId'],'paymentStatus' => $orderInfo['transactionStatus']];
                    $where = ['id' => $paymentRequest['data']['id']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    $where = ['id' => $paymentRequest['data']['id'], 'onlinePaymentId' => $onlinePaymentId];
                    $sendPaymentLinkInfo = $this->queryBuilder->selectById($tableName, '*', $where);
                    $response = $sendPaymentLinkObj->createReceipt($sendPaymentLinkInfo['sendPaymentLinkId'],$sendPaymentLinkInfo['onlinePaymentId'], $orderInfo['stripeId'],$orderInfo['transactionStatus']);                    
                    if ($response == 'SUCCESS') { 
                        $updateData = ['receiptStatus'=> $response];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $result = $this->queryBuilder->update($tableName, $updateData, $where);
                        echo '<div class="col-md-12 text-center alert alert-success">
                                 <h4>Fee Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is ' . $orderInfo['stripeId'] . '.<br /> Please close the window.</h4>
                         </div>';
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-success">
                                <h4>Fee Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is ' . $orderInfo['stripeId'] . '.<br /> However, the receipt could not be generated. Please contact the administrator for assistance. You may now close this window..</h4>
                    </div>';
                    }
                } else {
                    $updateData = ['paymentStatus'=> isset($orderInfo['error'])?$orderInfo['error']:'','notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1];
                    $where = ['id' => $paymentRequest['data']['id']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>Your transaction status is ' . $orderInfo['error'] . '. Please try again.</h4>
                    </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
              <h4>Unfortunately, Your transaction could not be processed becuase your order details not found. Please contact to administrator.</h4>
          </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
            <h4>Unfortunately, Your transaction could not be processed becuase your order details not found. Please contact to administrator.</h4>
        </div>';
        }
    }

    public function donationPaymentReceipt($paymentRequest, $connMain)
    {
        $onlinePaymentId = $paymentRequest['data']['onlinePaymentId'];
        require_once("academia/donationPayment.php");
        $tableName = 'donation_payment';
        $donationObj = new DonationPayment();
        $donationObj->setConnection($this->conn, $connMain);
        $where = ['id' => $paymentRequest['data']['id'], 'onlinePaymentId' => $onlinePaymentId];
        $donationInfo = $this->queryBuilder->selectById($tableName, '*', $where);
        $donationInfo['stripeData'] =  $paymentRequest['data'];
        if ($donationInfo) {
            if ($donationInfo['formSubmissionStatus'] != 1) {    
                $orderInfo = $this->stripeObj->fetchOrder($donationInfo);   
                if (isset($orderInfo['stripeId']) && $orderInfo['transactionStatus'] == 'Success') {
                    $updateData = ['notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1,'txnId'=>$orderInfo['stripeId'],'paymentStatus' => $orderInfo['transactionStatus']];
                    $where = ['id' => $paymentRequest['data']['id']];
                    $this->queryBuilder->update($tableName, $updateData, $where);       
                    $donationInfo['txnId'] = $orderInfo['stripeId'];         
                    $response = $donationObj->createReceipt($donationInfo, 'TXN_SUCCESS');
                        if ($response == 'SUCCESS') {
                            $updateData = ['receiptStatus'=> $response];
                            $where = ['id' => $paymentRequest['paymentId']];
                            $result = $this->queryBuilder->update($tableName, $updateData, $where);
                            echo '<div class="col-md-12 text-center alert alert-success">
                                        <h4>Online Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is ' . $orderInfo['stripeId'] . '.<br /> Please close the window.</h4>
                                </div>';
                        } else {
                            echo '<div class="col-md-12 text-center alert alert-success">
                            <h4>Online Payment is successful !!!.<br /><br />Thank you for the payment. Your Transaction id is ' . $orderInfo['stripeId'] . '.<br /> However, the receipt could not be generated. Please contact the administrator for assistance. You may now close this window..</h4>
                         </div>';
                        }
                  
                } else {
                    $updateData = ['paymentStatus'=> isset($orderInfo['error'])?$orderInfo['error']:'','notificationResponse' => json_encode($orderInfo), 'formSubmissionStatus' => 1];
                    $where = ['id' => $paymentRequest['data']['id']];
                    $this->queryBuilder->update($tableName, $updateData, $where);
                    echo '<div class="col-md-12 text-center alert alert-warning">
                    <h4>Unfortunately, Your transaction could not be processed becuase '.$orderInfo['error'].'</h4>
                </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                <h4>Unfortunately, Your transaction could not be processed. Please try again.</h4>
            </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
              <h4>Unfortunately, Your transaction could not be processed becuase your order details not found. Please contact to administrator.</h4>
          </div>';
        }
    }

}